package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.CbwdEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.service.CbwdService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 承办网点信息
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 16:36:52
 */
@RestController
@RequestMapping("app/cbwd")
@Api(tags = "承办网点信息模块(承办网点信息设置)")
public class CbwdController {

	@Autowired
	private CbwdService cbwdService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = CbwdEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, CbwdEntity cbwdEntity) {

		return R.ok().put("data", cbwdService.queryByPage(pageNum, pageSize, cbwdEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = CbwdEntity.class)
	public R insert(@RequestBody CbwdEntity cbwdEntity) {
		String a=cbwdService.querycbwdbm();
		String b = a.substring(0, 3);
		String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
		String cbwdbm = b + c;
		cbwdEntity.setCbwdbm(cbwdbm);
		cbwdEntity.setGzdbm("0001");
		cbwdService.insert(cbwdEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/update")
	@ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = CbwdEntity.class)
	public R update(@RequestBody CbwdEntity cbwdEntity) {
		cbwdService.updateById(cbwdEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = CbwdEntity.class)
	public R delete(@RequestBody String[] ids) {
		cbwdService.deleteBatch(ids);
		return R.ok();
	}

	@Login
	@PostMapping("/select")
	@ApiOperation(value = "编辑查询", notes = "在此补充接口详细注释...", response = CbwdEntity.class)
	public R select(@RequestBody String id) {

		return R.ok().put("select", cbwdService.selectById(id));
	}

	@Login
	@PostMapping("/selectyhxlk")
	@ApiOperation(value = "银行信息下拉框", notes = "在此补充接口详细注释...", response = XlkEntity.class)
	public R selectyhxlk() {

		return R.ok().put("select", cbwdService.selectYhxx());
	}

}
