package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.entity.Cxtj_CxtjCfzhEntity;
import io.renren.modules.app.entity.Cxtj_CxtjCqrbgEntity;
import io.renren.modules.app.entity.Cxtj_CxtjCsbEntity;
import io.renren.modules.app.entity.Cxtj_CxtjFwbgEntity;
import io.renren.modules.app.entity.Cxtj_CxtjFwwxqkEntity;
import io.renren.modules.app.entity.Cxtj_CxtjGgsyfpEntity;
import io.renren.modules.app.entity.Cxtj_CxtjJkcxEntity;
import io.renren.modules.app.entity.Cxtj_CxtjTyEntity;
import io.renren.modules.app.entity.Cxtj_CxtjZqcxEntity;
import io.renren.modules.app.entity.Cxtj_CxtjZzcxEntity;
import io.renren.modules.app.entity.Cxtj_GrjcHstjEntity;
import io.renren.modules.app.entity.Cxtj_GrjcJcybEntity;
import io.renren.modules.app.entity.Cxtj_GrjcqkEntity;
import io.renren.modules.app.service.Cxtj_FhmxzService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 查询统计 -分户明细账
 *
 * @author wt
 * @email 1271428398@qq.com
 * @date 2019-04-19 00:00:00
 */
@RestController
@RequestMapping("app/cxtj_fhmxz")
@Api(tags = "查询统计 -分户明细账")
public class Cxtj_FhmxzController {

	@Autowired
	private Cxtj_FhmxzService cxtj_FhmxzService;

	// @Login
	@GetMapping("queryCxtjGrjcqkPage")
	@ApiOperation(value = "个人缴存情况", notes = "个人缴存情况", response = Cxtj_GrjcqkEntity.class)
	public R queryGrjcqkPage(Integer pageNum, Integer pageSize, Cxtj_GrjcqkEntity cxtj_GrjcqkEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryGrjcqkPage(pageNum, pageSize, cxtj_GrjcqkEntity));
	}

	// @Login
	@GetMapping("queryCxtjGrjcHstjPage")
	@ApiOperation(value = "个人缴存户数统计", notes = "个人缴存户数统计", response = Cxtj_GrjcHstjEntity.class)
	public R queryGrjcHstjPage(Integer pageNum, Integer pageSize, Cxtj_GrjcHstjEntity cxtj_GrjcHstjEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryGrjcHstjPage(pageNum, pageSize, cxtj_GrjcHstjEntity));
	}

	// @Login
	@GetMapping("queryCxtjJcybPage")
	@ApiOperation(value = "缴存月报", notes = "缴存月报", response = Cxtj_GrjcJcybEntity.class)
	public R queryGrjcJcybPage(Integer pageNum, Integer pageSize, Cxtj_GrjcJcybEntity cxtj_GrjcJcybEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryGrjcJcybPage(pageNum, pageSize, cxtj_GrjcJcybEntity));
	}

	// @Login
	@GetMapping("queryCxtjZzcxPage")
	@ApiOperation(value = "总账查询", notes = "总账查询", response = Cxtj_CxtjZzcxEntity.class)
	public R queryCxtjZzcxPage(Integer pageNum, Integer pageSize, Cxtj_CxtjZzcxEntity cxtj_CxtjZzcxEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryCxtjZzcxPage(pageNum, pageSize, cxtj_CxtjZzcxEntity));
	}

	// @Login
	@GetMapping("queryCxtjZqcxPage")
	@ApiOperation(value = "支取查询", notes = "支取查询", response = Cxtj_CxtjZqcxEntity.class)
	public R queryCxtjZqcxPage(Integer pageNum, Integer pageSize, Cxtj_CxtjZqcxEntity cxtj_CxtjZqcxEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryCxtjZqcxPage(pageNum, pageSize, cxtj_CxtjZqcxEntity));
	}

	// @Login
	@GetMapping("queryCxtjJkcxPage")
	@ApiOperation(value = "缴款查询", notes = "缴款查询", response = Cxtj_CxtjJkcxEntity.class)
	public R queryCxtjJkcxPage(Integer pageNum, Integer pageSize, Cxtj_CxtjJkcxEntity cxtj_CxtjJkcxEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryCxtjJkcxPage(pageNum, pageSize, cxtj_CxtjJkcxEntity));
	}

	// @Login
	@GetMapping("queryTyXqPage")
	@ApiOperation(value = "小区", notes = "小区", response = Cxtj_CxtjTyEntity.class)
	public R queryTyXqPage(Integer pageNum, Integer pageSize, Cxtj_CxtjTyEntity cxtj_CxtjTyEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryTyXqPage(pageNum, pageSize, cxtj_CxtjTyEntity));
	}

	// @Login
	@GetMapping("queryTyXmPage")
	@ApiOperation(value = "项目", notes = "项目", response = Cxtj_CxtjTyEntity.class)
	public R queryTyXmPage(Integer pageNum, Integer pageSize, Cxtj_CxtjTyEntity cxtj_CxtjTyEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryTyXmPage(pageNum, pageSize, cxtj_CxtjTyEntity));
	}

	// @Login
	@GetMapping("queryTyLyPage")
	@ApiOperation(value = "楼宇", notes = "楼宇", response = Cxtj_CxtjTyEntity.class)
	public R queryTyLyPage(Integer pageNum, Integer pageSize, Cxtj_CxtjTyEntity cxtj_CxtjTyEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryTyLyPage(pageNum, pageSize, cxtj_CxtjTyEntity));
	}

	// @Login
	@GetMapping("queryTySyxmPage")
	@ApiOperation(value = "收益项目", notes = "收益项目", response = Cxtj_CxtjTyEntity.class)
	public R queryTySyxmPage(Integer pageNum, Integer pageSize, Cxtj_CxtjTyEntity cxtj_CxtjTyEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryTySyxmPage(pageNum, pageSize, cxtj_CxtjTyEntity));
	}
	
	// @Login
	@GetMapping("queryTyHyxxPage")
	@ApiOperation(value = "银行信息", notes = "银行信息", response = Cxtj_CxtjTyEntity.class)
	public R queryTyHyxxPage(Integer pageNum, Integer pageSize, Cxtj_CxtjTyEntity cxtj_CxtjTyEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryTyHyxxPage(pageNum, pageSize, cxtj_CxtjTyEntity));
	}

	// @Login
	@GetMapping("queryCxtjFwwxqkPage")
	@ApiOperation(value = "房屋维修情况", notes = "房屋维修情况", response = Cxtj_CxtjFwwxqkEntity.class)
	public R queryCxtjFwwxqkPage(Integer pageNum, Integer pageSize, Cxtj_CxtjFwwxqkEntity cxtj_CxtjFwwxqkEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryCxtjFwwxqkPage(pageNum, pageSize, cxtj_CxtjFwwxqkEntity));
	}

	// @Login
	@GetMapping("queryCxtjGgsyfpPage")
	@ApiOperation(value = "公共收益分配", notes = "公共收益分配", response = Cxtj_CxtjGgsyfpEntity.class)
	public R queryCxtjGgsyfpPage(Integer pageNum, Integer pageSize, Cxtj_CxtjGgsyfpEntity cxtj_CxtjGgsyfpEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryCxtjGgsyfpPage(pageNum, pageSize, cxtj_CxtjGgsyfpEntity));
	}

	// @Login
	@GetMapping("queryCxtjCqrbgPage")
	@ApiOperation(value = "产权人表更", notes = "产权人表更", response = Cxtj_CxtjCqrbgEntity.class)
	public R queryCxtjCqrbgPage(Integer pageNum, Integer pageSize, Cxtj_CxtjCqrbgEntity cxtj_CxtjCqrbgEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryCxtjCqrbgPage(pageNum, pageSize, cxtj_CxtjCqrbgEntity));
	}

	// @Login
	@GetMapping("queryCxtjCsbPage")
	@ApiOperation(value = "催收表", notes = "催收表", response = Cxtj_CxtjCsbEntity.class)
	public R queryCxtjCsbPage(Integer pageNum, Integer pageSize, Cxtj_CxtjCsbEntity cxtj_CxtjCsbEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryCxtjCsbPage(pageNum, pageSize, cxtj_CxtjCsbEntity));
	}

	// @Login
	@GetMapping("queryCxtjCfzhPage")
	@ApiOperation(value = "重复幢号", notes = "重复幢号", response = Cxtj_CxtjCfzhEntity.class)
	public R queryCxtjCfzhPage(Integer pageNum, Integer pageSize, Cxtj_CxtjCfzhEntity cxtj_CxtjCfzhEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryCxtjCfzhPage(pageNum, pageSize, cxtj_CxtjCfzhEntity));
	}

	// @Login
	@GetMapping("queryCxtjFwbgPage")
	@ApiOperation(value = "房屋变更查询", notes = "房屋变更查询", response = Cxtj_CxtjFwbgEntity.class)
	public R queryCxtjFwbgPage(Integer pageNum, Integer pageSize, Cxtj_CxtjFwbgEntity cxtj_CxtjFwbgEntity) {
		return R.ok().put("data", cxtj_FhmxzService.queryCxtjFwbgPage(pageNum, pageSize, cxtj_CxtjFwbgEntity));
	}

}
