package io.renren.modules.app.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.FhmxzEntity;
import io.renren.modules.app.service.DwmxzService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 开发建设单位明细账查询
 * @author Administrator
 *
 */
@RestController
@RequestMapping("app/dwmxz")
@Api(tags = "开发建设单位明细账查询")
public class DwmxzController {
	@Autowired
	private DwmxzService dwmxzService;
	
	@Login
	@GetMapping("selectDWMXZByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = FhmxzEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize,FhmxzEntity fhmxzEntity) {
		return R.ok().put("data", dwmxzService.selectDWMXZByPage(pageNum, pageSize, fhmxzEntity));
	}
}
