package io.renren.modules.app.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.FhxxSelectEntity;
import io.renren.modules.app.service.FhxxSelectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 分户信息查询
 * @author Administrator
 *
 */
@RestController
@RequestMapping("app/fhxx")
@Api(tags = "分户信息查询")
public class FhxxSelectController {
	@Autowired
	private FhxxSelectService fhxxSelectService;
	
	@Login
	@GetMapping("selectFHMXZByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = FhxxSelectEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize,FhxxSelectEntity fhxxSelectEntity) {
		return R.ok().put("data", fhxxSelectService.selectFhxxByPage(pageNum, pageSize, fhxxSelectEntity));
	}
	
	
}
