package io.renren.modules.app.controller;


import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.GoodsEntity;
import io.renren.modules.app.service.GoodsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 商品管理
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-21 13:29:12
 */
@RestController
@RequestMapping("app/goods")
@Api(tags = "商品管理模块")
public class GoodsController {

    @Autowired
    private GoodsService goodsService;


    @Login
    @GetMapping("queryByPage")
    @ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = GoodsEntity.class)
    public R queryByPage(Integer pageNum, Integer pageSize, GoodsEntity goodsEntity) {

        return R.ok().put("data", goodsService.queryByPage(pageNum, pageSize, goodsEntity));
    }


    @Login
    @PostMapping("/insert")
    @ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = GoodsEntity.class)
    public R insert(@RequestBody GoodsEntity goodsEntity) {
            goodsService.insert(goodsEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/update")
    @ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = GoodsEntity.class)
    public R update(@RequestBody GoodsEntity goodsEntity) {
            goodsService.updateById(goodsEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/delete")
    @ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = GoodsEntity.class)
    public R delete(@RequestBody String[] ids) {
            goodsService.deleteBatch(ids);
        return R.ok();
    }

}
