package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.GrbgEntity;
import io.renren.modules.app.service.GrbgService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 产权人更名
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-04-11 15:25:21
 */
@RestController
@RequestMapping("app/grbg")
@Api(tags = "产权人信息修改模块")
public class GrbgController {

	@Autowired
	private GrbgService grbgService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = GrbgEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, GrbgEntity grbgEntity) {

		return R.ok().put("data", grbgService.queryByPage(pageNum, pageSize, grbgEntity));
	}

	//@Login
	@PostMapping("/insert")
	@ApiOperation(value = "保存", notes = "在此补充接口详细注释...", response = GrbgEntity.class)
	public R insert(@RequestBody GrbgEntity grbgEntity) {
		grbgService.insertcqbg(grbgEntity);
		return R.ok();
	}

}
