package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzDyEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.service.GrjktzsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 个人缴款通知书
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 09:53:01
 */
@RestController
@RequestMapping("app/grjktzs")
@Api(tags = "个人缴款通知书模块(个人缴款通知书)")
public class GrjktzsController {

	@Autowired
	private GrjktzsService grjktzsService;

	@Login
	@PostMapping("/selectxlk")
	@ApiOperation(value = "下拉框查询", notes = "", response = XlkEntity.class)
	public R selectxlk(@RequestBody Map<String, String> map) {

		return R.ok().put("list", grjktzsService.selectxlk(map));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "保存", notes = "", response = YwpzEntity.class)
	public R insert(@RequestBody YwpzDyEntity ywpzdyEntity) {
		grjktzsService.insertBc(ywpzdyEntity);
		return R.ok();
	}

	@Login
	@GetMapping("/queryByPage")
	@ApiOperation(value = "分页查询列表页面", notes = "", response = YwpzDyEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", grjktzsService.queryByPage(pageNum, pageSize,ywpzEntity));
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "刪除按钮", notes = "")
	public R delete(@RequestBody YwpzDyEntity ywpzDyEntity) {
		grjktzsService.delete(ywpzDyEntity);
		return R.ok();
	}

}
