package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.entity.HKmyeEntity;
import io.renren.modules.app.entity.HPzEntity;
import io.renren.modules.app.entity.HYtlxbEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.service.HPzService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.sun.javafx.collections.MappingChange.Map;

/**
 * 凭证
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-06-13 09:49:49
 */
@RestController
@RequestMapping("app/hpz")
@Api(tags = "凭证模块")
public class HPzController {

	@Autowired
	private HPzService hPzService;

	// @Login
	@GetMapping("queryByPageDWPZ")
	@ApiOperation(value = "单位缴款凭证", notes = "带分页、模糊查询，查询关键字：(单位缴款凭证业务数据分页查询页面，只有复核了这里才有业务记录)", response = YwpzEntity.class)
	public R queryByPageDWPZ(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", hPzService.queryByPageDWPZ(pageNum, pageSize, ywpzEntity));
	}

	// @Login
	@PostMapping("/insertDWPZSC")
	@ApiOperation(value = "生成按钮(可勾选多个业务单据)", notes = "单位缴交凭证点击生成按钮调的接口", response = R.class)
	public R insertDWPZSC(@RequestBody YwpzEntity ywpzEntity) {
		hPzService.insertDWPZSC(ywpzEntity);
		return R.ok();
	}

	// @Login
	@GetMapping("queryByPageGRPZ")
	@ApiOperation(value = "个人缴款凭证", notes = "带分页、模糊查询，查询关键字：(个人缴款凭证业务数据分页查询页面，只有复核了这里才有业务记录)", response = YwpzEntity.class)
	public R queryByPageGRPZ(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", hPzService.queryByPageGRPZ(pageNum, pageSize, ywpzEntity));
	}

	// @Login
	@PostMapping("/insertGRPZSC")
	@ApiOperation(value = "生成按钮(可勾选多个业务单据)", notes = "个人缴交凭证点击生成按钮调的接口", response = R.class)
	public R insertGRPZSC(@RequestBody YwpzEntity ywpzEntity) {
		hPzService.insertGRPZSC(ywpzEntity);
		return R.ok();
	}

	// @Login
	@GetMapping("queryByPageTKPZ")
	@ApiOperation(value = "退款凭证", notes = "带分页、模糊查询，查询关键字：(退款凭证业务数据分页查询页面，只有复核了这里才有业务记录)", response = YwpzEntity.class)
	public R queryByPageTKPZ(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", hPzService.queryByPageTKPZ(pageNum, pageSize, ywpzEntity));
	}

	// @Login
	@PostMapping("/insertTKPZSC")
	@ApiOperation(value = "退款生成按钮(可勾选多个业务单据)", notes = "退款凭证点击生成按钮调的接口", response = R.class)
	public R insertTKPZSC(@RequestBody YwpzEntity ywpzEntity) {
		hPzService.insertTKPZSC(ywpzEntity);
		return R.ok();
	}

	// @Login
	@GetMapping("queryByPageGGSYFTPZ")
	@ApiOperation(value = "公共收益分摊缴款凭证", notes = "带分页、模糊查询，查询关键字：(公共收益分摊缴款凭证业务数据分页查询页面，只有复核了这里才有业务记录)", response = YwpzEntity.class)
	public R queryByPageGGSYFTPZ(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", hPzService.queryByPageGGSYFTPZ(pageNum, pageSize, ywpzEntity));
	}

	// @Login
	@PostMapping("/insertGGSYFTPZSC")
	@ApiOperation(value = "生成按钮(可勾选多个业务单据)", notes = "公共收益分摊缴交凭证点击生成按钮调的接口", response = R.class)
	public R insertGGSYFTPZSC(@RequestBody YwpzEntity ywpzEntity) {
		hPzService.insertGGSYFTPZSC(ywpzEntity);
		return R.ok();
	}

	// @Login
	@GetMapping("queryByPageZQPZSC")
	@ApiOperation(value = "支取凭证", notes = "带分页、模糊查询，查询关键字：()", response = YwpzEntity.class)
	public R queryByPageZQPZSC(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", hPzService.queryByPageZQPZSC(pageNum, pageSize, ywpzEntity));
	}

	// @Login
	@PostMapping("/insertZQPZSC")
	@ApiOperation(value = "生成按钮(可勾选多个业务单据)", notes = "支取决算凭证点击生成按钮调的接口", response = R.class)
	public R insertZQPZSC(@RequestBody YwpzEntity ywpzEntity) {
		hPzService.insertZQPZSC(ywpzEntity);
		return R.ok();
	}

	// @Login
	@PostMapping("/insertPZLR")
	@ApiOperation(value = "凭证录入", notes = "凭证录入保存按钮", response = HPzEntity.class)
	public R insertPZLR(@RequestBody YwpzEntity ywpzEntity) {

		return R.ok().put("data", hPzService.insertPZLR(ywpzEntity));
	}

	// @Login
	@PostMapping("/PZXGBC")
	@ApiOperation(value = "凭证修改保存", notes = "凭证修改保存按钮", response = R.class)
	public R PZXGBC(@RequestBody List<HPzEntity> list) {
		hPzService.PZXGBC(list);
		return R.ok();
	}

	// @Login
	@GetMapping("queryByPagePZCX")
	@ApiOperation(value = "凭证查询", notes = "带分页、模糊查询，查询关键字：()", response = HPzEntity.class)
	public R queryByPagePZCX(Integer pageNum, Integer pageSize, HPzEntity hPzEntity) {

		return R.ok().put("data", hPzService.queryByPagePZCX(pageNum, pageSize, hPzEntity));
	}

	// @Login
	@PostMapping("/deletePZ")
	@ApiOperation(value = "批量删除凭证", notes = "只能删除未审核的凭证", response = R.class)
	public R deletePZ(@RequestBody List<HPzEntity> hPzEntities) {
		hPzService.deletePZ(hPzEntities);
		return R.ok();
	}

	// @Login
	@PostMapping("/PZHZCX")
	@ApiOperation(value = "凭证汇总查询", notes = "", response = HPzEntity.class)
	public R PZHZCX(@RequestBody HPzEntity hPzEntity) {

		return R.ok().put("data", hPzService.PZHZCX(hPzEntity));
	}

	// @Login
	@GetMapping("queryByPagePZSH")
	@ApiOperation(value = "凭证审核查询列表", notes = "带分页、模糊查询，查询关键字：()", response = HPzEntity.class)
	public R queryByPagePZSH(Integer pageNum, Integer pageSize, HPzEntity hPzEntity) {

		return R.ok().put("data", hPzService.queryByPagePZSH(pageNum, pageSize, hPzEntity));
	}

	// @Login
	@PostMapping("/PZSHXQ")
	@ApiOperation(value = "凭证审核详情按钮", notes = "", response = HPzEntity.class)
	public R PZSHXQ(@RequestBody HPzEntity hPzEntity) {

		return R.ok().put("data", hPzService.PZSHXQ(hPzEntity));
	}

	// @Login
	@PostMapping("/PZSHXQPLDY")
	@ApiOperation(value = "凭证审核详情按钮批量打印", notes = "", response = HPzEntity.class)
	public R PZSHXQPLDY(@RequestBody List<HPzEntity> list) {
		List<List<HPzEntity>> l = new ArrayList<List<HPzEntity>>();
		for (HPzEntity p : list) {
			List<HPzEntity> H = hPzService.PZSHXQPL2(p);
			l.add(H);
		}
		return R.ok().put("data", l);
	}

	// @Login
	@PostMapping("/PZSH")
	@ApiOperation(value = "批量审核凭证", notes = "", response = R.class)
	public R PZSH(@RequestBody YwpzEntity ywpzEntity) {
		hPzService.PZSH(ywpzEntity);
		return R.ok();
	}

	// @Login
	@GetMapping("queryByPagePZJZ")
	@ApiOperation(value = "凭证记账查询列表", notes = "带分页、模糊查询，查询关键字：()", response = HPzEntity.class)
	public R queryByPagePZJZ(Integer pageNum, Integer pageSize, HPzEntity hPzEntity) {

		return R.ok().put("data", hPzService.queryByPagePZJZ(pageNum, pageSize, hPzEntity));
	}

	// @Login
	@PostMapping("/PZQXSH")
	@ApiOperation(value = "批量取消已审核的凭证", notes = "", response = R.class)
	public R PZQXSH(@RequestBody YwpzEntity ywpzEntity) {
		hPzService.PZQXSH(ywpzEntity);
		return R.ok();
	}

	// @Login
	@PostMapping("/PZJZ")
	@ApiOperation(value = "批量记账凭证", notes = "", response = R.class)
	public R PZJZ(@RequestBody YwpzEntity ywpzEntity) {
		hPzService.PZJZ(ywpzEntity);
		return R.ok();
	}

	// @Login
	@PostMapping("/PZQXJZ")
	@ApiOperation(value = "批量取消已记账的凭证", notes = "", response = R.class)
	public R PZQXJZ(@RequestBody YwpzEntity ywpzEntity) {
		System.out.println("222222222");
		hPzService.PZQXJZ(ywpzEntity);
		System.out.println("333333333");
		return R.ok();
	}

	// @Login
	@PostMapping("/PZCXMSD")
	@ApiOperation(value = "凭证录入页面查询", notes = "带分页、模糊查询，查询关键字：()", response = HPzEntity.class)
	public R PZCXMSD(@RequestBody HPzEntity hPzEntity) {

		return R.ok().put("data", hPzService.PZCXMSD(hPzEntity));
	}

	// @Login
	@GetMapping("queryByPagePZCZ")
	@ApiOperation(value = "凭证冲账查询列表", notes = "带分页、模糊查询，查询关键字：()", response = YwpzEntity.class)
	public R queryByPagePZCZ(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", hPzService.queryByPagePZCZ(pageNum, pageSize, ywpzEntity));
	}

	// @Login
	@PostMapping("/PZYWCZ")
	@ApiOperation(value = "冲账按钮", notes = "", response = R.class)
	public R PZYWCZ(@RequestBody YwpzEntity ywpzEntity) {

		if ("01".equals(ywpzEntity.getDjlx())) {
			String pzzt = ywpzEntity.getPzzt();
			YwpzEntity y = hPzService.selectdw(ywpzEntity.getDwbm());
			YwpzEntity y2 = hPzService.selectdwzck(ywpzEntity.getDwbm());
			BigDecimal a = new BigDecimal(ywpzEntity.getJe());
			BigDecimal b = new BigDecimal(y2.getZckje());
			if ("3" == pzzt) {
				return R.error("已冲账，不能再次冲账");
			} else if (isObjectNotEmpty(y) == false) {
				return R.error("单位不存在，操作失败");
			} else if (a.compareTo(b) > 0) {
				return R.error("单位暂存款不够,不能冲帐");
			} else {
				// 单位交款冲账

			}
			return R.ok("单位交款冲账成功");
		} else if ("02".equals(ywpzEntity.getDjlx())) {

			return R.ok("单位分配冲账成功");
		} else if ("03".equals(ywpzEntity.getDjlx())) {

			return R.ok("个人维修资金冲账成功");
		} else if ("04".equals(ywpzEntity.getDjlx())) {

			return R.ok("公共收益分摊冲账成功");
		} else {

			return R.ok("个人续补交冲账成功");
		}

	}

	public static Boolean isObjectNotEmpty(Object obj) {
		String str = ObjectUtils.toString(obj, "");
		return StringUtils.isNotBlank(str);
	}

	// @Login
	@PostMapping("/PZHCZ")
	@ApiOperation(value = "凭证号重整", notes = "", response = R.class)
	public R PZHCZ(@RequestBody HPzEntity hPzEntity) {
		hPzService.PZHCZ(hPzEntity);
		return R.ok();
	}

	// @Login
	@PostMapping("/pzrq格式改变脚本方法")
	@ApiOperation(value = "将原始数据凭证表里的日期格式转换为新系统的日期格式", notes = "", response = R.class)
	public R PZRQGSGB() {
		hPzService.PZRQGSGB();
		return R.ok();
	}

	// @Login
	@PostMapping("/insertCWJZSZPZ")
	@ApiOperation(value = "财务结转收支凭证", notes = "确认按钮", response = R.class)
	public R insertCWJZSZPZ(@RequestBody YwpzEntity ywpzEntity) {
		// 1.结转收入查询
		List<HPzEntity> listsr = hPzService.selectjzsr(ywpzEntity);
		if (!listsr.isEmpty()) {
			Iterator<HPzEntity> it = listsr.iterator();
			while (it.hasNext()) {
				HPzEntity x = it.next();
				if (x.getJfje().compareTo(x.getDfje()) == 0) {
					it.remove();
				}
			}

		}
		// 1.结转支出查询
		List<HPzEntity> listzc = hPzService.selectjzzc(ywpzEntity);
		if (!listzc.isEmpty()) {
			Iterator<HPzEntity> it = listzc.iterator();
			while (it.hasNext()) {
				HPzEntity x = it.next();
				if (x.getJfje().compareTo(x.getDfje()) == 0) {
					it.remove();
				}
			}

		}
		if (listsr.isEmpty() && listzc.isEmpty()) {
			return R.error("没有未结转的收支凭证");
		} else {
			hPzService.insertCWJZSZPZ(ywpzEntity);
		}
		return R.ok();
	}

	// @Login
	@PostMapping("/CWYTLXPZ")
	@ApiOperation(value = "财务预提利息凭证", notes = "", response = R.class)
	public R CWYTLXPZ(@RequestBody YwpzEntity ywpzEntity) {
		// 1.判断当前会计期间是否已经预提利息
		int count1 = hPzService.selectytlx(ywpzEntity);
		// 2.页面输入的预提凭证日期必须大于上次预提利息
		HYtlxbEntity ytlx = hPzService.selectjxrq(ywpzEntity);
		DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		if (count1 > 0) {
			return R.error("当前财务会计期间已预提利息，不能操作！");
		} else if (isObjectNotEmpty(ytlx) == false) {

		}
		try {
			if (isObjectNotEmpty(ytlx) == true
					&& sdf.parse(ywpzEntity.getPzrq()).getTime() <= sdf.parse(ytlx.getJxrq()).getTime()) {
				return R.error("预提利息凭证日期不能小于上次预提利息日期，不能操作！");
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}
		// 默认按xtcs表中lxlx值为1来处理（1则按每年7月01号到次年6月30号；不为1时则按每年01-01到当年12月31号）
		// 3.获取年度日期
		String dqrq = ywpzEntity.getPzrq();
		String begtime = null;
		String endtime = null;
		String nd = null;
		try {
			SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
			if (sdf.parse(dqrq).getTime() >= sdf.parse(dqrq.substring(0, 4) + "-07-01").getTime()) {
				begtime = dqrq.substring(0, 4) + "-07-01";// 年度开始日期
				java.util.Date date = null;
				try {
					date = formatter.parse(begtime);
				} catch (ParseException e) {
					e.printStackTrace();
				} // Date格式
				Calendar calBegin = Calendar.getInstance();
				// 使用给定的 Date 设置此 Calendar 的时间
				calBegin.setTime(date);
				calBegin.add(Calendar.YEAR, 1);
				String datestr = formatter.format(calBegin.getTime());// String格式
				endtime = datestr.substring(0, 4) + "-06-30";// 年底终止日期
				nd = datestr.substring(0, 4);// 所在年度
			} else {
				endtime = dqrq.substring(0, 4) + "-06-30";// 年底终止日期
				nd = dqrq.substring(0, 4);// 所在年度
				java.util.Date date = null;
				try {
					date = formatter.parse(endtime);
				} catch (ParseException e) {
					e.printStackTrace();
				} // Date格式
				Calendar calBegin = Calendar.getInstance();
				// 使用给定的 Date 设置此 Calendar 的时间
				calBegin.setTime(date);
				calBegin.add(Calendar.YEAR, -1);
				String datestr = formatter.format(calBegin.getTime());// String格式
				begtime = datestr.substring(0, 4) + "-07-01";// 年度开始日期
			}
			if (formatter.parse(ywpzEntity.getKjqj()).getTime() == formatter.parse(endtime.substring(0, 7)).getTime()) {
				return R.error("当前会计期间为年底结息期间，不能预提利息！");
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}
		// 4.查询h_ytlxb中指定结息年度的利息，定期利息，活期利息，定期积数，活期积数的各项和。
		HYtlxbEntity hYtlxbEntity = hPzService.selectytxx(nd);
		// if(hYtlxbEntity.getLx()==0){
		// //若预提利息表为空，这里设置初始化的值
		// hYtlxbEntity.setLx(1.0);
		// hYtlxbEntity.setDqlx(1.0);
		// hYtlxbEntity.setHqlx(1.0);
		// hYtlxbEntity.setDqjs(1.0);
		// hYtlxbEntity.setHqjs(1.0);
		// }
		if (hYtlxbEntity.getLx() >= 0.01) {
			// 此处开始进行预提利息凭证生成,并在预提利息表中记录此次预提利息操作
			ywpzEntity.setJxnd(nd);
			ywpzEntity.setHYtlxbEntity(hYtlxbEntity);
			hPzService.insertCWYTLXPZSC(ywpzEntity);
		} else {
			return R.error("没有预提利息！");
		}
		return R.ok();
	}

	// @Login
	@GetMapping("queryByPageYTLX")
	@ApiOperation(value = "预提利息分页查询", notes = "带分页、模糊查询，查询关键字", response = HYtlxbEntity.class)
	public R queryByPageYTLX(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", hPzService.queryByPageYTLX(pageNum, pageSize, ywpzEntity));
	}

	// @Login
	@PostMapping("/DWPLDRZDSCPZ")
	@ApiOperation(value = "", notes = "单位预交批量导入自动生成凭证脚本", response = R.class)
	public R DWPLDRZDSCPZ() {
		// 1.查询单位预交批量导入生成的所有的单据信息。
		return R.ok();
	}

	// @Login
	@PostMapping("/PX")
	@ApiOperation(value = "排序", notes = "PX", response = R.class)
	public R PX() {
		YwpzEntity y1 = new YwpzEntity();
		y1.setDjrq("2019-01-02");
		y1.setKfskmdm("211011001");
		YwpzEntity y2 = new YwpzEntity();
		y2.setDjrq("2019-01-01");
		y2.setKfskmdm("211002001");
		YwpzEntity y3 = new YwpzEntity();
		y3.setDjrq("2019-01-03");
		y3.setKfskmdm("211010001");
		List<YwpzEntity> list = new ArrayList<YwpzEntity>();
		list.add(y1);
		list.add(y2);
		list.add(y3);
		System.out.print("排序前" + list);
		Collections.sort(list, new Comparator<YwpzEntity>() {
			// 这里可以再Person中实现 Comparator<T>接口，重写compare方法
			@Override
			public int compare(YwpzEntity o1, YwpzEntity o2) {
				// 这里按照名字排序
				return o1.getKfskmdm().compareTo(o2.getKfskmdm());
				// 这里按照age排序
				// return (o1.getAge()+"").compareTo(o2.getAge()+"");
				// 。。。根据不同属性值排序
			}
		});
		System.out.print("排序后" + list);
		return R.ok();
	}

	// @Login
	@PostMapping("/SELECTZTBYKJQJ")
	@ApiOperation(value = "通过会计期间起始和结束段返回对应的ztbm", notes = "", response = R.class)
	public R SELECTZTBYKJQJ(@RequestBody HPzEntity hPzEntity) {
		String ztbm = hPzService.selectztbmbykjqj(hPzEntity);
		if ("false".equals(ztbm)) {
			return R.error("只允许查询同一账套编码的会计期间时间段");
		}
		return R.ok().put("data", ztbm);
	}

	// @Login
	@PostMapping("/BBTJSZB")
	@ApiOperation(value = "报表统计收支表", notes = "", response = R.class)
	public R BBTJSZB(@RequestBody YwpzEntity ywpzEntity) {
		List<YwpzEntity> list = new ArrayList<YwpzEntity>();
		list = hPzService.selectbbtjszb(ywpzEntity.getKjqj());
		return R.ok().put("data", list);
	}

	// @Login
	@PostMapping("/JZCBDB")
	@ApiOperation(value = "报表统计净资产变动表", notes = "", response = R.class)
	public R JZCBDB(@RequestBody YwpzEntity ywpzEntity) {
		List<YwpzEntity> list = new ArrayList<YwpzEntity>();
		list = hPzService.selectbbtjjzcbdb(ywpzEntity.getKjqj());
		return R.ok().put("data", list);
	}

	// @Login
	@PostMapping("/QMJZ")
	@ApiOperation(value = "期末结转", notes = "", response = R.class)
	public R QMJZ(@RequestBody HPzEntity hPzEntity) {
		String message = "";
		//-------------------------------
		HKmyeEntity hKmyeEntity=new HKmyeEntity();
		hKmyeEntity.setKjqj(hPzEntity.getPzrq().substring(0, 7));
		List<HKmyeEntity> list = hPzService.YJQQMJZ(hKmyeEntity);
		for(HKmyeEntity k : list){
			if(hPzEntity.getKm().equals(k.getHskmdm())&&"0".equals(k.getQmjz())){
				int a = hPzService.QMJZ(hPzEntity);
				if (a == 0) {
					message = "1";//结转成功
				} else {
					message = "2";//结转失败
				}
			}else if(hPzEntity.getKm().equals(k.getHskmdm())&&"1".equals(k.getQmjz())){
				message="2";//该科目已期末结转过,不允许再次结转!
				
			}
		}
		//-------------------------------
		return R.ok().put("data", message);
	}

	// @Login
	@PostMapping("/YJQQMJZ")
	@ApiOperation(value = "财务月结时调该接口判断期末是否结转", notes = "", response = R.class)
	public R YJQQMJZ(@RequestBody HKmyeEntity hKmyeEntity) {
		List<HKmyeEntity> list = hPzService.YJQQMJZ(hKmyeEntity);
//		HashMap<String, String> map=new HashMap<String, String>();
//		HKmyeEntity hK=new HKmyeEntity();
		String lx="";
		String message="";
		int a = 0;
		if (!list.isEmpty()) {
			for (HKmyeEntity k : list) {
				if ("400101".equals(k.getHskmdm()) && "0".equals(k.getQmjz())) {
					message = "交存收入还未期末结转,无法月结";
					a=1;
					lx=""+a;
				}else if ("400102".equals(k.getHskmdm()) && "0".equals(k.getQmjz())) {
					message = "交存收入还未期末结转,无法月结";
					a=1;
					lx=""+a;
				} else if ("5001".equals(k.getHskmdm()) && "0".equals(k.getQmjz())) {
					message = message+";"+"维修支出还未期末结转,无法月结";
					a=1;
					lx=""+a;
				} else if ("5101".equals(k.getHskmdm()) && "0".equals(k.getQmjz())) {
					message = message+";"+"返还支出还未期末结转,无法月结";
					a=1;
					lx=""+a;
				}
			}
			if (a == 0) {
				message = "已期末结转，可月结";
				lx=""+a;
			}
		}
		return R.ok().put("data",lx);
	}

}
