package io.renren.modules.app.controller;


import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.HZcfzEntity;
import io.renren.modules.app.service.HZcfzService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 资产负债表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-06-11 08:51:47
 */
@RestController
@RequestMapping("app/hzcfz")
@Api(tags = "资产负债表模块")
public class HZcfzController {

    @Autowired
    private HZcfzService hZcfzService;


    @GetMapping("queryByPage")
    @ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = HZcfzEntity.class)
    public R queryByPage(Integer pageNum, Integer pageSize, HZcfzEntity hZcfzEntity) {

        return R.ok().put("data", hZcfzService.queryByPage(pageNum, pageSize, hZcfzEntity));
    }


    @Login
    @PostMapping("/insert")
    @ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = HZcfzEntity.class)
    public R insert(@RequestBody HZcfzEntity hZcfzEntity) {
        hZcfzService.insert(hZcfzEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/update")
    @ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = HZcfzEntity.class)
    public R update(@RequestBody HZcfzEntity hZcfzEntity) {
        hZcfzService.updateById(hZcfzEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/delete")
    @ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = HZcfzEntity.class)
    public R delete(@RequestBody String[] ids) {
        hZcfzService.deleteBatch(ids);
        return R.ok();
    }

    @Login
    @PostMapping("/deleteinfo")
    @ApiOperation(value = "资产负债表公式删除", notes = "根据bm删除", response = HZcfzEntity.class)
    public R deleteinfo(@RequestBody HZcfzEntity hZcfzEntity) {
        hZcfzService.deleteinfo(hZcfzEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/updateZCFZ")
    @ApiOperation(value = "修改", notes = "修改资产负债表计算公式", response = HZcfzEntity.class)
    public R updateZCFZ(@RequestBody HZcfzEntity hZcfzEntity) {
        hZcfzService.updateZCFZ(hZcfzEntity);
        return R.ok();
    }

}
