package io.renren.modules.app.controller;


import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.HZyEntity;
import io.renren.modules.app.service.HZyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 摘要表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-06-11 08:56:58
 */
@RestController
@RequestMapping("app/hzy")
@Api(tags = "摘要表模块")
public class HZyController {

    @Autowired
    private HZyService hZyService;


    @Login
    @GetMapping("queryByPage")
    @ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = HZyEntity.class)
    public R queryByPage(Integer pageNum, Integer pageSize, HZyEntity hZyEntity) {

        return R.ok().put("data", hZyService.queryByPage(pageNum, pageSize, hZyEntity));
    }


    @Login
    @PostMapping("/insert")
    @ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = HZyEntity.class)
    public R insert(@RequestBody HZyEntity hZyEntity) {
    	    hZyEntity.setZtbm("0001");
            hZyService.insert(hZyEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/update")
    @ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = HZyEntity.class)
    public R update(@RequestBody HZyEntity hZyEntity) {
            hZyService.updateById(hZyEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/delete")
    @ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = HZyEntity.class)
    public R delete(@RequestBody String[] ids) {
            hZyService.deleteBatch(ids);
        return R.ok();
    }
    
    @Login
    @PostMapping("/selectzy")
    @ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = HZyEntity.class)
    public R selectzy(@RequestBody HZyEntity hZyEntity) {
            
        return R.ok().put("select", hZyService.selectzy(hZyEntity));
    }

}
