package io.renren.modules.app.controller;


import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.HZzsyybbEntity;
import io.renren.modules.app.service.HZzsyybbService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 增值收益表（月报）
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-06-14 14:23:28
 */
@RestController
@RequestMapping("app/hzzsyybb")
@Api(tags = "增值收益表（月报）模块")
public class HZzsyybbController {

    @Autowired
    private HZzsyybbService hZzsyybbService;


    
    @GetMapping("queryByPage")
    @ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = HZzsyybbEntity.class)
    public R queryByPage(Integer pageNum, Integer pageSize, HZzsyybbEntity hZzsyybbEntity) {

        return R.ok().put("data", hZzsyybbService.queryByPage(pageNum, pageSize, hZzsyybbEntity));
    }


    @Login
    @PostMapping("/insert")
    @ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = HZzsyybbEntity.class)
    public R insert(@RequestBody HZzsyybbEntity hZzsyybbEntity) {
            hZzsyybbService.insert(hZzsyybbEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/update")
    @ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = HZzsyybbEntity.class)
    public R update(@RequestBody HZzsyybbEntity hZzsyybbEntity) {
            hZzsyybbService.updateById(hZzsyybbEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/delete")
    @ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = HZzsyybbEntity.class)
    public R delete(@RequestBody String[] ids) {
            hZzsyybbService.deleteBatch(ids);
        return R.ok();
    }
    
    
    @Login
    @PostMapping("/updateZZSYYBB")
    @ApiOperation(value = "修改", notes = "增值收益表公式修改", response = HZzsyybbEntity.class)
    public R updateZZSYYBB(@RequestBody HZzsyybbEntity hZzsyybbEntity) {
            hZzsyybbService.updateZZSYYBB(hZzsyybbEntity);
        return R.ok();
    }
}
