package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.JcbzEntity;
import io.renren.modules.app.service.JcbzService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 缴存标准表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-04-16 11:20:08
 */
@RestController
@RequestMapping("app/jcbz")
@Api(tags = "缴存标准表模块(个人缴款标准设置)")
public class JcbzController {

	@Autowired
	private JcbzService jcbzService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = JcbzEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, JcbzEntity jcbzEntity) {

		return R.ok().put("data", jcbzService.queryByPage(pageNum, pageSize, jcbzEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = JcbzEntity.class)
	public R insert(@RequestBody JcbzEntity jcbzEntity) {
		String a=jcbzService.queryjcbzbm();
		String b = a.substring(0, 3);
		String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
		String jcbzbm = b + c;
		jcbzEntity.setJcbzbm(jcbzbm);
		jcbzService.insert(jcbzEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/update")
	@ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = JcbzEntity.class)
	public R update(@RequestBody JcbzEntity jcbzEntity) {
		jcbzService.updateById(jcbzEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = JcbzEntity.class)
	public R delete(@RequestBody String[] ids) {
		jcbzService.deleteBatch(ids);
		return R.ok();
	}

	@Login
	@PostMapping("/select")
	@ApiOperation(value = "编辑查询", notes = "在此补充接口详细注释...", response = JcbzEntity.class)
	public R select(@RequestBody String id) {

		return R.ok().put("select", jcbzService.selectById(id));
	}

}
