package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.service.JsgrwxzjService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 接收个人维修资金
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 09:53:01
 */
@RestController
@RequestMapping("app/jsgrwxzj")
@Api(tags = "接收个人维修资金模块(接收个人维修资金)")
public class JsgrwxzjController {

	@Autowired
	private JsgrwxzjService jsgrwxzjService;

	@Login
	@PostMapping("/selectxlk")
	@ApiOperation(value = "下拉框查询", notes = "", response = XlkEntity.class)
	public R selectxlk(@RequestBody String id) {

		return R.ok().put("select", jsgrwxzjService.selectxlk(id));
	}
	
	@Login
    @PostMapping("/insert")
    @ApiOperation(value = "保存", notes = "新增维修资金预交(操作Ywpz表)", response = YwpzEntity.class)
    public R insert(@RequestBody YwpzEntity ywpzEntity) {
		jsgrwxzjService.insertBc(ywpzEntity);
        return R.ok();
    }

}
