package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.service.LiXmService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * APP接口 小区信息
 *
 */
@RestController
@RequestMapping("/app/xm")
@Api(tags = "项目信息接口")
public class LiXmController {
    @Autowired
    private LiXmService lixmService;

    @Login
    @GetMapping("selectXm")
    @ApiOperation(value = "111",tags = "项目列表")
    public R selectXm(String xqbm){
        return R.ok().put("selectXm", lixmService.selectXm(xqbm));
    }
}

