package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.service.LiXqxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * APP接口 小区信息
 *
 */
@RestController
@RequestMapping("/app/xqxx")
@Api("小区信息接口")
public class LiXqxxController {

    @Autowired
    private LiXqxxService lixqxxService;

    @GetMapping("selectXqxx")
    @ApiOperation("小区信息（小区名称）")
    public R selectXqxx(){

        return R.ok().put("selectXqxx", lixqxxService.selectXqxx());
    }

}
