package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.service.LiZhxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * APP接口 楼盘幢号信息
 *
 */
@RestController
@RequestMapping("/app/zhxx")
@Api("楼盘幢号信息查询接口")
public class LiZhxxController {

    @Autowired
    private LiZhxxService liZhxxService;

    @GetMapping("zhxxSelect")
    @ApiOperation("幢号信息")
    public R zhxxSelect(String dhbm){

        return R.ok().put("zhxxSelect", liZhxxService.zhxxSelect(dhbm));
    }
}
