package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.LlbEntity;
import io.renren.modules.app.service.LlbService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 利率表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 17:18:24
 */
@RestController
@RequestMapping("app/llb")
@Api(tags = "利率表模块(利率维护)")
public class LlbController {

	@Autowired
	private LlbService llbService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = LlbEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, LlbEntity llbEntity) {

		return R.ok().put("data", llbService.queryByPage(pageNum, pageSize, llbEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = LlbEntity.class)
	public R insert(@RequestBody LlbEntity llbEntity) {
		String a=llbService.querybm();
		String b = a.substring(0, 3);
		String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
		String bm = b + c;
		llbEntity.setBm(bm);
		llbService.insert(llbEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/update")
	@ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = LlbEntity.class)
	public R update(@RequestBody LlbEntity llbEntity) {
		llbService.updateById(llbEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = LlbEntity.class)
	public R delete(@RequestBody String[] ids) {
		llbService.deleteBatch(ids);
		return R.ok();
	}

	@Login
	@PostMapping("/select")
	@ApiOperation(value = "编辑查询", notes = "在此补充接口详细注释...", response = LlbEntity.class)
	public R select(@RequestBody String id) {

		return R.ok().put("select", llbService.selectById(id));
	}

}
