package io.renren.modules.app.controller;


import io.renren.modules.app.entity.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.service.FhmxzService;
import io.renren.modules.app.service.MxzService;
import io.renren.modules.app.service.RjzService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.ArrayList;
import java.util.List;

/**
 * 日记账查询
 * @author Administrator
 *
 */
@RestController
@RequestMapping("app/mxz")
@Api(tags = "明细账查询")
public class MxzController {
	@Autowired
	private MxzService mxzService;
	
	@Login
	@GetMapping("mxzSelectByPage")
	@ApiOperation(value = "列表", notes = "明细账查询", response = MxzEntity.class)
	public R mxzSelectByPage(Integer pageNum, Integer pageSize,MxzEntity mxzEntity) throws Exception {
		return R.ok().put("data", mxzService.mxzSelectByPage(mxzEntity));
	}

	@Login
	@PostMapping("mxzSelect")
	@ApiOperation(value = "列表", notes = "明细账查询", response = MxzEntity.class)
	public R mxzSelect(@RequestBody List<MxzEntity> mxzEntity) throws Exception {
		List<List<MxzEntity>> list = new ArrayList<List<MxzEntity>>();
		List<MxzEntity> list2 = new ArrayList<MxzEntity>();
		for (MxzEntity s : mxzEntity) {
			list2 = mxzService.mxzSelectByPage(s);
			list.add(list2);
		}
		return R.ok().put("data", list);
	}
	
	@Login
	@GetMapping("select_pz")
	@ApiOperation(value = "凭证记录查询", notes = "凭证记录查询", response = HPzEntity2.class)
	public R select_pz(Integer pageNum, Integer pageSize,HPzEntity2 hPzEntity2) throws Exception {
		return R.ok().put("data", mxzService.select_pz(hPzEntity2));
	}
}
