package io.renren.modules.app.controller;


import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.RyEntity;
import io.renren.modules.app.service.RyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 操作员
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-06-11 10:08:42
 */
@RestController
@RequestMapping("app/ry")
@Api(tags = "操作员模块")
public class RyController {

    @Autowired
    private RyService ryService;


    @Login
    @GetMapping("queryByPage")
    @ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = RyEntity.class)
    public R queryByPage(Integer pageNum, Integer pageSize, RyEntity ryEntity) {

        return R.ok().put("data", ryService.queryByPage(pageNum, pageSize, ryEntity));
    }


    @Login
    @PostMapping("/insert")
    @ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = RyEntity.class)
    public R insert(@RequestBody RyEntity ryEntity) {
            ryService.insert(ryEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/update")
    @ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = RyEntity.class)
    public R update(@RequestBody RyEntity ryEntity) {
            ryService.updateById(ryEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/delete")
    @ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = RyEntity.class)
    public R delete(@RequestBody String[] ids) {
            ryService.deleteBatch(ids);
        return R.ok();
    }

}
