package io.renren.modules.app.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.SanlszzEntity;
import io.renren.modules.app.service.SanlszzService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.ArrayList;
import java.util.List;

/**
 * 三栏式总账表查询
 *
 * @author Administrator
 */
@RestController
@RequestMapping("app/sanlszz")
@Api(tags = "三栏式总账表查询")
public class SanlszzController {
    @Autowired
    private SanlszzService sanlszzService;

    @Login
    @GetMapping("sanlszzSelectByPage")
    @ApiOperation(value = "列表", notes = "三栏式总账表查询", response = SanlszzEntity.class)
    public R sanlszzSelectByPage(SanlszzEntity sanlszzEntity) throws Exception {
        return R.ok().put("data", sanlszzService.sanlszzSelect(sanlszzEntity));
    }

    @Login
    @PostMapping("sanlszzSelect")
    @ApiOperation(value = "列表", notes = "三栏式总账表查询", response = SanlszzEntity.class)
    public R sanlszzSelect(@RequestBody List<SanlszzEntity> sanlszz) throws Exception {
        List<List<SanlszzEntity>> list = new ArrayList<List<SanlszzEntity>>();
        List<SanlszzEntity> list2 = new ArrayList<SanlszzEntity>();
        for (SanlszzEntity s : sanlszz) {
            list2 = sanlszzService.sanlszzSelect(s);
            list.add(list2);
        }
        return R.ok().put("data", list);
    }
}
