package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.SfdwEntity;
import io.renren.modules.app.entity.SfdwEntity2;
import io.renren.modules.app.service.SfdwService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 售房单位（开发商）信息表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-26 09:17:19
 */
@RestController
@RequestMapping("app/sfdw")
@Api(tags = "售房单位（开发商）信息表模块(开发建设单位设置)")
public class SfdwController {

	@Autowired
	private SfdwService sfdwService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = SfdwEntity2.class)
	public R queryByPage(Integer pageNum, Integer pageSize, SfdwEntity2 sfdwEntity) {

		return R.ok().put("data", sfdwService.queryByPage(pageNum, pageSize, sfdwEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = SfdwEntity.class)
	public R insert(@RequestBody SfdwEntity sfdwEntity) {
		String a=sfdwService.querydwbm();
		String b = a.substring(0, 3);
		String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
		String dwbm = b + c;
		sfdwEntity.setDwbm(dwbm);
		sfdwService.insert(sfdwEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/update")
	@ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = SfdwEntity.class)
	public R update(@RequestBody SfdwEntity sfdwEntity) {
		sfdwService.updateById(sfdwEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = SfdwEntity.class)
	public R delete(@RequestBody String[] ids) {
		sfdwService.deleteBatch(ids);
		return R.ok();
	}

	@Login
	@PostMapping("/select")
	@ApiOperation(value = "编辑查询", notes = "", response = SfdwEntity.class)
	public R select(@RequestBody String id) {

		return R.ok().put("select", sfdwService.selectById(id));
	}

}
