package io.renren.modules.app.controller;


import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.SysDictEntity;
import io.renren.modules.app.service.SysDictService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 数据字典表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-04-01 11:31:35
 */
@RestController
@RequestMapping("app/sysdict")
@Api(tags = "数据字典表模块")
public class SysDictController {

    @Autowired
    private SysDictService sysDictService;


    @Login
    @GetMapping("queryByPage")
    @ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：字典名称name", response = SysDictEntity.class)
    public R queryByPage(Integer pageNum, Integer pageSize, SysDictEntity sysDictEntity) {

        return R.ok().put("data", sysDictService.queryByPage(pageNum, pageSize, sysDictEntity));
    }
    
    @Login
    @GetMapping("zdxlk")
    @ApiOperation(value = "字典类型下拉框", notes = "带分页、模糊查询，查询关键字：字典名称name", response = SysDictEntity.class)
    public R zdxlk(Integer pageNum, Integer pageSize, SysDictEntity sysDictEntity) {
        return R.ok().put("data", sysDictService.zdxlk());
    }


    @Login
    @PostMapping("/insert")
    @ApiOperation(value = "新增", notes = "", response = SysDictEntity.class)
    public R insert(@RequestBody SysDictEntity sysDictEntity) {
        return R.ok().put("num",  sysDictService.insertZDInfo(sysDictEntity));
    }


    @Login
    @PostMapping("/update")
    @ApiOperation(value = "修改", notes = "", response = SysDictEntity.class)
    public R update(@RequestBody SysDictEntity sysDictEntity) {
            sysDictService.updateById(sysDictEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/delete")
    @ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = SysDictEntity.class)
    public R delete(@RequestBody String[] ids) {
            sysDictService.deleteBatch(ids);
        return R.ok();
    }

    @Login
    @PostMapping("/selectCode")
    @ApiOperation(value = "查询字典码是否重复", notes = "查询字典码是否重复", response = SysDictEntity.class)
    public R selectCode(SysDictEntity sysDictEntity) {
    	return R.ok().put("num", sysDictService.selectCode(sysDictEntity));
    }

    @Login
    @GetMapping("/queryList")
    @ApiOperation(value = "下拉列表", notes = "传字典类型type", response = SysDictEntity.class)
    public R queryList(SysDictEntity sysDictEntity) {
        
        return R.ok().put("select", sysDictService.queryList(sysDictEntity));
    }

    @Login
    @GetMapping("/queryListLocal")
    @ApiOperation(value = "下拉列表", notes = "传字典类型type", response = SysDictEntity.class)
    public R queryListLocal(SysDictEntity sysDictEntity) {

        return R.ok().put("select", sysDictService.queryListLocal(sysDictEntity));
    }



}
