package io.renren.modules.app.controller;


import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.WxjlbEntity;
import io.renren.modules.app.service.WxjlbService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 房屋维修记录表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-04-22 14:07:27
 */
@RestController
@RequestMapping("app/wxjlb")
@Api(tags = "房屋维修记录表模块")
public class WxjlbController {

    @Autowired
    private WxjlbService wxjlbService;


    @Login
    @GetMapping("queryByPage")
    @ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = WxjlbEntity.class)
    public R queryByPage(Integer pageNum, Integer pageSize, WxjlbEntity wxjlbEntity) {

        return R.ok().put("data", wxjlbService.queryByPage(pageNum, pageSize, wxjlbEntity));
    }


    @Login
    @PostMapping("/insert")
    @ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = WxjlbEntity.class)
    public R insert(@RequestBody WxjlbEntity wxjlbEntity) {
            wxjlbService.insert(wxjlbEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/update")
    @ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = WxjlbEntity.class)
    public R update(@RequestBody WxjlbEntity wxjlbEntity) {
            wxjlbService.updateById(wxjlbEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/delete")
    @ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = WxjlbEntity.class)
    public R delete(@RequestBody String[] ids) {
            wxjlbService.deleteBatch(ids);
        return R.ok();
    }

}
