package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.WxxmxxEntity;
import io.renren.modules.app.service.WxxmxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 房屋维修项目信息
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 17:09:54
 */
@RestController
@RequestMapping("app/wxxmxx")
@Api(tags = "房屋维修项目信息模块(维修项目设置)")
public class WxxmxxController {

	@Autowired
	private WxxmxxService wxxmxxService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = WxxmxxEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, WxxmxxEntity wxxmxxEntity) {

		return R.ok().put("data", wxxmxxService.queryByPage(pageNum, pageSize, wxxmxxEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = WxxmxxEntity.class)
	public R insert(@RequestBody WxxmxxEntity wxxmxxEntity) {
		String a=wxxmxxService.querywxxmbm();
		String b = a.substring(0, 3);
		String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
		String wxxmbm = b + c;
		wxxmxxEntity.setWxxmbm(wxxmbm);
		wxxmxxEntity.setGzdbm("0001");
		wxxmxxService.insert(wxxmxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/update")
	@ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = WxxmxxEntity.class)
	public R update(@RequestBody WxxmxxEntity wxxmxxEntity) {
		wxxmxxService.updateById(wxxmxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = WxxmxxEntity.class)
	public R delete(@RequestBody String[] ids) {
		wxxmxxService.deleteBatch(ids);
		return R.ok();
	}

	@Login
	@PostMapping("/select")
	@ApiOperation(value = "编辑查询", notes = "在此补充接口详细注释...", response = WxxmxxEntity.class)
	public R select(@RequestBody String id) {

		return R.ok().put("select", wxxmxxService.selectById(id));
	}

}
