package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.DhbmyjEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.WxzjfpService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 维修资金分配
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 09:53:01
 */
@RestController
@RequestMapping("app/wxzjfp")
@Api(tags = "维修资金分配模块")
public class WxzjfpController {

	@Autowired
	private WxzjfpService wxzjfpService;

	//@Login
	@GetMapping("/queryByPagelb")
	@ApiOperation(value = "单位分配列表查询", notes = "选择项目下拉框条件", response = ZhxxEntity.class)
	public R queryByPagelb(Integer pageNum, Integer pageSize,ZhxxEntity zhxxEntity) {

		return R.ok().put("data", wxzjfpService.queryByPagelb(pageNum, pageSize,zhxxEntity));
	}

	@Login
	@PostMapping("/updatebydhbm")
	@ApiOperation(value = "保存", notes = "", response = ZhxxEntity.class)
	public R updatebydhbm(@RequestBody YwpzEntity ywpzEntity) {
		//1.判断分配的所有楼栋里有没有还没建房屋的楼栋，如果有存在没有房屋的楼栋，则此次无法分配。
		for(DhbmyjEntity d:ywpzEntity.getListdhandsj()){
			int count=wxzjfpService.selectsfyfw(d.getDhbm());
			if(count==0){
				return R.error("此次分配存在尚未建房屋的楼幢,请先在该楼幢下建完房屋再分配");
			}
		}
		wxzjfpService.updateByDhbm(ywpzEntity);

		return R.ok();
	}

	@Login
	@GetMapping("/queryByPage")
	@ApiOperation(value = "分配查询列表", notes = "维修资金分配查询", response = YwpzEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize,YwpzEntity ywpzEntity) {

		return R.ok().put("data", wxzjfpService.queryByPage(pageNum, pageSize,ywpzEntity));
	}
	
	@Login
	@PostMapping("/selectdj")
	@ApiOperation(value = "详情按钮", notes = "单据上部信息", response = YwpzEntity.class)
	public R selectxiangq(@RequestBody Map<String, String> map) {

		return R.ok().put("data", wxzjfpService.selectdj(map));
	}
	
	@Login
	@PostMapping("/selectdjlz")
	@ApiOperation(value = "详情按钮", notes = "单据楼幢信息", response = DhbmyjEntity.class)
	public R selectdjlz(@RequestBody Map<String, String> map) {

		return R.ok().put("data", wxzjfpService.selectdjlz(map));
	}

	@Login
	@PostMapping("/selectxlk")
	@ApiOperation(value = "下拉框查询", notes = "", response = XlkEntity.class)
	public R selectxlk(@RequestBody Map<String, String> map) {

		return R.ok().put("list", wxzjfpService.selectxlk(map));
	}

	@Login
	@PostMapping("/deletefp")
	@ApiOperation(value = "删除已分配", notes = "", response = ZhxxEntity.class)
	public R deletefp(@RequestBody Map<String, String> map) {
		wxzjfpService.deletefp(map);
		return R.ok();
	}

}
