package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.DhbmyjEntity;
import io.renren.modules.app.entity.JkbzEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.YwpzTempEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.GrwxzjService;
import io.renren.modules.app.service.WxzjyjService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * (开发商)维修资金预交
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 09:53:01
 */
@RestController
@RequestMapping("app/wxzjyj")
@Api(tags = "(开发商)维修资金预交模块")
public class WxzjyjController {

	@Autowired
	private WxzjyjService wxzjyjService;

	@Autowired
	private GrwxzjService grwxzjService;

	@Login
	@GetMapping("/queryByPage")
	@ApiOperation(value = "选择开发单位查询所在所有楼幢", notes = "预交页面开发单位下拉框选择对应单位编码和单位名称查询对应的幢号信息列表", response = ZhxxEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, ZhxxEntity zhxxEntity) {

		return R.ok().put("data", wxzjyjService.queryByPage(pageNum, pageSize, zhxxEntity));
	}

	@Login
	@PostMapping("/selectdwjjl")
	@ApiOperation(value = "单位叫缴交率查询", notes = "", response = JkbzEntity.class)
	public R selectdwjjl(@RequestBody JkbzEntity jkbzEntity) {

		return R.ok().put("list", wxzjyjService.selectdwjjl(jkbzEntity));
	}

	@Login
	@PostMapping("/updateone")
	@ApiOperation(value = "修改保存", notes = "点击编辑按钮，修改该条幢号信息", response = ZhxxEntity.class)
	public R updateone(@RequestBody ZhxxEntity zhxxEntity) {
		wxzjyjService.updatezhxx(zhxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "点击保存", notes = "新增维修资金预交(ywpz)", response = YwpzEntity.class)
	public R insert(@RequestBody YwpzEntity ywpzEntity) {
		// 勾选一条或者多条幢号信息然后做新增维修资金预交操作，如果这里获取到的幢号编码dhbm是一个集合，则可
		wxzjyjService.insertYj(ywpzEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/insertPLDR")
	@ApiOperation(value = "点击保存(批量导入)", notes = "新增维修资金预交(ywpz)", response = YwpzEntity.class)
	public R insertPLDR(@RequestBody List<YwpzEntity> list) {
		List<String> djbhlist = new ArrayList<String>();
		// 勾选一条或者多条幢号信息然后做新增维修资金预交操作，如果这里获取到的幢号编码dhbm是一个集合，则可
		for (YwpzEntity ywpzEntity : list) {
			String djbh = wxzjyjService.insertYj2(ywpzEntity);
			djbhlist.add(djbh);
			try {
				// 避免批量插入高并发，主键中的时间相同，导致主键冲突，此处设置每次停顿1秒
				Thread.currentThread().sleep(1000);
			} catch (InterruptedException e) {

				e.printStackTrace();
			}
		}
		// 为了后面将批量导入生成的dj自动生成凭证，则需要将导入生成的单据记录下来，记录在ywpldrdjjlb表中
		for (String djbh : djbhlist) {
			grwxzjService.insertywpldrjl(djbh);
		}

		return R.ok().put("data", djbhlist);
	}

	@Login
	@PostMapping("/selectxlk")
	@ApiOperation(value = "下拉框查询", notes = "", response = XlkEntity.class)
	public R selectxlk(@RequestBody String id) {

		return R.ok().put("select", wxzjyjService.selectxlk(id));
	}

	@Login
	@GetMapping("queryByPageC")
	@ApiOperation(value = "分页列表查询", notes = "首页查询预交的单据信息接口", response = YwpzEntity.class)
	public R queryByPageC(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", wxzjyjService.queryByPageC(pageNum, pageSize, ywpzEntity));
	}

	@Login
	@PostMapping("/selectck")
	@ApiOperation(value = "单据", notes = "单据详情", response = YwpzEntity.class)
	public R selectCK(@RequestBody Map<String, String> map) {

		return R.ok().put("select", wxzjyjService.selectCX(map));
	}

	@Login
	@PostMapping("/selectcklz")
	@ApiOperation(value = "楼幢", notes = "单据详情", response = DhbmyjEntity.class)
	public R selectCKlz(@RequestBody Map<String, String> map) {

		return R.ok().put("select", wxzjyjService.selectCXlz(map));
	}

	@Login
	@PostMapping("/deletedj")
	@ApiOperation(value = "删除按钮", notes = "只能删除未复核的单据")
	public R deletedj(@RequestBody YwpzEntity ywpzEntity) {

		wxzjyjService.deletedj(ywpzEntity);
		return R.ok();
	}

	// @Login
	@PostMapping("/selectxlkdw")
	@ApiOperation(value = "", notes = "", response = XlkEntity.class)
	public R selectxlkdw() {

		return R.ok().put("select", wxzjyjService.selectxlkdw());
	}

	@Login
	@PostMapping("/updatedjrq")
	@ApiOperation(value = "查询页面直接修改单据日期", notes = "")
	public R updatedjrq(@RequestBody YwpzEntity ywpzEntity) {

		wxzjyjService.updatedjrq(ywpzEntity);
		return R.ok();
	}

	// @Login
	@PostMapping("/zhxxyjje")
	@ApiOperation(value = "zhxxyjje(刷每栋楼的应缴金额)", notes = "")
	public R zhxxyjje() {

		wxzjyjService.zhxxyjje();
		return R.ok();
	}

	// @Login
	@PostMapping("/zhxxyjje2")
	@ApiOperation(value = "zhxxyjje2(刷每栋楼的应缴金额2(查询统计-楼栋信息页面，应缴金额刷新按钮接口))", notes = "")
	public R zhxxyjje2(@RequestBody List<ZhxxEntity> zlist) {
		for(ZhxxEntity zhxxEntity:zlist){
			wxzjyjService.zhxxyjje2(zhxxEntity);
		}
		
		return R.ok();
	}

	// @Login
	@PostMapping("/updatezhxxyjje2")
	@ApiOperation(value = "updatezhxxyjje2(刷每栋楼的应缴金额2(查询统计-楼栋信息页面，应缴金额修改保存接口))", notes = "")
	public R updatezhxxyjje2(@RequestBody ZhxxEntity zhxxEntity) {

		wxzjyjService.updatezhxxyjje2(zhxxEntity);
		return R.ok();
	}

	// @Login
	@PostMapping("/xdrjjsjyjje")
	@ApiOperation(value = "(刷新导入的基础数据楼栋的应缴金额，按新规则刷)", notes = "")
	public R xdrjjsjyjje() {

		wxzjyjService.xlrjcsjyjje();
		return R.ok();
	}

	// @Login
	@PostMapping("/DWYJXQXG")
	@ApiOperation(value = "单位预交详情修改", notes = "")
	public R DWYJXQXG(@RequestBody YwpzEntity ywpzEntity) {

		wxzjyjService.DWYJXQXG(ywpzEntity);
		return R.ok();
	}

	// @Login
	@PostMapping("/onexdrjjsjyjje")
	@ApiOperation(value = "(刷新导入的基础数据楼栋的某一栋应缴金额，按新规则刷)", notes = "")
	public R onexdrjjsjyjje() {

		wxzjyjService.onexlrjcsjyjje();
		return R.ok();
	}

	// @Login
	@PostMapping("/xmmczhxxdhbm")
	@ApiOperation(value = "(根据项目名称核栋号名称找到对应的栋号编码)", notes = "")
	public R xmmczhxxdhbm() {

		wxzjyjService.xmmczhxxdhbm();
		return R.ok();
	}

	// @Login
	@PostMapping("/dwyjghyjje")
	@ApiOperation(value = "(将已经单位预交审核的业务已交金额按蔡甸给的已交的实缴金额刷)", notes = "")
	public R dwyjghyjje() {

		wxzjyjService.dwyjghyjje();
		return R.ok();
	}

	// @Login
	@PostMapping("/lgjexc")
	@ApiOperation(value = "(判断两个金额是否相差在100以内)", notes = "")
	public R lgjexc() {

		wxzjyjService.lgjexc();
		return R.ok();
	}

}
