package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.DhbmyjEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.YwpzTempEntity;
import io.renren.modules.app.service.WxzjyjfhService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 维修资金预交复核
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 09:53:01
 */
@RestController
@RequestMapping("app/Wxzjyjfh")
@Api(tags = "维修资金预交复核模块")
public class WxzjyjfhController {

	@Autowired
	private WxzjyjfhService wxzjyjfhService;

	@Login
	@PostMapping("/selectxlk")
	@ApiOperation(value = "下拉框查询", notes = "", response = XlkEntity.class)
	public R selectxlk(@RequestBody Map<String, String> map) {

		return R.ok().put("list", wxzjyjfhService.selectxlk(map));
	}

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "单位复核查询列表", notes = "带分页、模糊查询，查询关键字：(维修资金预交查询)", response = YwpzEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", wxzjyjfhService.queryByPage(pageNum, pageSize, ywpzEntity));
	}

	@Login
	@PostMapping("/selectck")
	@ApiOperation(value = "单据", notes = "", response = YwpzEntity.class)
	public R selectCK(@RequestBody Map<String, String> map) {

		return R.ok().put("list", wxzjyjfhService.selectCX(map));
	}

	@Login
	@PostMapping("/selectcklz")
	@ApiOperation(value = "楼幢", notes = "", response = DhbmyjEntity.class)
	public R selectCKlz(@RequestBody Map<String, String> map) {

		return R.ok().put("list", wxzjyjfhService.selectCXlz(map));
	}

	// @Login
	@PostMapping("/updatefh")
	@ApiOperation(value = "复核按钮", notes = "", response = YwpzEntity.class)
	public R updatefh(@RequestBody List<DhbmyjEntity> dhyjs) {
		wxzjyjfhService.updateFH(dhyjs);
		return R.ok();
	}

	@Login
	@PostMapping("/updateqxfh")
	@ApiOperation(value = "取消复核按钮", notes = "", response = YwpzEntity.class)
	public R updateqxfh(@RequestBody List<DhbmyjEntity> dhyjs) {
		wxzjyjfhService.updateQXFH(dhyjs);
		return R.ok();
	}

	// @Login
	@PostMapping("/selectlistglb")
	@ApiOperation(value = "zhxx已交金额原始数据迁移脚本", notes = "")
	public R selectlistglb() {
		wxzjyjfhService.selectlistglb();
		return null;
	}

//	// @Login
//	@PostMapping("/selectzhxxsfjq")
//	@ApiOperation(value = "判断zhxx应缴金额和已交金额大小，改变是否交清状态sfdz脚本", notes = "")
//	public R selectzhxxsfjq() {
//		wxzjyjfhService.selectzhxxsfjq();
//		return null;
//	}
	
	// @Login
		@PostMapping("/selectzhxxsfjq2")
		@ApiOperation(value = "判断zhxx应缴金额和已交金额大小，改变是否交清状态sfdz脚本", notes = "")
		public R selectzhxxsfjq2() {
			wxzjyjfhService.selectzhxxsfjq2();
			return null;
		}

	// @Login
	@PostMapping("/fwsfyj")
	@ApiOperation(value = "", notes = "")
	public R fwsfyj() {
		// 原始数据房屋预交的判断就是ywpzmx表中03的单据的fw都是已经预交
		// 过或则预交已审核过的房屋，所有通过脚本将这些房屋的状态fwxx中sfyj字段改为1
		wxzjyjfhService.fwsfyj();
		return null;
	}

	// @Login
	@PostMapping("/sqrq")
	@ApiOperation(value = "sqwxzq录入单申请日期格式调整脚本", notes = "")
	public R sqrq() {
		wxzjyjfhService.sqrq();
		return null;
	}

	// @Login
	@PostMapping("/spje")
	@ApiOperation(value = "sqwxzq表原始数据已审核的的sqje刷sqje脚本", notes = "")
	public R spje() {
		wxzjyjfhService.spje();
		return null;
	}

	// @Login
	@PostMapping("/kfskm")
	@ApiOperation(value = "单位缴款凭证老系统数据xm表对应的kfskm字段刷脚本", notes = "")
	public R kfskm() {
		wxzjyjfhService.kfskm();
		return null;
	}

	// @Login
	@PostMapping("/ywpzdjrq")
	@ApiOperation(value = "ywpz中djrq去掉00：00：00", notes = "")
	public R ywpzdjrq() {
		wxzjyjfhService.ywpzdjrq();
		return null;
	}

}
