package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.WygsxxEntity;
import io.renren.modules.app.service.WygsxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 物业公司的基本信息
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 09:32:42
 */
@RestController
@RequestMapping("app/wygsxx")
@Api(tags = "物业公司的基本信息模块(物业公司设置)")
public class WygsxxController {

	@Autowired
	private WygsxxService wygsxxService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = WygsxxEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, WygsxxEntity wygsxxEntity) {

		return R.ok().put("data", wygsxxService.queryByPage(pageNum, pageSize, wygsxxEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = WygsxxEntity.class)
	public R insert(@RequestBody WygsxxEntity wygsxxEntity) {
		String a=wygsxxService.querywygsbm();
		String b = a.substring(0, 3);
		String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
		String wygsbm = b + c;
		wygsxxEntity.setWygsbm(wygsbm);
		wygsxxService.insert(wygsxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/update")
	@ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = WygsxxEntity.class)
	public R update(@RequestBody WygsxxEntity wygsxxEntity) {
		wygsxxService.updateById(wygsxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = WygsxxEntity.class)
	public R delete(@RequestBody String[] ids) {
		wygsxxService.deleteBatch(ids);
		return R.ok();
	}

	@Login
	@PostMapping("/select")
	@ApiOperation(value = "编辑查询", notes = "在此补充接口详细注释...", response = WygsxxEntity.class)
	public R select(@RequestBody String id) {

		return R.ok().put("select", wygsxxService.selectById(id));
	}

}
