package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YhxxEntity;
import io.renren.modules.app.service.XlkService;
import io.renren.modules.app.service.YhxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 下拉框
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 09:53:01
 */
@RestController
@RequestMapping("app/xlk")
@Api(tags = "下拉框")
public class XlkController {

	@Autowired
	private XlkService xlkService;

	// 下拉框数据获取
	// @Login
	@PostMapping("/selectxlk")
	@ApiOperation(value = "下拉框查询", notes = "", response = XlkEntity.class)
	public R selectxlk(@RequestBody Map<String, String> map) {

		return R.ok().put("list", xlkService.selectxlk(map));
	}

	// 分户明细账下拉框数据获取
	// @Login
	@PostMapping("/selectFHMXxlk")
	@ApiOperation(value = "分户明细账页面下拉框查询", notes = "", response = XlkEntity.class)
	public R selectFHMXxlk(@RequestBody Map<String, String> map) {

		return R.ok().put("data", xlkService.selectFHMXxlk(map));
	}

	// 单元明细账下拉框数据获取
	// @Login
	@PostMapping("/selectDYMXxlk")
	@ApiOperation(value = "单元明细账页面下拉框查询", notes = "", response = XlkEntity.class)
	public R selectDYMXxlk(@RequestBody Map<String, String> map) {

		return R.ok().put("data", xlkService.selectDYMXxlk(map));
	}

	// 开发单位下拉框数据获取
	// @Login
	@PostMapping("/selectKFDWxlk")
	@ApiOperation(value = "开发单位下拉框查询", notes = "", response = XlkEntity.class)
	public R selectKFDWxlk(@RequestBody Map<String, String> map) {

		return R.ok().put("data", xlkService.selectKFDWxlk(map));
	}

	// 综合明细账页面下拉框数据获取
	// @Login
	@PostMapping("/selectZHMXZxlk")
	@ApiOperation(value = "综合明细账页面下拉框查询", notes = "", response = XlkEntity.class)
	public R selectZHMXZxlk(@RequestBody Map<String, String> map) {

		return R.ok().put("data", xlkService.selectZHMXZxlk(map));
	}

	// 幢号信息页面下拉框数据获取
	// @Login
	@PostMapping("/selectzhxxxlk")
	@ApiOperation(value = "幢号信息页面下拉框查询", notes = "", response = XlkEntity.class)
	public R selectzhxxxlk(@RequestBody Map<String, String> map) {

		return R.ok().put("data", xlkService.selectzhxxxlk(map));
	}
}
