package io.renren.modules.app.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.FhmxzEntity;
import io.renren.modules.app.service.XmmxzService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 项目明细账查询
 * @author Administrator
 *
 */
@RestController
@RequestMapping("app/xmmxz")
@Api(tags = "项目明细账查询")
public class XmmxzController {
	@Autowired
	private XmmxzService xmmxzService;
	
	@Login
	@GetMapping("selectXMMXZByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = FhmxzEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize,FhmxzEntity fhmxzEntity) {
		return R.ok().put("data", xmmxzService.selectXMMXZByPage(pageNum, pageSize, fhmxzEntity));
	}
}
