package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.XqxxEntity;
import io.renren.modules.app.service.XqxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 小区信息
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-26 09:32:11
 */
@RestController
@RequestMapping("app/xqxx")
@Api(tags = "小区信息模块(小区信息)")
public class XqxxController {

	@Autowired
	private XqxxService xqxxService;

	// GIS查询小区所有信息
	// @Login
	@GetMapping("queryGisZs")
	@ApiOperation(value = "GIS查询小区所有信息", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = XqxxEntity.class)
	public R queryGisZs(XqxxEntity xqxxEntity) {
		return R.ok().put("data", xqxxService.queryGisZs());
	}

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = XqxxEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, XqxxEntity xqxxEntity) {
		return R.ok().put("data", xqxxService.queryByPage(pageNum, pageSize, xqxxEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = XqxxEntity.class)
	public R insert(@RequestBody XqxxEntity xqxxEntity) {
		String a = xqxxService.queryxqbm();
		String b = a.substring(0, 3);
		String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
		String xqbm = b + c;
		xqxxEntity.setXqbm(xqbm);
		xqxxService.insert(xqxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/update")
	@ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = XqxxEntity.class)
	public R update(@RequestBody XqxxEntity xqxxEntity) {
		xqxxService.updateById(xqxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = XqxxEntity.class)
	public R delete(@RequestBody String[] ids) {
		xqxxService.deleteBatch(ids);
		return R.ok();
	}

	@Login
	@PostMapping("/select")
	@ApiOperation(value = "编辑查询", notes = "", response = XqxxEntity.class)
	public R select(@RequestBody String id) {
		return R.ok().put("select", xqxxService.selectById(id));
	}

}
