package io.renren.modules.app.controller;


import java.util.Map;

import io.renren.modules.app.entity.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.service.FhmxzService;
import io.renren.modules.app.service.YeFseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 余额及发生额表查询
 * @author Administrator
 *
 */
@RestController
@RequestMapping("app/yefse")
@Api(tags = "余额及发生额表查询")
public class YeFseController {
	@Autowired
	private YeFseService yeFseService;
	
	@Login
	@PostMapping("selectYeFseByPage")
	@ApiOperation(value = "余额发生额表查询", notes = "查询关键字：(会计期间：qskjqj,zzkjqj)", response = HPzEntity.class)
	public R queryByPage(@RequestBody HPzEntity hPzEntity) {
		return R.ok().put("data", yeFseService.selectYeFseByPage(hPzEntity));
	}
	
	@Login
	@PostMapping("selectKmlb")
	@ApiOperation(value = "余额发生额表查询下拉框", notes = "带分页、模糊查询，查询关键字：", response = HKmlbEntity.class)
	public R selectKmlb(@RequestBody Map<String, String> map) {
		return R.ok().put("data", yeFseService.selectKmlb(map));
	}


}
