package io.renren.modules.app.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.ZhxxSelectEntity;
import io.renren.modules.app.service.ZhxxSelectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 幢号信息查询
 * @author Administrator
 *
 */
@RestController
@RequestMapping("app/zhxxSelect")
@Api(tags = "幢号信息查询")
public class ZhxxSelectController {
	@Autowired
	private ZhxxSelectService zhxxSelectService;
	
	@Login
	@GetMapping("selectZhxxByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = ZhxxSelectEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize,ZhxxSelectEntity zhxxSelectEntity) {
		return R.ok().put("data", zhxxSelectService.selectZhxxByPage(pageNum, pageSize, zhxxSelectEntity));
	}
}
