package io.renren.modules.app.controller;


import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.ZhxxtempEntity;
import io.renren.modules.app.service.ZhxxtempService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 幢号信息临时表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-04-26 09:08:00
 */
@RestController
@RequestMapping("app/zhxxtemp")
@Api(tags = "幢号信息临时表模块")
public class ZhxxtempController {

    @Autowired
    private ZhxxtempService zhxxtempService;


    @Login
    @GetMapping("queryByPage")
    @ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = ZhxxtempEntity.class)
    public R queryByPage(Integer pageNum, Integer pageSize, ZhxxtempEntity zhxxtempEntity) {

        return R.ok().put("data", zhxxtempService.queryByPage(pageNum, pageSize, zhxxtempEntity));
    }


    @Login
    @PostMapping("/insert")
    @ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = ZhxxtempEntity.class)
    public R insert(@RequestBody ZhxxtempEntity zhxxtempEntity) {
            zhxxtempService.insert(zhxxtempEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/update")
    @ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = ZhxxtempEntity.class)
    public R update(@RequestBody ZhxxtempEntity zhxxtempEntity) {
            zhxxtempService.updateById(zhxxtempEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/delete")
    @ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = ZhxxtempEntity.class)
    public R delete(@RequestBody String[] ids) {
            zhxxtempService.deleteBatch(ids);
        return R.ok();
    }

}
