package io.renren.modules.app.dao;

import io.renren.modules.app.entity.HZcfzEntity;
import com.baomidou.mybatisplus.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 资产负债表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-06-11 08:51:47
 */
@Mapper
public interface HZcfzDao extends BaseMapper<HZcfzEntity> {

    /**
     * 分页模糊查询
     *
     * @param hZcfzEntity
     * @return
     */
    List<HZcfzEntity> queryByPage(HZcfzEntity hZcfzEntity);

    /**
     * 删除资产负债表公式中的一行
     *
     * @param hZcfzEntity
     * @return
     */
    int deleteinfo(HZcfzEntity hZcfzEntity);

    /**
     * 修改资产负债表公式
     *
     * @param hZcfzEntity
     * @return
     */
    int updateZCFZ(HZcfzEntity hZcfzEntity);

    /**
     * NC
     *
     * @return
     */
    String selectNC(@Param("ztbm") String ztbm, @Param("kjqj") String kjqj, @Param("kmdm") String kmdm);

    String selectQC(@Param("ztbm") String ztbm, @Param("kjqj") String kjqj, @Param("kmdm") String kmdm);

    String selectQM_1(@Param("ztbm") String ztbm, @Param("kjqj") String kjqj, @Param("kmdm") String kmdm);

    String selectQM_else2(@Param("ztbm") String ztbm, @Param("kjqj") String kjqj, @Param("kmdm") String kmdm);

    String selectQM_else1(@Param("ztbm") String ztbm, @Param("kjqj") String kjqj, @Param("kmdm") String kmdm);

    String selectJF(@Param("ztbm") String ztbm, @Param("kjqj") String kjqj, @Param("kmdm") String kmdm);

    String selectDF(@Param("ztbm") String ztbm, @Param("kjqj") String kjqj, @Param("kmdm") String kmdm);

    String selectBNJF(@Param("ztbm") String ztbm, @Param("kjqj") String kjqj, @Param("kmdm") String kmdm);

    String selectBNDF(@Param("ztbm") String ztbm, @Param("kjqj") String kjqj, @Param("kmdm") String kmdm);

    String selectKJQJ(@Param("ztbm") String ztbm, @Param("kjqj") String kjqj);
}
