package io.renren.modules.app.entity;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 产权人信息（楼盘清册）表（房屋表）
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-26 09:43:59
 */
@Data
@TableName("fwxx")
@ApiModel(value = "产权人信息（楼盘清册）表（房屋表）")
public class FwxxEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	@ApiModelProperty("id类型")
	private String id;
	
	@ApiModelProperty("id类型")
	private String djbh;
	
	@ApiModelProperty("id类型")
	private String djlx;
	
	@ApiModelProperty("是否已缴")
	private String sfyj;
	@ApiModelProperty("是否已复核")
	private String sfyfh;
	
	@ApiModelProperty("房屋性质")
	private String value;

	@ApiModelProperty("所在小区")
	private String xqbm;
	@ApiModelProperty("小区名称")
	private String xqmc;
	@ApiModelProperty("项目名称")
	private String dwmc;
	@ApiModelProperty("项目名称")
	private String xmmc;
	@ApiModelProperty("项目编码")
	private String xmbm;
	@ApiModelProperty("楼栋名称")
	private String dhmc;
	@ApiModelProperty("楼栋编码")
	private String dhbm;
	@ApiModelProperty("单元名称")
	private String dymc;
	@ApiModelProperty("房屋单元编码")
	private String fwdybm;
	@ApiModelProperty("户数")
	private Integer hs;
	@ApiModelProperty("房屋展示名称")
	private String fwzsmc;
	@ApiModelProperty("单元的楼层数")
	private Integer lcs;

	@ApiModelProperty("产权证号（旧主键）")
	private String cczh;
	@ApiModelProperty("房屋编码(原主键)")
	private String fwbm;
	@ApiModelProperty("门牌号码")
	private String mphm;
	@ApiModelProperty("楼层")
	private Integer lc;
	@ApiModelProperty("户型编码")
	private String hx;
	@ApiModelProperty("户型名称")
	private String hxmc;
	@ApiModelProperty("房屋性质编码")
	private String fwxz;
	@ApiModelProperty("房屋性质名称")
	private String fwxzmc;
	@ApiModelProperty("销售单价")
	private Double ssdj;
	@ApiModelProperty("建筑面积")
	private Double mj;
	@ApiModelProperty("房屋总价")
	private Double fwje;
	@ApiModelProperty("购房日期")
	private String gfrq;
	@ApiModelProperty("另附面积")
	private Double lfmj;
	@ApiModelProperty("另附单价")
	private Double lfdj;
	@ApiModelProperty("另附金额")
	private Double lfje;
	@ApiModelProperty("总价款")
	private Double zjk;
	@ApiModelProperty("户型图")
	private String hxt;
	@ApiModelProperty("户主姓名")
	private String xm;
	@ApiModelProperty("证件号")
	private String sfzh;
	@ApiModelProperty("电话")
	private String lxdh;
	@ApiModelProperty("维修基金总额(个人应交)")
	private Double jjze;
	@ApiModelProperty("个人维修基金金额")
	private Double grje;
	@ApiModelProperty("单位维修基金金额")
	private Double dwje;
	@ApiModelProperty("当前余额")
	private Double dqye;
	@ApiModelProperty("房屋状态(0未售出,1已售出,3已销户")
	private String sfsc;
	@ApiModelProperty("门号(单元编码)")
	private String mh;
	@ApiModelProperty("个人交缴率")
	private Double grjjl;
	@ApiModelProperty("计算标准(0按面积,1按金额,2按造价)")
	private String jsbz;
	@ApiModelProperty("集归点编码")
	private String gzdbm;
	@ApiModelProperty("公共收益分配")
	private Double ggsy;
	@ApiModelProperty("支取首次分摊金额")
	private Double zqje;
	@ApiModelProperty("累计结息")
	private Double ljlx;
	@ApiModelProperty("年初余额")
	private Double ncye;
	@ApiModelProperty("销户金额(不含销户时结息)")
	private Double xhje;
	@ApiModelProperty("销户结息")
	private Double xhjx;
	@ApiModelProperty("购房合同号")
	private String htbh;
	@ApiModelProperty("购房发票号")
	private String fpbh;
	@ApiModelProperty("证件类别")
	private String zjlb;
	@ApiModelProperty("业主地址")
	private String dz;
	@ApiModelProperty("备注")
	private String bz;
	@ApiModelProperty("新的缴存标准编码")
	private String jcbzbm;
	@ApiModelProperty("房屋用途(0住宅1非住宅)")
	private String fwyt;
	@ApiModelProperty("个人标准审批状态(0,无状态,1.提交申请,2.同意3.不同意)")
	private String spzt;
	@ApiModelProperty("业主科目代码")
	private String yzkm;
	@ApiModelProperty("应交金额")
	private double jkje;
	@ApiModelProperty("分摊金额")
	private double sqje;
	@ApiModelProperty("申请单编号")
	private String sqdbh;
	@ApiModelProperty("决算金额")
	private double zsje;
	@ApiModelProperty("余额")
	private double ye;
	@ApiModelProperty("物业公司名称")
	private String wygsmc;
	@ApiModelProperty("单位编码")
	private String dwbm;
	
	@ApiModelProperty("")
	private String djrq;
	
	@ApiModelProperty("应缴金额")
	private double yjje;
	
	@ApiModelProperty("已交金额")
	private double yjjiao;
	
	@ApiModelProperty("单位交缴率")
	private Double dwjjl;
	
	@ApiModelProperty("手机号")
	private String sjh;
	
	@ApiModelProperty("是否交清")
	private String sfjq;
	
	@ApiModelProperty("支取首次分摊扣款方式（0只扣dwje，1-只扣grje，2先扣dwje再扣grje）")
	private String zqkkfs;
	
	@ApiModelProperty("支取首次分摊先扣dwje扣的钱")
	private Double zqdwje;
	
	@ApiModelProperty("支取余额分摊扣款方式（0只扣dwje，1-只扣grje，2先扣dwje再扣grje）")
	private String zqkkfs2;
	
	@ApiModelProperty("支取余额分摊先扣dwje扣的钱")
	private Double zqdwje2;
	
	@ApiModelProperty("支取余额分摊金额")
	private Double zqje2;
	
	@ApiModelProperty("")
	private Double je;
	
	@ApiModelProperty("账户金额")
	private double zhje;
	
	@ApiModelProperty("")
	private Double sqzje;
	
	@ApiModelProperty("首次分摊单元分摊金额")
	private Double dyftje;
	
	@ApiModelProperty("余额分摊单元分摊金额")
	private Double dyftje2;
	
	@ApiModelProperty("支取之前")
	private Double grje2;
	
	@ApiModelProperty("")
	private Double dwje2;
	
	@ApiModelProperty("支取之后")
	private Double grje3;
	
	@ApiModelProperty("")
	private Double dwje3;
	
	@ApiModelProperty("")
	private Double sumje;
	
	@ApiModelProperty("")
	private Double sumgrje;
	
	@ApiModelProperty("")
	private Double sumdwje;
	
	@ApiModelProperty("")
	private Double sumgrje2;
	
	@ApiModelProperty("")
	private Double sumdwje2;
	
	@ApiModelProperty("")
    private Double qdwje;
    
    @ApiModelProperty("")
    private Double qgrje;
    
    @ApiModelProperty("")
    private Double hdwje;
    
    @ApiModelProperty("")
    private Double hgrje;
}
