package io.renren.modules.app.entity;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 楼盘清册导入表
 *
 * @author lj
 * @email 3499722281@qq.com
 * @date 2019-03-26 09:49:15
 */
@Data
@TableName("楼盘清册导入")
@ApiModel(value = "楼盘清册导入表")
public class LpqcEntity implements Serializable{
	private static final long serialVersionUID = 1L;

	@ApiModelProperty("小区名称-其他表")
	private String xqmc;
	@ApiModelProperty("小区编码-其他表")
	private String xqbm;
	@ApiModelProperty("单位名称-其他表")
	private String dwmc;
	@ApiModelProperty("单位编码-其他表")
	private String dwbm;
	@ApiModelProperty("项目名称-其他表")
	private String xmmc;
	@ApiModelProperty("项目编码")
	private String xmbm;
	@ApiModelProperty("幢号名称")
	private String dhmc;
	@TableId
	@ApiModelProperty("幢号编码")
	private String dhbm;
	@ApiModelProperty("管委会名称-其他表")
	private String gwhmc;
	@ApiModelProperty("管委会编码")
	private String gwhbm;
	@ApiModelProperty("物业公司名称-其他表")
	private String wygsmc;
	@ApiModelProperty("物业公司编码")
	private String wygsbm;
	@ApiModelProperty("房屋结构")
	private String hwjg;
	@ApiModelProperty("房屋类型")
	private String hwlx;
	@ApiModelProperty("幢号")
	private String zh;
	@ApiModelProperty("单元数")
	private Integer drs;
	@ApiModelProperty("层数")
	private Integer lcs;
	@ApiModelProperty("户数")
	private Integer hs;
	@ApiModelProperty("缴纳标准(0按面积,1按金额)")
	private String jsbz;
	@ApiModelProperty("单位交缴率")
	private Double jkbz;
	@ApiModelProperty("个人交缴率")
	private Double grjjl;
	@ApiModelProperty("总造价")
	private Double zje;
	@ApiModelProperty("总面积")
	private Double zmj;
	@ApiModelProperty("人防面积")
	private Double rfmj;
	@ApiModelProperty("人防面积是否有效")
	private String sfrf;
	@ApiModelProperty("架空面积")
	private Double jkmj;
	@ApiModelProperty("架空面积是否有效")
	private String sfjk;
	@ApiModelProperty("竣工日期")
	private String zgrq;
	@ApiModelProperty("使用年限")
	private Integer nx;
	@ApiModelProperty("业主科目代码")
	private String yzkm;
	@ApiModelProperty("是否电梯")
	private String sfdt;
	@ApiModelProperty("是否公有住房")
	private String sfgf;
	@ApiModelProperty("无用字段")
	private String zhcon;
	@ApiModelProperty("已交金额")
	private Double dwze;
	@ApiModelProperty("单位维修基金总额(已交)")
	private Double dwyjje;
	@ApiModelProperty("个人维修基金总额(已交)")
	private Double gryjje;
	@ApiModelProperty("已售户数")
	private Integer yshs;
	@ApiModelProperty("累计支取金额")
	private Double zqje;
	@ApiModelProperty("")
	private Double je;
	@ApiModelProperty("无用字段")
	private Double dwye;
	@ApiModelProperty("余额")
	private Double dqye;
	@ApiModelProperty(" 归集点编码")
	private String gzdbm;
	@ApiModelProperty("单位是否已交清")
	private String sfdz;
	@ApiModelProperty("公共收益分配")
	private Double ggsy;
	@ApiModelProperty("累计结息")
	private Double ljlx;
	@ApiModelProperty("销户金额(不含销户利息)")
	private Double xhje;
	@ApiModelProperty("销户结息")
	private Double xhjx;
	@ApiModelProperty("0限整,1保留1位,2保留2位")
	private String digit;
	@ApiModelProperty("")
	private String ndjx;
	@ApiModelProperty("已交金额")
	private Double yjyjje;
	@ApiModelProperty("")
	private String yjdhbm;
	@ApiModelProperty("")
	private String yjbm;
	@ApiModelProperty("实缴金额")
	private Double yjsjje;
	@ApiModelProperty("欠缴金额")
	private Double yjqjje;
	@ApiModelProperty("幢号编码集合")
	private List<String> dhbmlist;
	@ApiModelProperty("地理位置")
	private String dz;
	@ApiModelProperty("地理位置")
	private String dlwz;
	@ApiModelProperty("是否分配")
	private String sffp;
	@ApiModelProperty("应缴金额")
	private Double yjje;
	@ApiModelProperty("单元编码(旧主键)")
	@TableId
	private String fwdybm;
	@ApiModelProperty("单元名称")
	private String dymc;
	@ApiModelProperty("单元号")
	private String dyh;
	@ApiModelProperty("备注")
	private String bz;
	@ApiModelProperty("id类型")
	private String id;
	@ApiModelProperty("是否已缴")
	private String sfyj;
	@ApiModelProperty("是否已复核")
	private String sfyfh;
	@ApiModelProperty("房屋性质")
	private String value;
	@ApiModelProperty("房屋展示名称")
	private String fwzsmc;
	@ApiModelProperty("产权证号（旧主键）")
	private String cczh;
	@ApiModelProperty("房屋编码(原主键)")
	private String fwbm;
	@ApiModelProperty("门牌号码")
	private String mphm;
	@ApiModelProperty("楼层")
	private Integer lc;
	@ApiModelProperty("户型编码")
	private String hx;
	@ApiModelProperty("户型名称")
	private String hxmc;
	@ApiModelProperty("房屋性质编码")
	private String fwxz;
	@ApiModelProperty("房屋性质名称")
	private String fwxzmc;
	@ApiModelProperty("销售单价")
	private Double ssdj;
	@ApiModelProperty("建筑面积")
	private Double mj;
	@ApiModelProperty("房屋总价")
	private Double fwje;
	@ApiModelProperty("购房日期")
	private String gfrq;
	@ApiModelProperty("另附面积")
	private Double lfmj;
	@ApiModelProperty("另附单价")
	private Double lfdj;
	@ApiModelProperty("另附金额")
	private Double lfje;
	@ApiModelProperty("总价款")
	private Double zjk;
	@ApiModelProperty("户型图")
	private String hxt;
	@ApiModelProperty("户主姓名")
	private String xm;
	@ApiModelProperty("证件号")
	private String sfzh;
	@ApiModelProperty("电话")
	private String lxdh;
	@ApiModelProperty("维修基金总额(个人应交)")
	private Double jjze;
	@ApiModelProperty("个人维修基金金额")
	private Double grje;
	@ApiModelProperty("单位维修基金金额")
	private Double dwje;
	@ApiModelProperty("房屋状态(0未售出,1已售出,3已销户")
	private String sfsc;
	@ApiModelProperty("门号(单元编码)")
	private String mh;
	@ApiModelProperty("年初余额")
	private Double ncye;
	@ApiModelProperty("购房合同号")
	private String htbh;
	@ApiModelProperty("购房发票号")
	private String fpbh;
	@ApiModelProperty("证件类别")
	private String zjlb;
	@ApiModelProperty("新的缴存标准编码")
	private String jcbzbm;
	@ApiModelProperty("房屋用途(0住宅1非住宅)")
	private String fwyt;
	@ApiModelProperty("个人标准审批状态(0,无状态,1.提交申请,2.同意3.不同意)")
	private String spzt;
	@ApiModelProperty("应交金额")
	private double jkje;
	@ApiModelProperty("分摊金额")
	private double sqje;
	@ApiModelProperty("申请单编号")
	private String sqdbh;
	@ApiModelProperty("决算金额")
	private double zsje;
	@ApiModelProperty("余额")
	private double ye;

}
