package io.renren.modules.app.entity;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 新增单元的房屋信息设定
 * 
 * @author Mark
 * @email sunlightcs@gmail.com
 * @date 2019-02-26 08:56:01
 */
@Data
@TableName("fwxx")
@ApiModel(value = "房屋信息")
public class XzdyFwxxSdEntity implements Serializable {

	private static final long serialVersionUID = 1L;

	@TableId
	@ApiModelProperty("主键")
	private String id;

	@ApiModelProperty("产权证号")
	private String cczh;

	@ApiModelProperty("房屋编码")
	private String fwbm;

	@ApiModelProperty("幢号编码")
	private String dhbm;

	@ApiModelProperty("门牌号码")
	private String mphm;

	@ApiModelProperty("楼层")
	private String lc;

	@ApiModelProperty("户型")
	private String hx;

	@ApiModelProperty("房屋性质")
	private String fwxz;

	@ApiModelProperty("销售单价")
	private double ssdj;

	@ApiModelProperty("建筑面积")
	private double mj;

	@ApiModelProperty("房屋总价")
	private double fwje;

	@ApiModelProperty("购房日期")
	private String gfrq;

	@ApiModelProperty("另附面积")
	private double lfmj;

	@ApiModelProperty("另附单价")
	private double lfdj;

	@ApiModelProperty("另附金额")
	private double lfje;

	@ApiModelProperty("总价款")
	private double zjk;

	@ApiModelProperty("户型图")
	private String hxt;

	@ApiModelProperty("户主姓名")
	private String xm;

	@ApiModelProperty("证件号")
	private double sfzh;

	@ApiModelProperty("电话")
	private double lxdh;

	@ApiModelProperty("维修基金总额(个人应交)")
	private double jjze;

	@ApiModelProperty("个人维修基金金额")
	private double grje;

	@ApiModelProperty("单位维修基金金额")
	private double dwje;

	@ApiModelProperty("当前余额")
	private double dqye;

	@ApiModelProperty("房屋状态(0未售出,1已售出,3已销户)")
	private String sfsc;

	@ApiModelProperty("门号(单元编码)")
	private double mh;

	@ApiModelProperty("个人交缴率")
	private double grjjl;

	@ApiModelProperty("计算标准(0按面积,1按金额,2按造价)")
	private String jsbz;

	@ApiModelProperty("集归点编码")
	private String gzdbm;

	@ApiModelProperty("公共收益分配")
	private double ggsy;

	@ApiModelProperty("支取金额")
	private double zqje;

	@ApiModelProperty("累计结息")
	private double ljlx;

	@ApiModelProperty("年初余额")
	private double ncye;

	@ApiModelProperty("销户金额(不含销户时结息)")
	private double xhje;

	@ApiModelProperty("销户结息")
	private double xhjx;

	@ApiModelProperty("购房合同号")
	private String htbh;

	@ApiModelProperty("购房发票号")
	private String fpbh;

	@ApiModelProperty("证件类别")
	private String zjlb;

	@ApiModelProperty("业主地址")
	private String dz;

	@ApiModelProperty("备注")
	private String bz;

	@ApiModelProperty("新的缴存标准编码")
	private String jcbzbm;

	@ApiModelProperty("房屋用途(0住宅1非住宅)")
	private String fwyt;

	@ApiModelProperty("个人标准审批状态(0,无状态,1.提交申请,2.同意3.不同意)")
	private String spzt;

	@ApiModelProperty("业主科目代码")
	private String yzkm;
//
	@ApiModelProperty("单元房屋编码")
	private String fwdybm;

	@ApiModelProperty("单元名称")
	private String dymc;

	@ApiModelProperty("户数")
	private String hs;
	
	//个人维修资金复核查询
	@ApiModelProperty("项目名称")
	private String xmmc;

	@ApiModelProperty("幢号名称")
	private String dhmc;
	
	@ApiModelProperty("项目编码")
	private String xmbm;

}
