package io.renren.modules.app.entity;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 维修基金业务表(YWPZ_DY)（交款通知书表）
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-04-09 16:07:28
 */
@Data
@TableName("ywpz_dy")
@ApiModel(value = "维修基金业务表(YWPZ_DY)（交款通知书表）")
public class YwpzDyEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	@ApiModelProperty("单据编号")
	@TableId
	private String djbh;
	@ApiModelProperty("单据类型(0单位1个人)")
	private String djlx;
	@ApiModelProperty("日期")
	private String djrq;
	@ApiModelProperty("单位编码")
	private String dwbm;
	@ApiModelProperty("单位名称/个人姓名")
	private String dwmc;
	@ApiModelProperty("项目编码")
	private String xmbm;
	@ApiModelProperty("屋房坐落")
	private String fwdz;
	@ApiModelProperty("屋房编码")
	private String fwbm;
	@ApiModelProperty("承办网点编码")
	private String cbwdbm;
	@ApiModelProperty("归集点编码")
	private String gzdbm;
	@ApiModelProperty("金额")
	private Double je;
	@ApiModelProperty("面积")
	private Double mj;
	@ApiModelProperty("操作员编码")
	private String czybm;
	@ApiModelProperty("操作员名称")
	private String czyxm;
	@ApiModelProperty("备注")
	private String bz;
	@ApiModelProperty("会计期间")
	private String kjqj;
	// ---
	@ApiModelProperty("幢号编码")
	private String dhbm;
	@ApiModelProperty("门牌号码")
	private String mphm;

	@ApiModelProperty("户主姓名")
	private String xm;
	@ApiModelProperty("产权证号（旧主键）")
	private String cczh;
	@ApiModelProperty("项目名称")
	private String xmmc;
	@ApiModelProperty("所在小区")
	private String xqbm;
	@ApiModelProperty("楼栋名称")
	private String dhmc;
	@ApiModelProperty("开始单据日期")
	private String beginrq;
    @ApiModelProperty("结束单据日期")
	private String endrq;
    @ApiModelProperty("操作日期")
	private String czrq;
    @ApiModelProperty("所在小区")
	private String xqmc;
}
