package io.renren.modules.app.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.CbwdDao;
import io.renren.modules.app.entity.CbwdEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.service.CbwdService;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

@Service("cbwdService")
public class CbwdServiceImpl extends ServiceImpl<CbwdDao, CbwdEntity> implements CbwdService {

	/**
	 * 分页模糊查询
	 * 
	 * @param pageNum
	 * @param pageSize
	 * @param cbwdEntity
	 * @return
	 */
	@Override
	public PageInfo<CbwdEntity> queryByPage(Integer pageNum, Integer pageSize, CbwdEntity cbwdEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<CbwdEntity> cbwdEntitys = baseMapper.queryByPage(cbwdEntity);
		PageInfo<CbwdEntity> pageInfo = new PageInfo<CbwdEntity>(cbwdEntitys);
		return pageInfo;
	}

	/**
	 * 单个或批量删除
	 * 
	 * @param ids
	 */
	@Override
	public void deleteBatch(String[] ids) {
		this.deleteBatchIds(Arrays.asList(ids));
	}

	// 银行信息下拉框
	@Override
	public List<XlkEntity> selectYhxx() {

		return baseMapper.selectyhxx();
	}

	@Override
	public String querycbwdbm() {
		
		return baseMapper.querycbwdbm();
	}

}