package io.renren.modules.app.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.DwjktzsDao;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzDyEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.DwjktzsService;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.springframework.stereotype.Service;

@Service("dwjktzsService")
public class DwjktzsServiceImpl extends ServiceImpl<DwjktzsDao, YwpzEntity> implements DwjktzsService {

	@Override
	public List<XlkEntity> selectxlk(Map<String, String> map) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if (map.isEmpty()) {
			list = baseMapper.selectdw();
		} else if ("dwbm".equals(map.get("DWBM"))) {
			list = baseMapper.selectxm(map.get("dwbmz"));
		} else if ("xmbm".equals(map.get("XMBM"))) {
			list = baseMapper.selectlz(map.get("xmbmz"));
		}
		return list;
	}

	@Override
	public PageInfo<ZhxxEntity> queryByPage(Integer pageNum, Integer pageSize, ZhxxEntity zhxxEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<ZhxxEntity> zhxxEntitys = baseMapper.queryByPage(zhxxEntity);
		PageInfo<ZhxxEntity> pageInfo = new PageInfo<ZhxxEntity>(zhxxEntitys);
		return pageInfo;
	}

	@Override
	public void insertBc(YwpzDyEntity ywpzdyEntity) {
		String temp_str = "";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		temp_str = sdf.format(dt);

		String temp_str1 = "";
		Date dt1 = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
		temp_str1 = sdf1.format(dt1);
		String maxdjbh = baseMapper.queryByCount(ywpzdyEntity.getDjrq());
		String newdjbh = "";
		if ("".equals(maxdjbh) || maxdjbh == null) {
			newdjbh = "0" + temp_str1 + "0001";
		} else if (!"".equals(maxdjbh) && maxdjbh != null) {
			String aa = Integer.parseInt(maxdjbh) + 1 + "";
			DecimalFormat df = new DecimalFormat("0000");
			String result = df.format(Integer.parseInt(aa));
			newdjbh = "0" + temp_str1 + result;
		}
		ywpzdyEntity.setDjbh(newdjbh);
		ywpzdyEntity.setDjlx("0");
		ywpzdyEntity.setCzrq(temp_str);
		baseMapper.insertbc(ywpzdyEntity);
	}

	@Override
	public PageInfo<YwpzDyEntity> queryByPageC(Integer pageNum, Integer pageSize, YwpzDyEntity ywpzDyEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzDyEntity> ywpzdyEntitys = baseMapper.queryByPageC(ywpzDyEntity);
		PageInfo<YwpzDyEntity> pageInfo = new PageInfo<YwpzDyEntity>(ywpzdyEntitys);
		return pageInfo;
	}

	@Override
	public void deletedy(XlkEntity xlkEntity) {
		baseMapper.deletedy(xlkEntity);
	}

}
