package io.renren.modules.app.service.impl;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;

import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.renren.modules.app.dao.DwmxzDao;
import io.renren.modules.app.entity.FhmxzEntity;
import io.renren.modules.app.service.DwmxzService;

@Service("dwmxzService")
public class DwmxzServiceImpl extends ServiceImpl<DwmxzDao, FhmxzEntity> implements DwmxzService {
    /**
     * 计算余额
     *
     * @param pageNum
     * @param pageSize
     * @param fhmxzEntity
     * @return
     */
    public String ye(Integer pageNum, Integer pageSize, FhmxzEntity fhmxzEntity) {
        int limit = (pageNum - 1) * pageSize;
        String qmye = null;
        String dwbm = fhmxzEntity.getDwbm();
        String begdate = fhmxzEntity.getBegdate();
        String enddate = fhmxzEntity.getEnddate();
        // 余额
        double ye = 0.0;
        // 借方本金
        double jfbj = 0.0;
        // 借方利息
        double jflx = 0.0;
        // 贷方本金
        double dfbj = 0.0;
        // 贷方利息
        double dflx = 0.0;
        List<FhmxzEntity> list = baseMapper.selectDWMXZ_2(limit, begdate, enddate, dwbm);
        for (int i = 0; i < list.size(); i++) {
            if (i == 0) {
                ye = Double.parseDouble(list.get(i).getYe());
                continue;
            }
            jfbj = Double.parseDouble(list.get(i).getJfbj());
            dfbj = Double.parseDouble(list.get(i).getDfbj());

            ye = ye + dfbj - jfbj;
            // 保留两位小数四舍五入
            BigDecimal b = new BigDecimal(ye);
            double f1 = b.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();

            DecimalFormat df = new DecimalFormat("0.00");// 格式化
            qmye = df.format(f1);
        }
        return qmye;
    }

    /**
     * 开发建设单位明细账
     *
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Override
    public PageInfo<FhmxzEntity> selectDWMXZByPage(Integer pageNum, Integer pageSize, FhmxzEntity fhmxzEntity) {
        int flag = 0;
        Double dfbj2 = 0.0;
        Double jfbj2 = 0.0;
        // 余额
        double ye = 0.0;
        // 借方本金
        double jfbj = 0.0;
        // 借方利息
        double jflx = 0.0;
        // 贷方本金
        double dfbj = 0.0;
        // 贷方利息
        double dflx = 0.0;
        if (pageNum != 1) {
            flag = 1;
            String ljye = ye(pageNum, pageSize, fhmxzEntity);
            ye = Double.parseDouble(ljye);
        }
        List<FhmxzEntity> list2 = baseMapper.selectDWMXZ(fhmxzEntity);
        FhmxzEntity entity = new FhmxzEntity();
        for (int i = 0; i < list2.size(); i++) {
            double dfbj3 = Double.parseDouble(list2.get(i).getDfbj());
            dfbj2 = dfbj2 + dfbj3;

            double jfbj3 = Double.parseDouble(list2.get(i).getJfbj());
            jfbj2 = jfbj2 + jfbj3;
        }
        PageHelper.startPage(pageNum, pageSize);
        List<FhmxzEntity> list = baseMapper.selectDWMXZ(fhmxzEntity);
        for (int i = 0; i < list.size(); i++) {
            if (i == 0) {
                if (flag != 1) {
                    ye = Double.parseDouble(list.get(i).getYe());
                    continue;
                }
            }
            jfbj = Double.parseDouble(list.get(i).getJfbj());
            dfbj = Double.parseDouble(list.get(i).getDfbj());

            ye = ye + dfbj - jfbj;
            // 保留两位小数四舍五入
            BigDecimal b = new BigDecimal(ye);
            double f1 = b.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();

            DecimalFormat df = new DecimalFormat("0.00");// 格式化
            String qmye = df.format(f1);
            list.get(i).setYe(qmye);
        }
        entity.setIshj("1");
        entity.setDfbj(dfbj2.toString());
        entity.setJfbj(jfbj2.toString());
        list.add(entity);
        PageInfo<FhmxzEntity> pageInfo = new PageInfo<FhmxzEntity>(list);
        return pageInfo;
    }

}
