package io.renren.modules.app.service.impl;


import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.GoodsDao;
import io.renren.modules.app.entity.GoodsEntity;
import io.renren.modules.app.service.GoodsService;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;


@Service("goodsService")
public class GoodsServiceImpl extends ServiceImpl<GoodsDao, GoodsEntity> implements GoodsService {


    /**
     * 分页模糊查询
     * @param pageNum
     * @param pageSize
     * @param goodsEntity
     * @return
     */
    @Override
    public PageInfo<GoodsEntity> queryByPage(Integer pageNum, Integer pageSize, GoodsEntity goodsEntity) {
        PageHelper.startPage(pageNum, pageSize);
        List<GoodsEntity> goodsEntitys = baseMapper.queryByPage(goodsEntity);
        PageInfo<GoodsEntity> pageInfo = new PageInfo<GoodsEntity>(goodsEntitys);
        return pageInfo;
    }

    /**
    * 单个或批量删除
    * @param ids
    */
    @Override
    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }


}