package io.renren.modules.app.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.GrjktzsDao;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzDyEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.GrjktzsService;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.springframework.stereotype.Service;

@Service("grjktzsService")
public class GrjktzsServiceImpl extends ServiceImpl<GrjktzsDao, YwpzEntity> implements GrjktzsService {

	@Override
	public List<XlkEntity> selectxlk(Map<String, String> map) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if (map.isEmpty()) {
			// 查询所有小区
			list = baseMapper.selectxq();
		} else if ("xqbm".equals(map.get("XQBM"))) {
			// 通过小区编码查询对应项目
			list = baseMapper.selectxm(map.get("xqbmz"));
		} else if ("xmbm".equals(map.get("XMBM"))) {
			// 通过项目编码查楼幢
			list = baseMapper.selectlz(map.get("xmbmz"));
		} else if ("dhbm".equals(map.get("DHBM"))) {
			// 通过幢号编码查房屋
			list = baseMapper.selectfw(map.get("dhbmz"));
		} else if ("fwbm".equals(map.get("FWBM"))) {
			// 通过房屋编码查询房屋信息
			list = baseMapper.selectfwxx(map.get("fwbmz"));
		}
		return list;
	}

	@Override
	public void insertBc(YwpzDyEntity ywpzdyEntity) {
		String temp_str="";   
	    Date dt = new Date();   
	    //最后的aa表示“上午”或“下午”    HH表示24小时制    如果换成hh表示12小时制   
	    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
	    temp_str=sdf.format(dt);
	    
	    String temp_str1 = "";
		Date dt1 = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
		temp_str1 = sdf1.format(dt1);
		String maxdjbh = baseMapper.queryByCount(ywpzdyEntity.getDjrq());
		String newdjbh = "";
		if ("".equals(maxdjbh) || maxdjbh == null) {
			newdjbh = "1" + temp_str1 + "0001";
		} else if (!"".equals(maxdjbh) && maxdjbh != null) {
			String aa = Integer.parseInt(maxdjbh) + 1 + "";
			DecimalFormat df = new DecimalFormat("0000");
			String result = df.format(Integer.parseInt(aa));
			newdjbh = "1" + temp_str1 + result;
		}
		ywpzdyEntity.setDjbh(newdjbh);
		ywpzdyEntity.setDjlx("1");
		ywpzdyEntity.setCzrq(temp_str);
		baseMapper.insertbc(ywpzdyEntity);
	}

	@Override
	public PageInfo<YwpzDyEntity> queryByPage(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzDyEntity> list = baseMapper.queryByPage(ywpzEntity);
		PageInfo<YwpzDyEntity> pageInfo = new PageInfo<YwpzDyEntity>(list);
		return pageInfo;
	}

	@Override
	public void delete(YwpzDyEntity ywpzDyEntity) {
		
		baseMapper.deletedy(ywpzDyEntity);
	}


}
