package io.renren.modules.app.service.impl;

import com.alibaba.druid.sql.ast.statement.SQLIfStatement.Else;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.mysql.fabric.xmlrpc.base.Array;
//import com.sun.xml.internal.ws.policy.EffectiveAlternativeSelector;

import io.renren.common.utils.R;
import io.renren.modules.app.dao.GrwxzjDao;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.GryjpldrtempEntity;
import io.renren.modules.app.entity.HPzEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.XmEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.YwpzmxEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.GrwxzjService;
import io.renren.modules.app.utils.MoneyUtil;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service("grwxzjService")
public class GrwxzjServiceImpl extends ServiceImpl<GrwxzjDao, YwpzEntity> implements GrwxzjService {

	private static String REGEX_CHINESE = "[\u4e00-\u9fa5]";// 中文正则

	@Override
	public List<XlkEntity> selectxlk(Map<String, String> map) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if (map.isEmpty()) {
			list = baseMapper.selectdw();
		} else if ("dwbm".equals(map.get("DWBM"))) {
			list = baseMapper.selectxm(map.get("dwbmz"));
		} else if ("xmbm".equals(map.get("XMBM"))) {
			list = baseMapper.selectzh(map.get("xmbmz"));
		} else if ("dhbm".equals(map.get("DHBM"))) {
			list = baseMapper.selectfwbm(map.get("dhbmz"));
			for (XlkEntity x : list) {
				String jsbz = x.getJsbz();
				if ("0".equals(jsbz)) {// 按面积
					Double Yjje = x.getMj() * x.getGrjjl();
					Yjje = (double) Math.round(Yjje);
					x.setYjje(Yjje);
				} else if ("1".equals(jsbz)) {// 按造价
					Double Yjje = 0.0;
					if (x.getFwje() != 0 || x.getFwje() != null) {
						Yjje = x.getFwje() * x.getGrjjl();
						Yjje = (double) Math.round(Yjje);
					}
					x.setYjje(Yjje);
				}
				// YwpzmxEntity mm = baseMapper.selectfwsfjq(x.getFwbm());
				Double yjiao = 0.0;
				if (x.getJe() == null) {
					yjiao = 0.0;
				} else {
					yjiao = x.getJe();
				}
				Double qjje = x.getYjje() - yjiao;
				x.setQjje(qjje);
			}
		} else if ("skyh".equals(map.get("SKYH"))) {
			list = baseMapper.selectyh();
		} else if ("jsfs".equals(map.get("JSFS"))) {
			list = baseMapper.selectjsfs();
		} else if ("fwbm".equals(map.get("FWBM"))) {
			list = baseMapper.selectfwxx(map.get("fwbmz"));
		}
		return list;
	}

	@Override
	public void insertGr(YwpzEntity ywpzEntity) {
		// 获取单据编号
		String temp_str = "";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		temp_str = sdf.format(dt);

		String temp_str1 = "";
		Date dt1 = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
		temp_str1 = sdf1.format(dt1);
		String maxdjbh = baseMapper.queryByCount(ywpzEntity.getDjrq());
		String newdjbh = "";
		if ("".equals(maxdjbh) || maxdjbh == null) {
			newdjbh = "03" + temp_str1 + "0001";
		} else if (!"".equals(maxdjbh) && maxdjbh != null) {
			String aa = Integer.parseInt(maxdjbh) + 1 + "";
			DecimalFormat df = new DecimalFormat("0000");
			String result = df.format(Integer.parseInt(aa));
			newdjbh = "03" + temp_str1 + result;
		}
		ywpzEntity.setDjbh(newdjbh);
		ywpzEntity.setDjlx("03");
		ywpzEntity.setGzdbm("0001");
		ywpzEntity.setPzh(null);
		ywpzEntity.setCzrq(temp_str);
		baseMapper.insertgr(ywpzEntity);
		baseMapper.insertgrmx(ywpzEntity);
		Double yjje = ywpzEntity.getYjje();// 房屋应缴金额
		// 查询该房屋已缴金额（直接查业务明细表ywpzmx）
		YwpzmxEntity mm = baseMapper.selectfwsfjq(ywpzEntity.getFwbm());
		int val = yjje.compareTo(mm.getJe());
		if (val > 0) {
			baseMapper.updatefwsfjq0(ywpzEntity.getFwbm());// sfjq=0
		} else if (val <= 0) {
			baseMapper.updatefwsfjq(ywpzEntity.getFwbm());// sfjq=1
		}
		// int iva=je.compareTo(yjje);
		baseMapper.updatefwxxsfyj(ywpzEntity.getFwbm());
	}

	/**
	 * 分页模糊查询
	 * 
	 * @param pageNum
	 * @param pageSize
	 * @param ywpzEntity
	 * @return
	 */
	@Override
	public PageInfo<YwpzEntity> queryByPage(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		List<YwpzEntity> ywHPzEntities111 = baseMapper.queryByPage(ywpzEntity);
		Double sumje = 0.0;
		for (YwpzEntity y : ywHPzEntities111) {
			sumje = sumje + y.getJe();
		}
		sumje = (double) Math.round(sumje * 100) / 100;
		PageHelper.startPage(pageNum, pageSize);
		// ywpzEntity.setBeginrq(ywpzEntity.getBeginrq() + " 00:00:00");
		// ywpzEntity.setEndrq(ywpzEntity.getEndrq() + " 00:00:00");//查老系统数据用到的
		List<YwpzEntity> ywpzEntitys = baseMapper.queryByPage(ywpzEntity);
		if (!ywpzEntitys.isEmpty()) {
			ywpzEntitys.get(0).setJezh(sumje);
		}
		for (YwpzEntity y : ywpzEntitys) {
			String a = y.getJe().toString();
			y.setJedx(MoneyUtil.toChinese(a));
			String jsbz = y.getJsbz();
			if ("0".equals(jsbz)) {// 按面积
				Double Yjje = y.getMj() * y.getGrjjl();
				Yjje = (double) Math.round(Yjje);
				y.setYjje(Yjje);
			} else if ("1".equals(jsbz)) {// 按造价
				Double Yjje = 0.0;
				if (y.getFwje() != 0 || y.getFwje() != null) {
					Yjje = y.getFwje() * y.getGrjjl();
					Yjje = (double) Math.round(Yjje);
				}
				y.setYjje(Yjje);
			}
		}
		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywpzEntitys);
		return pageInfo;
	}

	@Override
	public void deletegr(String id) {
		FwxxEntity f = baseMapper.selectywpzmx(id);

		baseMapper.deletemx(id);
		baseMapper.deleteywpz(id);
		FwxxEntity f2 = baseMapper.selectfwxxbybm(f.getFwbm());
		String jsbz = f2.getJsbz();
		if ("0".equals(jsbz)) {// 按面积
			Double Yjje = f2.getMj() * f2.getGrjjl();
			Yjje = (double) Math.round(Yjje);
			f2.setYjje(Yjje);
		} else if ("1".equals(jsbz)) {// 按造价
			Double Yjje = 0.0;
			if (f2.getFwje() != 0 || f2.getFwje() != null) {
				Yjje = f2.getFwje() * f2.getGrjjl();
				Yjje = (double) Math.round(Yjje);
			}
			f2.setYjje(Yjje);
		}
		Double yingj = f2.getYjje();
		YwpzmxEntity mm = baseMapper.selectfwsfjq(f2.getFwbm());
		Double yjiao = 0.0;
		if (isObjectNotEmpty(mm) == false) {
			baseMapper.updatefwxxsfyj2(f.getFwbm());
			yjiao = 0.0;
		} else {
			yjiao = mm.getJe();
		}
		int val = yingj.compareTo(yjiao);
		if (val > 0) {
			baseMapper.updatefwsfjq0(f2.getFwbm());// sfjq=0
		} else if (val <= 0) {
			baseMapper.updatefwsfjq(f2.getFwbm());// sfjq=1
		}
	}

	@Override
	public String insertGrpldr(YwpzEntity ywpzEntity) {
		// 1.先更新房屋信息
		FwxxEntity f = new FwxxEntity();
		f.setFwbm(ywpzEntity.getFwbm());
		if (!"".equals(ywpzEntity.getXm()) && ywpzEntity.getXm() != null) {
			f.setXm(ywpzEntity.getXm());
		}
		if (!"".equals(ywpzEntity.getSjh()) && ywpzEntity.getSjh() != null) {
			f.setLxdh(ywpzEntity.getSjh());
		}
		// FwxxEntity
		// fwxxEntity=baseMapper.selectfwxxmph(ywpzEntity.getFwbm());//查门牌号
		// FwxxEntity
		// fwxxEntity2=baseMapper.selectxmmc(ywpzEntity.getDhbm());//查项目名称
		// f.setDz(fwxxEntity2.getXmmc()+fwxxEntity.getMphm());
		// f.setDz(ywpzEntity.getDz());
		// f.setMj(ywpzEntity.getMj());
		f.setGrjjl(ywpzEntity.getGrjjl());
		f.setMj(ywpzEntity.getMj());
		f.setFwje(ywpzEntity.getFwje());
		if (ywpzEntity.getGrjjl() < 1) {
			f.setJsbz("1");
		} else {
			f.setJsbz("0");
		}
		if (ywpzEntity.getFwje() > 0) {
			baseMapper.updatefwxx222(f);
		} else if (ywpzEntity.getMj() > 0) {
			baseMapper.updatefwxx(f);
		}

		// 获取单据编号
		String temp_str = "";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		temp_str = sdf.format(dt);
		String temp_str1 = "";
		Date dt1 = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
		temp_str1 = sdf1.format(dt1);
		String maxdjbh = baseMapper.queryByCount(ywpzEntity.getDjrq());
		String newdjbh = "";
		if ("".equals(maxdjbh) || maxdjbh == null) {
			newdjbh = "03" + temp_str1 + "0001";
		} else if (!"".equals(maxdjbh) && maxdjbh != null) {
			String aa = Integer.parseInt(maxdjbh) + 1 + "";
			DecimalFormat df = new DecimalFormat("0000");
			String result = df.format(Integer.parseInt(aa));
			newdjbh = "03" + temp_str1 + result;
		}
		ywpzEntity.setDjbh(newdjbh);
		ywpzEntity.setDjlx("03");
		ywpzEntity.setGzdbm("0001");
		ywpzEntity.setBankCode("00010001");
		ywpzEntity.setJsfs("31");
		ywpzEntity.setCzrq(temp_str);
		baseMapper.insertgr(ywpzEntity);
		baseMapper.insertgrmx(ywpzEntity);
		baseMapper.updatefwxxsfyj(ywpzEntity.getFwbm());

		return newdjbh;
	}

	@Override
	public List<FwxxEntity> selectfwzt(List<String> list) {
		List<FwxxEntity> listf = new ArrayList<FwxxEntity>();
		for (String f : list) {
			FwxxEntity aEntity = baseMapper.selectfwxxbyid(f);
			listf.add(aEntity);
		}
		return listf;
	}

	@Override
	public List<FwxxEntity> selectfwztbydhbm(ZhxxEntity zhxxEntity) {

		return baseMapper.selectfwxxbydhbm(zhxxEntity.getDhbm());
	}

	@Override
	public String selectdwbmbyxmmc(YwpzEntity ywpzEntity) {

		return baseMapper.selectdwbmbyxmmc(ywpzEntity);
	}

	@Override
	public String selectxmbmbyxmmc(YwpzEntity ywpzEntity) {

		return baseMapper.selectxmbmbyxmmc(ywpzEntity);
	}

	@Override
	public String selectdhbmbyxmmc(YwpzEntity ywpzEntity) {

		return baseMapper.selectdhbmbyxmmc(ywpzEntity);
	}

	@Override
	public String selectdwwwwbmbyxmmc(YwpzEntity ywpzEntity) {

		return baseMapper.selectdwwwwbmbyxmmc(ywpzEntity);
	}

	@Override
	public FwxxEntity selectfwbmbyxmmjdh(FwxxEntity fwxxEntity) {

		return baseMapper.selectfwbmbyxmmjdh(fwxxEntity);
	}

	@Override
	public List<ZhxxEntity> selectdhmcbyxmbm(YwpzEntity ywpzEntity) {

		return baseMapper.selectdhmcbyxmbm(ywpzEntity);
	}

	@Override
	public List<String> selectfwbylz(String id) {

		return baseMapper.selectfwbylz(id);
	}

	@Override
	public void insertywpldrjl(String id) {

		baseMapper.insertywpldrjl(id);
	}

	@Override
	public List<GryjpldrtempEntity> selectgryjpldr() {
		List<GryjpldrtempEntity> list = baseMapper.selectgryjpldr();
		// List<GryjpldrtempEntity> list=new ArrayList<GryjpldrtempEntity>();
		// GryjpldrtempEntity gr=new GryjpldrtempEntity();
		// gr.setDjrq("2016-05-01");
		// gr.setYzxm("严霜");
		// gr.setXxdz("恒大绿洲17-1-403");
		// gr.setXm("恒大绿洲区号*#。");
		// gr.setDh("17");
		// gr.setDyfw("1-");
		// list.add(gr);
		// GryjpldrtempEntity gr1=new GryjpldrtempEntity();
		// gr1.setDjrq("2016-05-01");
		// gr1.setYzxm("严霜");
		// gr1.setXxdz("恒大绿洲17-1-403");
		// gr1.setXm("恒大绿洲区号*#。");
		// gr1.setDh("17");
		// gr1.setDyfw("-2");
		// list.add(gr1);
		// GryjpldrtempEntity gr2=new GryjpldrtempEntity();
		// gr2.setDjrq("2016-05-01");
		// gr2.setYzxm("严霜");
		// gr2.setXxdz("恒大绿洲17-1-403");
		// gr2.setXm("恒大绿洲区号*#。");
		// gr2.setDh("17");
		// gr2.setDyfw("/-2");
		// list.add(gr2);
		// 1.通过项目名称xm这一列查询对应的xmbm
		for (GryjpldrtempEntity g : list) {
			String reg = "[^\u4e00-\u9fa5]";
			String eee = g.getXm().replaceAll(reg, "");// 只要中文
			String eee2 = eee;
			if (eee.contains("区")) {
				eee2 = eee.replace("区", "");
			}
			if (eee2.contains("号")) {
				eee2 = eee2.replace("号", "");
			}
			if (eee2.contains("商业楼")) {
				eee2 = eee2.replace("商业楼", "");
			}
			List<XmEntity> listx = baseMapper.selectxmxx(eee2);
			if (listx.isEmpty()) {
				baseMapper.updategrpldrxmsfcz(g);
			}
			if (!listx.isEmpty() && !"".equals(g.getDyfw()) && g.getDyfw() != null && !"".equals(g.getDh())
					&& g.getDh() != null) {
				// 2.通过xmbm dh(栋号名称)匹配对应的楼幢编码dhbm
				for (XmEntity x : listx) {
					ZhxxEntity zzz = new ZhxxEntity();
					zzz.setXmbm(x.getXmbm());
					zzz.setDhmc(g.getDh());
					List<ZhxxEntity> listd = baseMapper.selectdhbmbyxmdc(zzz);
					if (!listd.isEmpty()) {
						for (ZhxxEntity w : listd) {
							// 3.通过dhbm和dyfw字段查对应的mphm是否存在，存在表是查到对应的fwbm
							// 在这之前需要将房屋表里的门牌号-符号去掉然后和dr表里的dyfw里的-去掉然后模糊匹配。
							boolean status = g.getDyfw().contains("-");
							if (status) {
								// 去除中文
								Pattern pat = Pattern.compile(REGEX_CHINESE);
								Matcher mat = pat.matcher(g.getDyfw());
								String ss = mat.replaceAll("");
								String[] str = ss.split("-");
								String newstr1 = "";
								String dyfw = "";
								try {
									if (str[1].length() < 4) {
										String strr = "0" + str[1];
										newstr1 = strr.substring(0, 2) + "-" + strr.substring(2);
									} else if (str[1].length() > 3) {
										newstr1 = str[1].substring(0, 2) + "-" + str[1].substring(2);
									}
									dyfw = str[0] + "-" + newstr1;
								} catch (ArrayIndexOutOfBoundsException e) {

								}
								FwxxEntity f = new FwxxEntity();
								f.setDhbm(w.getDhbm());
								f.setMphm(dyfw);
								List<String> fwbms = baseMapper.selectfwbmbydmmph(f);
								if (!fwbms.isEmpty() && fwbms.size() == 1) {
									// 则表示匹配到对应的房屋了，修改gryjpldrtemp sfcz得状态为1
									g.setFwbm(fwbms.get(0));
									baseMapper.updategrpldrsfcz(g);
								}

							} else {
								FwxxEntity f = new FwxxEntity();
								f.setDhbm(w.getDhbm());
								f.setMphm(g.getDyfw());
								List<String> fwbms = baseMapper.selectfwbmbydmmph(f);
								if (!fwbms.isEmpty() && fwbms.size() == 1) {
									// 则表示匹配到对应的房屋了，修改gryjpldrtemp sfcz得状态为1
									g.setFwbm(fwbms.get(0));
									baseMapper.updategrpldrsfcz(g);
								}
							}
						}

					}
				}
			}

		}
		return list;
	}

	@Override
	public List<GryjpldrtempEntity> selectgryjpldryjfw() {

		return baseMapper.selectgryjpldryjfw();
	}

	@Override
	public ZhxxEntity selectdhdw(String id) {

		return baseMapper.selectdhdw(id);
	}

	@Override
	public void selectgryjpldr2() {
		List<GryjpldrtempEntity> listgr = baseMapper.selectgryjpl();
		for (GryjpldrtempEntity gr : listgr) {
			XmEntity x = baseMapper.selectxmbyxmbm(gr.getXm());
			if (isObjectNotEmpty(x) == true) {
				ZhxxEntity zz = new ZhxxEntity();
				zz.setXmbm(x.getXmbm());
				zz.setDhmc(gr.getDh());
				ZhxxEntity z = baseMapper.selectdhbmbyxm(zz);
				if (isObjectNotEmpty(z) == true) {
					FwxxEntity ff = new FwxxEntity();
					ff.setDhbm(z.getDhbm());
					ff.setMphm(gr.getDyfw());
					FwxxEntity f = baseMapper.selectfwbm2(ff);
					if (isObjectNotEmpty(f) == true) {
						GryjpldrtempEntity g = new GryjpldrtempEntity();
						g.setFwbm(f.getFwbm());
						g.setFwsfcz("1");
						g.setDjrq(gr.getDjrq());
						g.setYzxm(gr.getYzxm());
						g.setXxdz(gr.getXxdz());
						baseMapper.updategrplcopy(g);
					}
				}
			}
		}
	}

	public static Boolean isObjectNotEmpty(Object obj) {
		String str = ObjectUtils.toString(obj, "");
		return StringUtils.isNotBlank(str);
	}

	@Override
	public String insertGr2(YwpzEntity ywpzEntity) {
		// 获取单据编号
		String temp_str = "";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		temp_str = sdf.format(dt);

		String temp_str1 = "";
		Date dt1 = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
		temp_str1 = sdf1.format(dt1);
		String maxdjbh = baseMapper.queryByCount(ywpzEntity.getDjrq());
		String newdjbh = "";
		if ("".equals(maxdjbh) || maxdjbh == null) {
			newdjbh = "03" + temp_str1 + "0001";
		} else if (!"".equals(maxdjbh) && maxdjbh != null) {
			String aa = Integer.parseInt(maxdjbh) + 1 + "";
			DecimalFormat df = new DecimalFormat("0000");
			String result = df.format(Integer.parseInt(aa));
			newdjbh = "03" + temp_str1 + result;
		}
		ywpzEntity.setDjbh(newdjbh);
		ywpzEntity.setDjlx("03");
		ywpzEntity.setGzdbm("0001");
		ywpzEntity.setCzrq(temp_str);
		baseMapper.insertgr(ywpzEntity);
		baseMapper.insertgrmx(ywpzEntity);
		baseMapper.updatefwxxsfyj(ywpzEntity.getFwbm());
		return newdjbh;
	}

	@Override
	public void selectloudiaode() {
		List<GryjpldrtempEntity> list7562 = baseMapper.selectloudiaode7562();
		List<GryjpldrtempEntity> list7383 = baseMapper.selectloudiaode7383();
		for (GryjpldrtempEntity g3 : list7383) {
			for (GryjpldrtempEntity g5 : list7562) {
				if (g3.getXxdz().equals(g5.getXxdz())) {
					baseMapper.updategr7562(g5);
				}
			}
		}

	}

	@Override
	public List<YwpzEntity> CXFWSFCFJK() {
		List<YwpzEntity> yy = new ArrayList<YwpzEntity>();
		List<YwpzmxEntity> c = new ArrayList<YwpzmxEntity>();
		List<YwpzmxEntity> listl = baseMapper.selectlsj();
		List<YwpzmxEntity> listx = baseMapper.selectxsj();
		for (YwpzmxEntity l : listl) {
			for (YwpzmxEntity x : listx) {
				if (l.getFwbm().equals(x.getFwbm())) {
					c.add(x);
				}
			}
		}
		for (YwpzmxEntity y : c) {
			YwpzEntity y1 = baseMapper.selectfwcfj(y.getFwbm());
			baseMapper.insertcfjk(y1);
			// yy.add(y1);
		}

		return yy;
	}

	@Override
	public void FWYZKMDY() {
		List<HPzEntity> list = baseMapper.SELECTXMDYKM();
		for (HPzEntity p : list) {
			String kmmc = baseMapper.selectkkkk(p.getKm());
			p.setKmmc(kmmc);
			baseMapper.insertbeiyong2(p);
		}
	}

	@Override
	public void XGZPH(YwpzEntity ywpzEntity) {

		baseMapper.updatezph(ywpzEntity);
	}

	@Override
	public void updatefwyzkm() {
		List<FwxxEntity> list = baseMapper.selectfwkyzkm();
		for (FwxxEntity f : list) {
			FwxxEntity f2 = baseMapper.selectfwkfskm(f.getFwbm());
			f2.setFwbm(f.getFwbm());
			baseMapper.updatefwdeyzkm(f2);
		}
	}

	@Override
	public void updatedjrq(YwpzEntity ywpzEntity) {

		baseMapper.updatedjrq(ywpzEntity);
	}

	@Override
	public void updategryjxx(YwpzEntity ywpzEntity) {
		ywpzEntity.setKjqj(ywpzEntity.getDjrq().substring(0, 7));
		baseMapper.updatefwxxbjym(ywpzEntity);// 更新房屋信息
		baseMapper.updategrywpzmx(ywpzEntity);// 更新ywpzmx表bjje和je
		baseMapper.updategryjxx(ywpzEntity);// 更新ywpz
	}

	@Override
	public void checfwsfjq() {
		List<FwxxEntity> list = baseMapper.selectallfwxx();
		for (FwxxEntity f : list) {
			FwxxEntity f2 = baseMapper.selectfwxxbybm(f.getFwbm());
			if ("0".equals(f2.getSfyj())) {
				baseMapper.updatefwsfjq0(f2.getFwbm());// sfjq=0
			} else if ("1".equals(f2.getSfyj())) {
				String jsbz = f2.getJsbz();
				if ("0".equals(jsbz)) {// 按面积
					Double Yjje = f2.getMj() * f2.getGrjjl();
					Yjje = (double) Math.round(Yjje);
					f2.setYjje(Yjje);
				} else if ("1".equals(jsbz)) {// 按造价
					Double Yjje = 0.0;
					if (f2.getFwje() != 0 || f2.getFwje() != null) {
						Yjje = f2.getFwje() * f2.getGrjjl();
						Yjje = (double) Math.round(Yjje);
					}
					f2.setYjje(Yjje);
				}
				Double yingj = f2.getYjje();
				YwpzmxEntity mm = baseMapper.selectfwsfjq(f2.getFwbm());
				Double yjiao = 0.0;
				if (isObjectNotEmpty(mm) == false) {
					yjiao = 0.0;
				} else {
					yjiao = mm.getJe();
				}
				int val = yingj.compareTo(yjiao);
				if (val > 0) {
					baseMapper.updatefwsfjq0(f2.getFwbm());// sfjq=0
				} else if (val <= 0) {
					baseMapper.updatefwsfjq(f2.getFwbm());// sfjq=1
				}
			}

		}
	}

	@Override
	public void XTPLDRGRSCZS() {
		// 获取所有系统批量导入的个人预交业务数据
		List<YwpzEntity> list = baseMapper.selectxtpldr();
		for (YwpzEntity y : list) {
			// 通过单据编号查询每一户的预交明细
			YwpzmxEntity m = baseMapper.selectywpzmxbydj(y.getDjbh());
			Double oldje = y.getJe();// ywpz je
			Double oldbjje = m.getBjje();// ywpzmx bjje
			Double oldmxje = m.getJe();// ywpzmx je
			Double newje = (double) Math.round(y.getJe());
			// 查询这一户
			FwxxEntity f = baseMapper.selectfwxxbybm(m.getFwbm());
			f.setGrje(f.getGrje() - oldje + newje);
			f.setDqye(f.getDqye() - oldje + newje);
			// 修改这一户的
			baseMapper.updatefwxxgrdq(f);
			// 查询该户所在的楼栋
			ZhxxEntity z = baseMapper.selectzhxxbybm(m.getDhbm());
			z.setGryjje(z.getGryjje() - oldje + newje);
			z.setDqye(z.getDqye() - oldje + newje);
			// 修改所在楼栋的
			baseMapper.updatezhxxgrdq(z);
			// 修改ywpz表je
			y.setJe(newje);
			baseMapper.updateywpzje(y);
			// 修改ywpzmx bjje和je
			m.setBjje(newje);
			m.setJe(newje);
			baseMapper.updateywpzmxbjjeje(m);
		}
	}

	@Override
	public void FZHSMXSHUA() {
		// 1先刷单位缴款的
		List<YwpzEntity> listdw01 = baseMapper.selectdw01();
		for (YwpzEntity y : listdw01) {
			// ----------------------------------------------------------------
			List<YwpzEntity> yxqs = baseMapper.selectzyxqmc(y.getDjbh());
			List<YwpzEntity> yxms = baseMapper.selectzyxmmc(y.getDjbh());
			List<YwpzEntity> ydhs = baseMapper.selectzydhmc(y.getDjbh());
			String xq = "";
			String xm = "";
			String dh = "";
			for (YwpzEntity yxq : yxqs) {
				xq = xq + "," + yxq.getXqmc();
			}
			for (YwpzEntity yxm : yxms) {
				xm = xm + "," + yxm.getXmmc();
			}
			for (YwpzEntity ydh : ydhs) {
				dh = dh + "," + ydh.getDhmc();
			}

			// -----------------------------------------------
			List<YwpzEntity> y1s = baseMapper.selectdw01djxx(y.getDjbh());
			for (YwpzEntity y0 : y1s) {
				y0.setDwmc(y0.getDwmc() + xq + xm + dh);// 开发商名称+小区名称+项目名称+楼栋名称
			}
			if (y1s.size() > 1) {
				String xmbm = "";
				for (YwpzEntity yy : y1s) {
					xmbm = xmbm + yy.getXmbm() + ",";
				}
				if (!"".equals(y1s.get(0).getPzh()) && y1s.get(0).getPzh() != null) {
					y1s.get(0).setXmbm(xmbm);
					baseMapper.insertfzhsmxdw01(y1s.get(0));
				} else {
					y1s.get(0).setXmbm(xmbm);
					baseMapper.insertfzhsmx1dw01(y1s.get(0));
				}
			} else if (y1s.size() == 1) {
				if (!"".equals(y1s.get(0).getPzh()) && y1s.get(0).getPzh() != null) {
					baseMapper.insertfzhsmxdw01(y1s.get(0));
				} else {
					baseMapper.insertfzhsmx1dw01(y1s.get(0));
				}
			}

		}
		// --------------------------------------------------------------------
		// 2.再刷个人缴款的
		// -- 辅助核算明细刷个人缴存数据(用下面sql查，然后直接复制粘贴)
		// select DISTINCT
		// y.kjqj,y.djbh,y.djlx,y.djrq,z.xmbm,0,y.je,CONCAT(q.xqmc,'_',x.xmmc,'_',f.mphm,'_',f.xm),case
		// when (ISNULL(y.pzh)=1 || (LENGTH(trim(y.pzh))=0)) then null else
		// y.kjqj end,y.pzh from ywpz
		// y,ywpzmx m,zhxx z,fwxx f,xm x,xqxx q where y.djbh=m.djbh and
		// m.dhbm=z.dhbm and
		// m.fwbm=f.fwbm and z.xmbm=x.xmbm and x.xqbm=q.xqbm and y.djlx='03'
	}

	@Override
	public PageInfo<YwpzEntity> queryByPageFZHSMX(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		PageHelper.startPage(pageNum, pageSize);
//		if ("01".equals(ywpzEntity.getFzlb())) {
//			ywpzEntity.setDjlx2("辅助类别专用");
//		} else if ("02".equals(ywpzEntity.getFzlb())) {
//			ywpzEntity.setDjlx("10");
//		} else if ("03".equals(ywpzEntity.getFzlb())) {
//			ywpzEntity.setDjlx3("支取类别专业");
//		} else if ("04".equals(ywpzEntity.getFzlb())) {
//			ywpzEntity.setDjlx("13");
//		}

//		if (!"".equals(ywpzEntity.getFzkmlb()) && ywpzEntity.getFzkmlb() != null && "01".equals(ywpzEntity.getFzlb())) {
//			ywpzEntity.setDjlx2("");
			if ("D".equals(ywpzEntity.getFzkmlb())) {
				ywpzEntity.setDjlx("01");
				ywpzEntity.setZqlx("01");
			} else if ("Y".equals(ywpzEntity.getFzkmlb())) {
				ywpzEntity.setDjlx("03");
				ywpzEntity.setZqlx("03");
			}else{
//				ywpzEntity.setDjlx("");
			}
//		} else if (!"".equals(ywpzEntity.getFzkmlb()) && ywpzEntity.getFzkmlb() != null
//				&& "03".equals(ywpzEntity.getFzlb())) {
//			// ywpzEntity.setDjlx3("");
//			if ("SCBF".equals(ywpzEntity.getFzkmlb())) {
//
//				ywpzEntity.setZqlx("01");
//			} else if ("YEBF".equals(ywpzEntity.getFzkmlb())) {
//
//				ywpzEntity.setZqlx("03");
//			}
//		}

		List<YwpzEntity> ywpzEntitys = baseMapper.queryByPageFZHSMX(ywpzEntity);
		for (YwpzEntity y : ywpzEntitys) {
			if (!"".equals(y.getZqlx()) && y.getZqlx() != null && "首次拨付分摊".equals(y.getDjlx())) {
				if ("01".equals(y.getZqlx())) {
					y.setZqlx("首次分摊开发商缴款");
				} else {
					y.setZqlx("首次分摊业主缴款");
				}
				y.setDjlx(y.getZqlx());
			} else if (!"".equals(y.getZqlx()) && y.getZqlx() != null && "余额拨付分摊".equals(y.getDjlx())) {
				if ("01".equals(y.getZqlx())) {
					y.setZqlx("余额分摊开发商缴款");
				} else {
					y.setZqlx("余额分摊业主缴款");
				}
				y.setDjlx(y.getZqlx());
			}
		}
		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywpzEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<YwpzEntity> queryByPageFZHSYE(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {//如果选了某个项目来查，前台需要多传一个xmbm
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzEntity> ywpzEntitys = new ArrayList<YwpzEntity>();
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
		java.util.Date date = null;
		try {
			date = formatter.parse(ywpzEntity.getKjqj());
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} // Date格式
		Calendar calBegin = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calBegin.setTime(date);
		calBegin.add(Calendar.MONTH, -1);
		String datestr = formatter.format(calBegin.getTime());// String格式
		List<HashMap<String, String>> list = baseMapper.selectxmbm();// 所有项目
		List<YwpzEntity> listdw = baseMapper.QUERYDW(datestr);// 单位缴款(期初)
		List<YwpzEntity> listgr = baseMapper.QUERYGR(datestr);// 个人缴款(期初)
		List<YwpzEntity> listsy = baseMapper.QUERYSY(datestr);// 使用(期初)包括单位个人
		List<YwpzEntity> listtk = baseMapper.QUERYTK(datestr);// 退款(期初)个人
		List<YwpzEntity> listdwdy = baseMapper.QUERYDWDY(ywpzEntity.getKjqj());// 单位缴款(当月发生)
		List<YwpzEntity> listgrdy = baseMapper.QUERYGRDY(ywpzEntity.getKjqj());// 个人缴款(当月发生)
//		List<YwpzEntity> listsydy = baseMapper.QUERYSYDY(ywpzEntity.getKjqj());// 使用(当月发生)(2021以前支取分不清个人单位分别缴了多少，所以用这个查单位+个人一共的)
		List<YwpzEntity> listsydy2 = baseMapper.QUERYSYDY2(ywpzEntity.getKjqj());// 使用(当月发生)(2021-01以后可以查单位和个人分别缴了多少，所以用这个查)
		List<YwpzEntity> listtkdy = baseMapper.QUERYTKDY(ywpzEntity.getKjqj());// 退款(当月发生)
		for (HashMap<String, String> map : list) {
			String xmbm = "";
			String xmmc = "";
			if (ywpzEntity.getXmbm() != null && !"".equals(ywpzEntity.getXmbm())) {
				xmbm = ywpzEntity.getXmbm();// 项目编码
				xmmc = ywpzEntity.getXmmc();// 项目名称
			} else {
				xmbm = map.get("xmbm");// 项目编码
				xmmc = map.get("xmmc");// 项目名称
			}
			Double qcyedw = 0.0;//期初单位余额
			Double qcyegr = 0.0;//期初个人余额
			Double qcyesydw = 0.0;//期初支取单位余额
			Double qcyesygr = 0.0;//期初支取个人余额
			Double qcyetk = 0.0;//期初退款（个人）余额
			Double dwdydf = 0.0;//当月单位贷方发生
			Double grdydf = 0.0;//当月个人贷方发生
//			Double sydyjf = 0.0;
			Double sydydwjf = 0.0;//当月单位借方发生
			Double sydygrjf = 0.0;//当月个人借方发生
			Double tkdyjf = 0.0;
			if(!listdw.isEmpty()){
				for (YwpzEntity mapdw : listdw) {
					if (mapdw.getXmbm() != null) {
						if (xmbm.equals(mapdw.getXmbm())) {
							qcyedw += mapdw.getJe();
						}
					}
				}	
			}
			if(!listgr.isEmpty()){
				for (YwpzEntity mapgr : listgr) {
					if (mapgr.getXmbm() != null) {
						if (xmbm.equals(mapgr.getXmbm())) {
							qcyegr += mapgr.getJe();
						}
					}
				}
			}
			if(!listsy.isEmpty()){
				for (YwpzEntity mapsy : listsy) {
					if (mapsy.getXmbm() != null) {
						if (xmbm.equals(mapsy.getXmbm())) {
							qcyesydw += mapsy.getDwje();
							qcyesygr += mapsy.getGrje();
						}
					}
				}	
			}
			if(!listtk.isEmpty()){
				for (YwpzEntity maptk : listtk) {
					if (maptk.getXmbm() != null) {
						if (xmbm.equals(maptk.getXmbm())) {
							qcyetk += maptk.getJe();
						}
					}
				}	
			}
			
			
			if(!listdwdy.isEmpty()){
				for (YwpzEntity mapdwdy : listdwdy) {
					if (mapdwdy.getXmbm() != null) {
						if (xmbm.equals(mapdwdy.getXmbm())) {
							dwdydf += mapdwdy.getJe();// 每个项目当月单位发生额
						}
					}
				}	
			}
			if(!listgrdy.isEmpty()){
				for (YwpzEntity mapgrdy : listgrdy) {
					if (mapgrdy.getXmbm() != null) {
						if (xmbm.equals(mapgrdy.getXmbm())) {
							grdydf += mapgrdy.getJe();// 每个项目当月个人发生额
						}
					}
				}	
			}
//			if(!listsydy.isEmpty()){
//				for (YwpzEntity mapsydy : listsydy) {
//					if (mapsydy.getXmbm() != null) {
//						if (xmbm.equals(mapsydy.getXmbm())) {
//							sydyjf += mapsydy.getJe();// 每个项目当月使用发生额
//						}
//					}
//				}	
//			}
			if(!listsydy2.isEmpty()){
				for (YwpzEntity mapsydy2 : listsydy2) {
					if (mapsydy2.getXmbm() != null) {
						if (xmbm.equals(mapsydy2.getXmbm())) {
							sydydwjf += mapsydy2.getDwje();// 每个项目当月使用(单位)发生额
							sydygrjf += mapsydy2.getGrje();//每个项目当月使用(个人)发生额
						}
					}
				}	
			}
			if(!listtkdy.isEmpty()){
				for (YwpzEntity maptkdy : listtkdy) {
					if (maptkdy.getXmbm() != null) {
						if (xmbm.equals(maptkdy.getXmbm())) {
							tkdyjf += maptkdy.getJe();// 每个项目当月退款发生额
						}
					}
				}
			}
			YwpzEntity y = new YwpzEntity();
			y.setXmmc(xmmc);
			y.setXmbm(xmbm);
			Double qcye =0.0;
			Double qmye = 0.0;
				if ("D".equals(ywpzEntity.getFzkmlb())) {// 查单位发生额
					qcye=qcyedw-qcyesydw;
					qmye=qcye+dwdydf-sydydwjf;
					y.setQcye(qcye);
					y.setDffse(dwdydf);
					y.setJffse(sydydwjf);
					y.setQmye(qmye);
				} else if ("Y".equals(ywpzEntity.getFzkmlb())) {// 查业主发生额
					qcye=qcyegr-qcyesygr-qcyetk;
					qmye=qcye+grdydf-sydygrjf-tkdyjf;
					y.setQcye(qcye);
					y.setDffse(grdydf);
					y.setJffse(sydygrjf+tkdyjf);
					y.setQmye(qmye);
				} else {// 查单位和业主
					qcye =qcyedw + qcyegr - qcyesydw-qcyesygr - qcyetk;// 每个项目的期初
					qmye=qcye+dwdydf+grdydf -sydydwjf-sydygrjf-tkdyjf;
					y.setQcye(qcye);
					y.setDffse(dwdydf+grdydf);
					y.setJffse(sydydwjf+sydygrjf+tkdyjf);
					y.setQmye(qmye);
				}
			ywpzEntitys.add(y);
			if (ywpzEntity.getXmbm() != null && !"".equals(ywpzEntity.getXmbm())) {
				break;
			}
		}
		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywpzEntitys);
		return pageInfo;
	}

	@Override
	public void wcnd() {
		List<String> listyw = new ArrayList<String>();
		List<String> listmx = new ArrayList<String>();
		listyw = baseMapper.listywb();
		listmx = baseMapper.listfzmxb();

		for (String yw : listyw) {
			if (!listmx.contains(yw)) {
				System.out.print(yw);
			}
		}

	}

	@Override
	public void djbh() {
		YwpzEntity ywpzEntity = new YwpzEntity();
		ywpzEntity.setBeginrq("2020-01-01");
		ywpzEntity.setEndrq("2020-01-31");
		List<YwpzEntity> ywpzEntitys = baseMapper.queryByPage(ywpzEntity);
		List<String> list = new ArrayList<String>();
		for (YwpzEntity y : ywpzEntitys) {
			list.add(y.getDjbh());
		}
		// set中存放的是不可重复的元素
		HashSet<String> set = new HashSet<String>();
		// 这里存放的是所有重复的元素，如果你只想知道是哪几个数字重复了，不需要知道具体重复了几次，可以用HashSet
		List<String> repeatElements = new ArrayList<String>();

		for (int i = 0; i < list.size(); i++) {
			String value = list.get(i);

			if (set.contains(value)) {
				// 重复元素
				repeatElements.add(value);
			} else {
				set.add(value);
			}
		}

		// 输出重复的元素
		for (int i = 0; i < repeatElements.size(); i++) {
			System.out.println(repeatElements.get(i));
		}

	}

	@Override
	public void FZHSMXSHUA2() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
		java.util.Date dBegin = null;
		try {
			dBegin = sdf.parse("2005-01");
		} catch (ParseException e1) {
			e1.printStackTrace();
		}
		java.util.Date dEnd = null;
		try {
			dEnd = sdf.parse("2021-01");
		} catch (ParseException e) {
			e.printStackTrace();
		}
		List<String> datas = findDates(dBegin, dEnd);
		for (String kjqj : datas) {
			List<YwpzEntity> list = baseMapper.selectqqqq(kjqj);
			if (!list.isEmpty()) {
				baseMapper.insertqqqq(list);
			}

		}

	}

	public List<String> findDates(java.util.Date dBegin, java.util.Date dEnd) {
		List<String> lDate = new ArrayList<String>();
		SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM");
		lDate.add(sd.format(dBegin));
		Calendar calBegin = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calBegin.setTime(dBegin);
		Calendar calEnd = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calEnd.setTime(dEnd);
		// 测试此日期是否在指定日期之后
		while (dEnd.after(calBegin.getTime())) {
			// 根据日历的规则，为给定的日历字段添加或减去指定的时间量
			calBegin.add(Calendar.MONTH, 1);
			lDate.add(sd.format(calBegin.getTime()));
		}
		return lDate;
	}

	@Override
	public void FZHSMXSHUA22() {
		List<YwpzEntity> list = baseMapper.selectqqqqww();
		baseMapper.insertqqqqww(list);
	}

	@Override
	public void yyyy() {
		List<YwpzEntity> list = baseMapper.selectghandcw();
		for (YwpzEntity y : list) {
			List<YwpzEntity> list1 = baseMapper.selectypz(y);
			List<Double> list2 = baseMapper.selectcpz(y);
			boolean a;
			// for(int i=0;i<list1.size();i++){
			// a=list2.contains(list1.get(i).getJe());
			// if(a==false){
			// baseMapper.inserttemp(list1.get(i));
			// }
			// }

		}
	}

}