package io.renren.modules.app.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import cn.hutool.core.bean.BeanUtil;
import io.renren.common.utils.R;
import io.renren.modules.app.dao.HPzDao;
import io.renren.modules.app.entity.HKmEntity;
import io.renren.modules.app.entity.HKmyeEntity;
import io.renren.modules.app.entity.HPzEntity;
import io.renren.modules.app.entity.HYtlxbEntity;
import io.renren.modules.app.entity.HZyEntity;
import io.renren.modules.app.entity.XtcsEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.service.HPzService;
import io.renren.modules.app.utils.MoneyUtil;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@Service("hPzService")
public class HPzServiceImpl extends ServiceImpl<HPzDao, HPzEntity> implements HPzService {

	/**
	 * 分页模糊查询
	 * 
	 * @param pageNum
	 * @param pageSize
	 * @param hPzEntity
	 * @return
	 */
	@Override
	public PageInfo<YwpzEntity> queryByPageDWPZ(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzEntity> ywHPzEntities = baseMapper.queryByPageDWPZ(ywpzEntity);
		for (YwpzEntity y : ywHPzEntities) {
			String djrq = y.getDjrq();
			String gdrq = "2020-12-31";// 切换新旧科目的临界日期
			int res = djrq.compareTo(gdrq);
			if (res <= 0) {// 使用市局2021以前的科目
				y.setZtbm("0002");
				// 1.贷方科目：新科目不按单位个人缴分，按交存分。所以每一笔单据业务的开发商科目代码都是：201001，开发商科目名称都是：“商品住宅维修资金-交存”
				y.setKfskmdm("201001");
				y.setKfskmdmmc("商品住宅维修资金-交存");
				// 2.借方科目
				// 获取该开发商预交的银行科目代码
				HKmEntity hKmEntitya = baseMapper.selectbymc2(y.getYhmc());
				// 设置该单据的银行核算科目
				y.setYhkmdm(hKmEntitya.getKm() + "001");
			} else if (res > 0) {// 使用2020以后科目
				y.setZtbm("0003");
				// 1.贷方科目：新科目不按单位个人缴分，按交存分。所以每一笔单据业务的开发商科目代码都是：201001，开发商科目名称都是：“商品住宅维修资金-交存”
				y.setKfskmdm("400101");
				y.setKfskmdmmc("交存收入-已处理交存收入");
				// 2.借方科目
				// 获取该开发商预交的银行科目代码
				HKmEntity hKmEntitya = baseMapper.selectbymc22(y.getYhmc());
				// 设置该单据的银行核算科目
				y.setYhkmdm(hKmEntitya.getKm() + "01");
			}
			// 为后面贷方摘要地址拼接准备而返回的值
			List<YwpzEntity> yxqs = baseMapper.selectzyxqmc(y.getDjbh());
			List<YwpzEntity> yxms = baseMapper.selectzyxmmc(y.getDjbh());
			List<YwpzEntity> ydhs = baseMapper.selectzydhmc(y.getDjbh());
			String xq = "";
			String xm = "";
			String dh = "";
			for (YwpzEntity yxq : yxqs) {
				xq = xq + "," + yxq.getXqmc();
			}
			for (YwpzEntity yxm : yxms) {
				xm = xm + "," + yxm.getXmmc();
			}
			for (YwpzEntity ydh : ydhs) {
				dh = dh + "," + ydh.getDhmc();
			}
			y.setDfzytszd(xq + xm + dh);
		}
		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywHPzEntities);
		return pageInfo;
	}

	@Override
	public R insertDWPZSC(YwpzEntity ywpzEntity) {
		// 3.判断是否合并分录
		if (0 == ywpzEntity.getSfhbfl()) {
			// 不合并分录
			if ("0002".equals(ywpzEntity.getZtbm())) {// 新科目生成规则
				// 先借后贷，借方每条生成，按业务日期升序排序，贷方每条生成，按科目升序排序。
				// 2.生成凭证号(取当前会计期间最大凭证号+1)：
				int pzh = 1;
				// ------------------------------------
				// 处理凭证号插空问题
				List<String> lpzhgs = baseMapper.selectkjqjpzhgs(ywpzEntity.getKjqj());// 查此会计期间有多少条pzh
				String maxpzhck = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());// 查此会计期间最大pzh
				if (lpzhgs.isEmpty()) {
					String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
					if ("".equals(maxpzh) || maxpzh == null) {
						pzh = 1;
					} else if (!"".equals(maxpzh) || maxpzh != null) {
						String aa = Integer.parseInt(maxpzh) + 1 + "";
						DecimalFormat df = new DecimalFormat("0");
						String result = df.format(Integer.parseInt(aa));
						pzh = Integer.parseInt(result);
					}
				} else {
					int maxPZH = Integer.parseInt(maxpzhck);
					if (maxPZH == lpzhgs.size()) {// 如果相等则表示该会计期间pzh没有断号，则按pzh+1规则来生成pzh
						String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
						if ("".equals(maxpzh) || maxpzh == null) {
							pzh = 1;
						} else if (!"".equals(maxpzh) || maxpzh != null) {
							String aa = Integer.parseInt(maxpzh) + 1 + "";
							DecimalFormat df = new DecimalFormat("0");
							String result = df.format(Integer.parseInt(aa));
							pzh = Integer.parseInt(result);
						}
					} else {// 不相等则表示存在断号，需先补漏，全部补完了不断号之后再按pzh+1规则来生成pzh
						for (int i = 1; i <= maxPZH; i++) {
							if (lpzhgs.contains(i + "")) {

							} else {
								pzh = i;
								break;
							}
						}
					}
				}

				// ------------------------------------

				Collections.sort(ywpzEntity.getHPzEntities(), new Comparator<HPzEntity>() {// 按照单据日期升序排序
					@Override
					public int compare(HPzEntity o1, HPzEntity o2) {
						return o1.getDjrq().compareTo(o2.getDjrq());
					}
				});
				// 1.遍历每一个勾选的业务单据
				int flxh = 1;
				for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
					// a.先生成借方凭证
					HPzEntity hPzEntityjf = new HPzEntity();
					hPzEntityjf.setGzdbm("0001");
					hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf.setPzh(pzh);
					hPzEntityjf.setFlxh(flxh);
					// ------系统日期
					String temp_strx = "";
					Date dtx = new Date();
					SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
					temp_strx = sdfx.format(dtx);
					// -----
					if ("1".equals(ywpzEntity.getSfsxtpl())) {
						hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
					} else {
						hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(i).getDjrq());
					}
					hPzEntityjf.setFjzs(0);
					hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getDwmc());
					// -----
					String maxzybm = baseMapper.selectmaxzybm();
					String newzybm = "";
					if ("".equals(maxzybm) || maxzybm == null) {
						newzybm = "0001";
					} else if (!"".equals(maxzybm) && maxzybm != null) {
						String aa = Integer.parseInt(maxzybm) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm = result;
					}
					HZyEntity zy = new HZyEntity();
					zy.setZybm(newzybm);
					zy.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getDwmc());
					zy.setZtbm("0002");
					baseMapper.insertzy(zy);
					// -------
					hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(i).getYhkmdm());
					hPzEntityjf.setJfje(ywpzEntity.getHPzEntities().get(i).getJe());
					hPzEntityjf.setDfje(0.0);
					hPzEntityjf.setSfsh("0");
					hPzEntityjf.setSfjz("0");
					hPzEntityjf.setLrfs("1");
					hPzEntityjf.setYwlx("01");
					hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(i).getZph());
					hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str = "";
					Date dt = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str = sdf.format(dt);
					hPzEntityjf.setZdsj(temp_str);
					hPzEntityjf.setZtbm("0002");
					hPzEntityjf.setPztype("记账");
					hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
					hPzEntityjf.setJzsj(temp_str);
					baseMapper.inserthpzjf(hPzEntityjf);
					hPzEntityjf.setDjbh(ywpzEntity.getHPzEntities().get(i).getDjbh());
					// 改单位预交单据生成凭证之后将pzh记录在ywpz该pzh字段单据中
					baseMapper.updateywpzpzh(hPzEntityjf);
					flxh = flxh + 1;

					// 单位凭证生成的时候，将辅助核算明细中该单据的pzh和cwkjqj刷进去
					baseMapper.updatefzhsmxdw(hPzEntityjf);
				}

				for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
					// b.再生成开发商贷方凭证
					HPzEntity l = new HPzEntity();
					l.setKjqj(ywpzEntity.getKjqj());
					l.setPzh(pzh);
					flxh = baseMapper.selectmaxflxh(l);// 获取当前会计期间当前凭证号的最大flxh+1的值
					HPzEntity hPzEntityjf = new HPzEntity();
					hPzEntityjf.setGzdbm("0001");
					hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf.setPzh(pzh);
					hPzEntityjf.setFlxh(flxh);
					// ------系统日期
					String temp_strx = "";
					Date dtx = new Date();
					SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
					temp_strx = sdfx.format(dtx);
					// -----
					if ("1".equals(ywpzEntity.getSfsxtpl())) {
						hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
					} else {
						hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(i).getDjrq());
					}
					hPzEntityjf.setFjzs(0);
					hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getDwmc()
							+ ywpzEntity.getHPzEntities().get(i).getDfzytszd());
					// -----
					String maxzybm = baseMapper.selectmaxzybm();
					String newzybm = "";
					if ("".equals(maxzybm) || maxzybm == null) {
						newzybm = "0001";
					} else if (!"".equals(maxzybm) && maxzybm != null) {
						String aa = Integer.parseInt(maxzybm) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm = result;
					}
					HZyEntity zy = new HZyEntity();
					zy.setZybm(newzybm);
					zy.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getDwmc()
							+ ywpzEntity.getHPzEntities().get(i).getDfzytszd());
					zy.setZtbm("0002");
					baseMapper.insertzy(zy);
					// -----
					hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(i).getKfskmdm());
					hPzEntityjf.setJfje(0.0);
					hPzEntityjf.setDfje(ywpzEntity.getHPzEntities().get(i).getJe());
					hPzEntityjf.setSfsh("0");
					hPzEntityjf.setSfjz("0");
					hPzEntityjf.setLrfs("1");
					String temp_str1 = "";
					Date dt1 = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str1 = sdf1.format(dt1);
					hPzEntityjf.setJzsj(temp_str1);
					hPzEntityjf.setYwlx(ywpzEntity.getHPzEntities().get(i).getJsfs());
					hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(i).getZph());
					hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str = "";
					Date dt = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str = sdf.format(dt);
					hPzEntityjf.setZdsj(temp_str);
					hPzEntityjf.setZtbm("0002");
					hPzEntityjf.setPztype("记账");
					hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
					baseMapper.inserthpzjf(hPzEntityjf);

				}

			} else if ("0003".equals(ywpzEntity.getZtbm())) {// 旧科目生成规则
				// 先借后贷，借方每条生成，按业务日期升序排序，贷方每条生成，按科目升序排序。
				// 2.生成凭证号(取当前会计期间最大凭证号+1)：
				int pzh = 1;
				// ------------------------------------
				// 处理凭证号插空问题
				List<String> lpzhgs = baseMapper.selectkjqjpzhgs(ywpzEntity.getKjqj());// 查此会计期间有多少条pzh
				String maxpzhck = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());// 查此会计期间最大pzh
				if (lpzhgs.isEmpty()) {
					String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
					if ("".equals(maxpzh) || maxpzh == null) {
						pzh = 1;
					} else if (!"".equals(maxpzh) || maxpzh != null) {
						String aa = Integer.parseInt(maxpzh) + 1 + "";
						DecimalFormat df = new DecimalFormat("0");
						String result = df.format(Integer.parseInt(aa));
						pzh = Integer.parseInt(result);
					}
				} else {
					int maxPZH = Integer.parseInt(maxpzhck);
					if (maxPZH == lpzhgs.size()) {// 如果相等则表示该会计期间pzh没有断号，则按pzh+1规则来生成pzh
						String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
						if ("".equals(maxpzh) || maxpzh == null) {
							pzh = 1;
						} else if (!"".equals(maxpzh) || maxpzh != null) {
							String aa = Integer.parseInt(maxpzh) + 1 + "";
							DecimalFormat df = new DecimalFormat("0");
							String result = df.format(Integer.parseInt(aa));
							pzh = Integer.parseInt(result);
						}
					} else {// 不相等则表示存在断号，需先补漏，全部补完了不断号之后再按pzh+1规则来生成pzh
						for (int i = 1; i <= maxPZH; i++) {
							if (lpzhgs.contains(i + "")) {

							} else {
								pzh = i;
								break;
							}
						}
					}
				}

				// ------------------------------------

				Collections.sort(ywpzEntity.getHPzEntities(), new Comparator<HPzEntity>() {// 按照单据日期升序排序
					@Override
					public int compare(HPzEntity o1, HPzEntity o2) {
						return o1.getDjrq().compareTo(o2.getDjrq());
					}
				});
				// 1.遍历每一个勾选的业务单据
				int flxh = 1;
				for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
					// a.先生成借方凭证
					HPzEntity hPzEntityjf = new HPzEntity();
					hPzEntityjf.setGzdbm("0001");
					hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf.setPzh(pzh);
					hPzEntityjf.setFlxh(flxh);
					// ------系统日期
					String temp_strx = "";
					Date dtx = new Date();
					SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
					temp_strx = sdfx.format(dtx);
					// -----
					if ("1".equals(ywpzEntity.getSfsxtpl())) {
						hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
					} else {
						hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(i).getDjrq());
					}
					hPzEntityjf.setFjzs(0);
					hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getDwmc());
					// -----
					String maxzybm = baseMapper.selectmaxzybm();
					String newzybm = "";
					if ("".equals(maxzybm) || maxzybm == null) {
						newzybm = "0001";
					} else if (!"".equals(maxzybm) && maxzybm != null) {
						String aa = Integer.parseInt(maxzybm) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm = result;
					}
					HZyEntity zy = new HZyEntity();
					zy.setZybm(newzybm);
					zy.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getDwmc());
					zy.setZtbm("0003");
					baseMapper.insertzy(zy);
					// -------
					hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(i).getYhkmdm());
					hPzEntityjf.setJfje(ywpzEntity.getHPzEntities().get(i).getJe());
					hPzEntityjf.setDfje(0.0);
					hPzEntityjf.setSfsh("0");
					hPzEntityjf.setSfjz("0");
					hPzEntityjf.setLrfs("1");
					hPzEntityjf.setYwlx("01");
					hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(i).getZph());
					hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str = "";
					Date dt = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str = sdf.format(dt);
					hPzEntityjf.setZdsj(temp_str);
					hPzEntityjf.setZtbm("0003");
					hPzEntityjf.setPztype("记账");
					hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
					hPzEntityjf.setJzsj(temp_str);
					baseMapper.inserthpzjf(hPzEntityjf);
					hPzEntityjf.setDjbh(ywpzEntity.getHPzEntities().get(i).getDjbh());
					// 改单位预交单据生成凭证之后将pzh记录在ywpz该pzh字段单据中
					baseMapper.updateywpzpzh(hPzEntityjf);
					flxh = flxh + 1;

					// 单位凭证生成的时候，将辅助核算明细中该单据的pzh和cwkjqj刷进去
					baseMapper.updatefzhsmxdw(hPzEntityjf);
				}

				for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
					// b.再生成开发商贷方凭证
					HPzEntity l = new HPzEntity();
					l.setKjqj(ywpzEntity.getKjqj());
					l.setPzh(pzh);
					flxh = baseMapper.selectmaxflxh(l);// 获取当前会计期间当前凭证号的最大flxh+1的值
					HPzEntity hPzEntityjf = new HPzEntity();
					hPzEntityjf.setGzdbm("0001");
					hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf.setPzh(pzh);
					hPzEntityjf.setFlxh(flxh);
					// ------系统日期
					String temp_strx = "";
					Date dtx = new Date();
					SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
					temp_strx = sdfx.format(dtx);
					// -----
					if ("1".equals(ywpzEntity.getSfsxtpl())) {
						hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
					} else {
						hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(i).getDjrq());
					}
					hPzEntityjf.setFjzs(0);
					hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getDwmc()
							+ ywpzEntity.getHPzEntities().get(i).getDfzytszd());
					// -----
					String maxzybm = baseMapper.selectmaxzybm();
					String newzybm = "";
					if ("".equals(maxzybm) || maxzybm == null) {
						newzybm = "0001";
					} else if (!"".equals(maxzybm) && maxzybm != null) {
						String aa = Integer.parseInt(maxzybm) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm = result;
					}
					HZyEntity zy = new HZyEntity();
					zy.setZybm(newzybm);
					zy.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getDwmc()
							+ ywpzEntity.getHPzEntities().get(i).getDfzytszd());
					zy.setZtbm("0003");
					baseMapper.insertzy(zy);
					// -----
					hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(i).getKfskmdm());
					hPzEntityjf.setJfje(0.0);
					hPzEntityjf.setDfje(ywpzEntity.getHPzEntities().get(i).getJe());
					hPzEntityjf.setSfsh("0");
					hPzEntityjf.setSfjz("0");
					hPzEntityjf.setLrfs("1");
					String temp_str1 = "";
					Date dt1 = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str1 = sdf1.format(dt1);
					hPzEntityjf.setJzsj(temp_str1);
					hPzEntityjf.setYwlx(ywpzEntity.getHPzEntities().get(i).getJsfs());
					hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(i).getZph());
					hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str = "";
					Date dt = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str = sdf.format(dt);
					hPzEntityjf.setZdsj(temp_str);
					hPzEntityjf.setZtbm("0003");
					hPzEntityjf.setPztype("记账");
					hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
					baseMapper.inserthpzjf(hPzEntityjf);

				}
			}

		} else if (1 == ywpzEntity.getSfhbfl()) {
			// 合并分录(先判断多个单据是否是同一科目下的，如果是，只生成一条贷方凭证，若果不是，也要生成每条贷方凭证，借方生成多条凭证)
			double sum = 0.0;
			for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
				sum = sum + ywpzEntity.getHPzEntities().get(i).getJe();
			}
			if ("0002".equals(ywpzEntity.getZtbm())) {// 2019新科目生成规则
				// 2.生成凭证号(取当前会计期间最大凭证号+1)：
				int pzh = 0;
				// ------------------------------------
				// 处理凭证号插空问题
				List<String> lpzhgs = baseMapper.selectkjqjpzhgs(ywpzEntity.getKjqj());// 查此会计期间有多少条pzh
				String maxpzhck = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());// 查此会计期间最大pzh
				if (lpzhgs.isEmpty()) {
					String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
					if ("".equals(maxpzh) || maxpzh == null) {
						pzh = 1;
					} else if (!"".equals(maxpzh) || maxpzh != null) {
						String aa = Integer.parseInt(maxpzh) + 1 + "";
						DecimalFormat df = new DecimalFormat("0");
						String result = df.format(Integer.parseInt(aa));
						pzh = Integer.parseInt(result);
					}
				} else {
					int maxPZH = Integer.parseInt(maxpzhck);
					if (maxPZH == lpzhgs.size()) {// 如果相等则表示该会计期间pzh没有断号，则按pzh+1规则来生成pzh
						String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
						if ("".equals(maxpzh) || maxpzh == null) {
							pzh = 1;
						} else if (!"".equals(maxpzh) || maxpzh != null) {
							String aa = Integer.parseInt(maxpzh) + 1 + "";
							DecimalFormat df = new DecimalFormat("0");
							String result = df.format(Integer.parseInt(aa));
							pzh = Integer.parseInt(result);
						}
					} else {// 不相等则表示存在断号，需先补漏，全部补完了不断号之后再按pzh+1规则来生成pzh
						for (int i = 1; i <= maxPZH; i++) {
							if (lpzhgs.contains(i + "")) {

							} else {
								pzh = i;
								break;
							}
						}
					}
				}
				// ------------------------------------
				int flxh = 1;
				Collections.sort(ywpzEntity.getHPzEntities(), new Comparator<HPzEntity>() {// 按照单据日期升序排序
					@Override
					public int compare(HPzEntity o1, HPzEntity o2) {
						return o1.getDjrq().compareTo(o2.getDjrq());
					}
				});
				for (int j = 0; j < ywpzEntity.getHPzEntities().size(); j++) {
					// 先生成借方凭证
					HPzEntity hPzEntityjf2 = new HPzEntity();
					hPzEntityjf2.setGzdbm("0001");
					hPzEntityjf2.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf2.setPzh(pzh);
					hPzEntityjf2.setFlxh(flxh);
					// ------系统日期
					String temp_strx = "";
					Date dtx = new Date();
					SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
					temp_strx = sdfx.format(dtx);
					// -----
					if ("1".equals(ywpzEntity.getSfsxtpl())) {
						hPzEntityjf2.setPzrq(ywpzEntity.getMaxywrq());
					} else {
						hPzEntityjf2.setPzrq(ywpzEntity.getHPzEntities().get(j).getDjrq());
					}
					// hPzEntityjf2.setPzrq(ywpzEntity.getHPzEntities().get(j).getDjrq());
					hPzEntityjf2.setFjzs(0);
					hPzEntityjf2.setZymc(ywpzEntity.getHPzEntities().get(j).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(j).getDwmc());
					// -----
					String maxzybm1 = baseMapper.selectmaxzybm();
					String newzybm1 = "";
					if ("".equals(maxzybm1) || maxzybm1 == null) {
						newzybm1 = "0001";
					} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
						String aa = Integer.parseInt(maxzybm1) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm1 = result;
					}
					HZyEntity zy1 = new HZyEntity();
					zy1.setZybm(newzybm1);
					zy1.setZymc(ywpzEntity.getHPzEntities().get(j).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(j).getDwmc());
					zy1.setZtbm("0002");
					baseMapper.insertzy(zy1);
					// ----
					hPzEntityjf2.setKm(ywpzEntity.getHPzEntities().get(j).getYhkmdm());
					hPzEntityjf2.setJfje(ywpzEntity.getHPzEntities().get(j).getJe());
					hPzEntityjf2.setDfje(0.0);
					hPzEntityjf2.setSfsh("0");
					hPzEntityjf2.setSfjz("0");
					hPzEntityjf2.setLrfs("1");
					hPzEntityjf2.setYwlx("01");

					hPzEntityjf2.setYwbh(ywpzEntity.getHPzEntities().get(j).getZph());
					hPzEntityjf2.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str1 = "";
					Date dt1 = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str1 = sdf1.format(dt1);
					hPzEntityjf2.setZdsj(temp_str1);
					hPzEntityjf2.setJzsj(temp_str1);
					hPzEntityjf2.setZtbm("0002");
					hPzEntityjf2.setPztype("记账");
					hPzEntityjf2.setZdrmc(ywpzEntity.getZdrmc());
					baseMapper.inserthpzjf(hPzEntityjf2);
					hPzEntityjf2.setDjbh(ywpzEntity.getHPzEntities().get(j).getDjbh());
					// 改单据生成凭证之后将pzh记录在ywpz该pzh字段单据中
					baseMapper.updateywpzpzh(hPzEntityjf2);
					flxh = flxh + 1;

					//
					// 单位凭证生成的时候，将辅助核算明细中该单据的pzh和cwkjqj刷进去
					baseMapper.updatefzhsmxdw(hPzEntityjf2);
				}

				// -------------
				// List<List<HPzEntity>> resultwa =
				// getDuplicateElements(ywpzEntity.getHPzEntities());
				// 开发商科目都是交存，只生产一条
				HPzEntity l = new HPzEntity();
				l.setKjqj(ywpzEntity.getKjqj());
				l.setPzh(pzh);
				flxh = baseMapper.selectmaxflxh(l);// 获取当前会计期间当前凭证号的最大flxh+1的值
				// b.再生成开发商贷方凭证
				double sumq = 0.0;
				for (HPzEntity p : ywpzEntity.getHPzEntities()) {
					sumq = sumq + p.getJe();
				}
				HPzEntity hPzEntityjf = new HPzEntity();
				hPzEntityjf.setGzdbm("0001");
				hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
				hPzEntityjf.setPzh(pzh);
				hPzEntityjf.setFlxh(flxh);
				// ------系统日期
				String temp_strx = "";
				Date dtx = new Date();
				SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
				temp_strx = sdfx.format(dtx);
				// -----
				if ("1".equals(ywpzEntity.getSfsxtpl())) {
					hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
				} else {
					hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(0).getDjrq());
				}
				// hPzEntityjf.setPzrq(resultwa.get(x).get(0).getDjrq());
				hPzEntityjf.setFjzs(0);
				hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(0).getBillname() + "_"
						+ ywpzEntity.getHPzEntities().get(0).getDwmc()
						+ ywpzEntity.getHPzEntities().get(0).getDfzytszd() + "等");
				// -----
				String maxzybm = baseMapper.selectmaxzybm();
				String newzybm = "";
				if ("".equals(maxzybm) || maxzybm == null) {
					newzybm = "0001";
				} else if (!"".equals(maxzybm) && maxzybm != null) {
					String aa = Integer.parseInt(maxzybm) + 1 + "";
					DecimalFormat df = new DecimalFormat("0000");
					String result = df.format(Integer.parseInt(aa));
					newzybm = result;
				}
				HZyEntity zy = new HZyEntity();
				zy.setZybm(newzybm);
				zy.setZymc(ywpzEntity.getHPzEntities().get(0).getBillname() + "_"
						+ ywpzEntity.getHPzEntities().get(0).getDwmc()
						+ ywpzEntity.getHPzEntities().get(0).getDfzytszd() + "等");
				zy.setZtbm("0002");
				baseMapper.insertzy(zy);
				// -----
				hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(0).getKfskmdm());
				hPzEntityjf.setJfje(0.0);
				hPzEntityjf.setDfje(sumq);
				hPzEntityjf.setSfsh("0");
				hPzEntityjf.setSfjz("0");
				hPzEntityjf.setLrfs("1");
				hPzEntityjf.setYwlx(ywpzEntity.getHPzEntities().get(0).getJsfs());
				hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(0).getZph());
				hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
				String temp_str = "";
				Date dt = new Date();
				// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				temp_str = sdf.format(dt);
				hPzEntityjf.setZdsj(temp_str);
				hPzEntityjf.setZtbm("0002");
				hPzEntityjf.setPztype("记账");
				hPzEntityjf.setJzsj(temp_str);
				hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
				baseMapper.inserthpzjf(hPzEntityjf);

			} else if ("0003".equals(ywpzEntity.getZtbm())) {// 2019以前旧科目生成规则
				// 2.生成凭证号(取当前会计期间最大凭证号+1)：
				int pzh = 0;
				// ------------------------------------
				// 处理凭证号插空问题
				List<String> lpzhgs = baseMapper.selectkjqjpzhgs(ywpzEntity.getKjqj());// 查此会计期间有多少条pzh
				String maxpzhck = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());// 查此会计期间最大pzh
				if (lpzhgs.isEmpty()) {
					String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
					if ("".equals(maxpzh) || maxpzh == null) {
						pzh = 1;
					} else if (!"".equals(maxpzh) || maxpzh != null) {
						String aa = Integer.parseInt(maxpzh) + 1 + "";
						DecimalFormat df = new DecimalFormat("0");
						String result = df.format(Integer.parseInt(aa));
						pzh = Integer.parseInt(result);
					}
				} else {
					int maxPZH = Integer.parseInt(maxpzhck);
					if (maxPZH == lpzhgs.size()) {// 如果相等则表示该会计期间pzh没有断号，则按pzh+1规则来生成pzh
						String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
						if ("".equals(maxpzh) || maxpzh == null) {
							pzh = 1;
						} else if (!"".equals(maxpzh) || maxpzh != null) {
							String aa = Integer.parseInt(maxpzh) + 1 + "";
							DecimalFormat df = new DecimalFormat("0");
							String result = df.format(Integer.parseInt(aa));
							pzh = Integer.parseInt(result);
						}
					} else {// 不相等则表示存在断号，需先补漏，全部补完了不断号之后再按pzh+1规则来生成pzh
						for (int i = 1; i <= maxPZH; i++) {
							if (lpzhgs.contains(i + "")) {

							} else {
								pzh = i;
								break;
							}
						}
					}
				}
				// ------------------------------------
				int flxh = 1;
				Collections.sort(ywpzEntity.getHPzEntities(), new Comparator<HPzEntity>() {// 按照单据日期升序排序
					@Override
					public int compare(HPzEntity o1, HPzEntity o2) {
						return o1.getDjrq().compareTo(o2.getDjrq());
					}
				});
				for (int j = 0; j < ywpzEntity.getHPzEntities().size(); j++) {
					// 先生成借方凭证
					HPzEntity hPzEntityjf2 = new HPzEntity();
					hPzEntityjf2.setGzdbm("0001");
					hPzEntityjf2.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf2.setPzh(pzh);
					hPzEntityjf2.setFlxh(flxh);
					// ------系统日期
					String temp_strx = "";
					Date dtx = new Date();
					SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
					temp_strx = sdfx.format(dtx);
					// -----
					if ("1".equals(ywpzEntity.getSfsxtpl())) {
						hPzEntityjf2.setPzrq(ywpzEntity.getMaxywrq());
					} else {
						hPzEntityjf2.setPzrq(ywpzEntity.getHPzEntities().get(j).getDjrq());
					}
					// hPzEntityjf2.setPzrq(ywpzEntity.getHPzEntities().get(j).getDjrq());
					hPzEntityjf2.setFjzs(0);
					hPzEntityjf2.setZymc(ywpzEntity.getHPzEntities().get(j).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(j).getDwmc());
					// -----
					String maxzybm1 = baseMapper.selectmaxzybm();
					String newzybm1 = "";
					if ("".equals(maxzybm1) || maxzybm1 == null) {
						newzybm1 = "0001";
					} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
						String aa = Integer.parseInt(maxzybm1) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm1 = result;
					}
					HZyEntity zy1 = new HZyEntity();
					zy1.setZybm(newzybm1);
					zy1.setZymc(ywpzEntity.getHPzEntities().get(j).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(j).getDwmc());
					zy1.setZtbm("0003");
					baseMapper.insertzy(zy1);
					// ----
					hPzEntityjf2.setKm(ywpzEntity.getHPzEntities().get(j).getYhkmdm());
					hPzEntityjf2.setJfje(ywpzEntity.getHPzEntities().get(j).getJe());
					hPzEntityjf2.setDfje(0.0);
					hPzEntityjf2.setSfsh("0");
					hPzEntityjf2.setSfjz("0");
					hPzEntityjf2.setLrfs("1");
					hPzEntityjf2.setYwlx("01");

					hPzEntityjf2.setYwbh(ywpzEntity.getHPzEntities().get(j).getZph());
					hPzEntityjf2.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str1 = "";
					Date dt1 = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str1 = sdf1.format(dt1);
					hPzEntityjf2.setZdsj(temp_str1);
					hPzEntityjf2.setJzsj(temp_str1);
					hPzEntityjf2.setZtbm("0003");
					hPzEntityjf2.setPztype("记账");
					hPzEntityjf2.setZdrmc(ywpzEntity.getZdrmc());
					baseMapper.inserthpzjf(hPzEntityjf2);
					hPzEntityjf2.setDjbh(ywpzEntity.getHPzEntities().get(j).getDjbh());
					// 改单据生成凭证之后将pzh记录在ywpz该pzh字段单据中
					baseMapper.updateywpzpzh(hPzEntityjf2);
					flxh = flxh + 1;

					//
					// 单位凭证生成的时候，将辅助核算明细中该单据的pzh和cwkjqj刷进去
					baseMapper.updatefzhsmxdw(hPzEntityjf2);
				}

				// -------------
				// List<List<HPzEntity>> resultwa =
				// getDuplicateElements(ywpzEntity.getHPzEntities());
				// 开发商科目都是交存，只生产一条
				HPzEntity l = new HPzEntity();
				l.setKjqj(ywpzEntity.getKjqj());
				l.setPzh(pzh);
				flxh = baseMapper.selectmaxflxh(l);// 获取当前会计期间当前凭证号的最大flxh+1的值
				// b.再生成开发商贷方凭证
				double sumq = 0.0;
				for (HPzEntity p : ywpzEntity.getHPzEntities()) {
					sumq = sumq + p.getJe();
				}
				HPzEntity hPzEntityjf = new HPzEntity();
				hPzEntityjf.setGzdbm("0001");
				hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
				hPzEntityjf.setPzh(pzh);
				hPzEntityjf.setFlxh(flxh);
				// ------系统日期
				String temp_strx = "";
				Date dtx = new Date();
				SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
				temp_strx = sdfx.format(dtx);
				// -----
				if ("1".equals(ywpzEntity.getSfsxtpl())) {
					hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
				} else {
					hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(0).getDjrq());
				}
				// hPzEntityjf.setPzrq(resultwa.get(x).get(0).getDjrq());
				hPzEntityjf.setFjzs(0);
				hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(0).getBillname() + "_"
						+ ywpzEntity.getHPzEntities().get(0).getDwmc()
						+ ywpzEntity.getHPzEntities().get(0).getDfzytszd() + "等");
				// -----
				String maxzybm = baseMapper.selectmaxzybm();
				String newzybm = "";
				if ("".equals(maxzybm) || maxzybm == null) {
					newzybm = "0001";
				} else if (!"".equals(maxzybm) && maxzybm != null) {
					String aa = Integer.parseInt(maxzybm) + 1 + "";
					DecimalFormat df = new DecimalFormat("0000");
					String result = df.format(Integer.parseInt(aa));
					newzybm = result;
				}
				HZyEntity zy = new HZyEntity();
				zy.setZybm(newzybm);
				zy.setZymc(ywpzEntity.getHPzEntities().get(0).getBillname() + "_"
						+ ywpzEntity.getHPzEntities().get(0).getDwmc()
						+ ywpzEntity.getHPzEntities().get(0).getDfzytszd() + "等");
				zy.setZtbm("0003");
				baseMapper.insertzy(zy);
				// -----
				hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(0).getKfskmdm());
				hPzEntityjf.setJfje(0.0);
				hPzEntityjf.setDfje(sumq);
				hPzEntityjf.setSfsh("0");
				hPzEntityjf.setSfjz("0");
				hPzEntityjf.setLrfs("1");
				hPzEntityjf.setYwlx(ywpzEntity.getHPzEntities().get(0).getJsfs());
				hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(0).getZph());
				hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
				String temp_str = "";
				Date dt = new Date();
				// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				temp_str = sdf.format(dt);
				hPzEntityjf.setZdsj(temp_str);
				hPzEntityjf.setZtbm("0003");
				hPzEntityjf.setPztype("记账");
				hPzEntityjf.setJzsj(temp_str);
				hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
				baseMapper.inserthpzjf(hPzEntityjf);
			}
		}
		return R.ok();
	}

	@Override
	public PageInfo<YwpzEntity> queryByPageGRPZ(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		List<YwpzEntity> ywHPzEntities111 = baseMapper.queryByPageGRPZ(ywpzEntity);
		Double sumje = 0.0;
		for (YwpzEntity y : ywHPzEntities111) {
			sumje = sumje + y.getJe();
		}
		sumje = (double) Math.round(sumje * 100) / 100;
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzEntity> ywHPzEntities = baseMapper.queryByPageGRPZ(ywpzEntity);
		if (!ywHPzEntities.isEmpty()) {
			ywHPzEntities.get(0).setJezh(sumje);
		}
		for (YwpzEntity y : ywHPzEntities) {
			String djrq = y.getDjrq();
			String gdrq = "2020-12-31";// 切换新旧科目的临界日期
			int res = djrq.compareTo(gdrq);
			if (res <= 0) {// 用2021以前市局科目
				y.setZtbm("0002");
				// 1.贷方科目：新科目不按单位个人缴分，按交存分。所以每一笔单据业务的开发商科目代码都是：201001，开发商科目名称都是：“商品住宅维修资金-交存”
				if ("13".equals(y.getDjlx())) {
					// 1.借方
					y.setYhkmdm("201004");
					y.setYzkmdmmc("商品住宅维修资金-退款");
					// 2.贷方科目
					// 获取该开发商预交的银行科目代码
					HKmEntity hKmEntitya = baseMapper.selectbymc2(y.getYhmc());
					// 设置该单据的银行核算科目
					y.setYzkmdm(hKmEntitya.getKm() + "001");
				} else {
					// 1.贷方科目
					y.setYzkmdm("201001");
					y.setYzkmdmmc("商品住宅维修资金-交存");
					// 2.借方科目
					// 获取该开发商预交的银行科目代码
					HKmEntity hKmEntitya = baseMapper.selectbymc2(y.getYhmc());
					// 设置该单据的银行核算科目
					y.setYhkmdm(hKmEntitya.getKm() + "001");
				}
			} else if (res > 0) {// 用2021以后科目规则
				y.setZtbm("0003");
				// 1.贷方科目：新科目不按单位个人缴分，按交存分。所以每一笔单据业务的开发商科目代码都是：201001，开发商科目名称都是：“商品住宅维修资金-交存”
				if ("13".equals(y.getDjlx())) {
					// 1.借方
					y.setYhkmdm("5101");
					y.setYzkmdmmc("返还支出");
					// 2.贷方科目
					// 获取该开发商预交的银行科目代码
					HKmEntity hKmEntitya = baseMapper.selectbymc22(y.getYhmc());
					// 设置该单据的银行核算科目
					y.setYzkmdm(hKmEntitya.getKm() + "01");
				} else {
					// 1.贷方科目
					y.setYzkmdm("400101");
					y.setYzkmdmmc("交存收入-已处理交存收入");
					// 2.借方科目
					// 获取该开发商预交的银行科目代码
					HKmEntity hKmEntitya = baseMapper.selectbymc22(y.getYhmc());
					// 设置该单据的银行核算科目
					y.setYhkmdm(hKmEntitya.getKm() + "01");
				}
			}
		}

		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywHPzEntities);
		return pageInfo;
	}

	public static Boolean isObjectNotEmpty(Object obj) {
		String str = ObjectUtils.toString(obj, "");
		return StringUtils.isNotBlank(str);
	}

	@Override
	public R insertGRPZSC(YwpzEntity ywpzEntity) {

		// 3.判断是否合并分录
		if (0 == ywpzEntity.getSfhbfl()) {
			// 不合并分录
			if ("0002".equals(ywpzEntity.getZtbm())) {// 2019以后新科目生成规则
				// 2.生成凭证号(取当前会计期间最大凭证号+1)：
				int pzh = 0;
				// ------------------------------------
				// 处理凭证号插空问题
				List<String> lpzhgs = baseMapper.selectkjqjpzhgs(ywpzEntity.getKjqj());// 查此会计期间有多少条pzh
				String maxpzhck = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());// 查此会计期间最大pzh
				if (lpzhgs.isEmpty()) {
					String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
					if ("".equals(maxpzh) || maxpzh == null) {
						pzh = 1;
					} else if (!"".equals(maxpzh) || maxpzh != null) {
						String aa = Integer.parseInt(maxpzh) + 1 + "";
						DecimalFormat df = new DecimalFormat("0");
						String result = df.format(Integer.parseInt(aa));
						pzh = Integer.parseInt(result);
					}
				} else {
					int maxPZH = Integer.parseInt(maxpzhck);
					if (maxPZH == lpzhgs.size()) {// 如果相等则表示该会计期间pzh没有断号，则按pzh+1规则来生成pzh
						String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
						if ("".equals(maxpzh) || maxpzh == null) {
							pzh = 1;
						} else if (!"".equals(maxpzh) || maxpzh != null) {
							String aa = Integer.parseInt(maxpzh) + 1 + "";
							DecimalFormat df = new DecimalFormat("0");
							String result = df.format(Integer.parseInt(aa));
							pzh = Integer.parseInt(result);
						}
					} else {// 不相等则表示存在断号，需先补漏，全部补完了不断号之后再按pzh+1规则来生成pzh
						for (int i = 1; i <= maxPZH; i++) {
							if (lpzhgs.contains(i + "")) {

							} else {
								pzh = i;
								break;
							}
						}
					}
				}
				// ------------------------------------

				Collections.sort(ywpzEntity.getHPzEntities(), new Comparator<HPzEntity>() {// 按照单据日期升序排序
					@Override
					public int compare(HPzEntity o1, HPzEntity o2) {
						return o1.getDjrq().compareTo(o2.getDjrq());
					}
				});
				int flxh = 1;
				// 1.遍历每一个勾选的业务单据
				for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
					// a.先生成借方凭证
					HPzEntity hPzEntityjf = new HPzEntity();
					hPzEntityjf.setGzdbm("0001");
					hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf.setPzh(pzh);
					hPzEntityjf.setFlxh(flxh);
					// ------系统日期
					String temp_strx = "";
					Date dtx = new Date();
					SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
					temp_strx = sdfx.format(dtx);
					// -----
					if ("1".equals(ywpzEntity.getSfsxtpl())) {
						hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
					} else {
						hPzEntityjf.setPzrq(temp_strx);
					}
					// hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(i).getDjrq());
					hPzEntityjf.setFjzs(0);
					hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getXm());
					// -----
					String maxzybm1 = baseMapper.selectmaxzybm();
					String newzybm1 = "";
					if ("".equals(maxzybm1) || maxzybm1 == null) {
						newzybm1 = "0001";
					} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
						String aa = Integer.parseInt(maxzybm1) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm1 = result;
					}
					HZyEntity zy1 = new HZyEntity();
					zy1.setZybm(newzybm1);
					zy1.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getXm());
					zy1.setZtbm("0002");
					baseMapper.insertzy(zy1);
					// ----
					hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(i).getYhkmdm());
					hPzEntityjf.setJfje(ywpzEntity.getHPzEntities().get(i).getJe());
					hPzEntityjf.setDfje(0.0);
					hPzEntityjf.setSfsh("0");
					hPzEntityjf.setSfjz("0");
					hPzEntityjf.setLrfs("1");
					hPzEntityjf.setYwlx("03");
					hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(i).getZph());
					hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str = "";
					Date dt = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str = sdf.format(dt);
					hPzEntityjf.setZdsj(temp_str);
					hPzEntityjf.setZtbm("0002");
					hPzEntityjf.setPztype("记账");
					hPzEntityjf.setJzsj(temp_str);
					hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
					baseMapper.inserthpzjf(hPzEntityjf);
					hPzEntityjf.setDjbh(ywpzEntity.getHPzEntities().get(i).getDjbh());
					// 改单位预交单据生成凭证之后将pzh记录在ywpz该pzh字段单据中
					baseMapper.updateywpzpzh(hPzEntityjf);
					flxh = flxh + 1;

					// 个人凭证生成的时候，将辅助核算明细中该单据的pzh和cwkjqj刷进去
					baseMapper.updatefzhsmxdw(hPzEntityjf);
				}

				for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
					HPzEntity l = new HPzEntity();
					l.setKjqj(ywpzEntity.getKjqj());
					l.setPzh(pzh);
					flxh = baseMapper.selectmaxflxh(l);// 获取当前会计期间当前凭证号的最大flxh+1的值
					// b.再生成业主贷方凭证
					HPzEntity hPzEntityjf = new HPzEntity();
					hPzEntityjf.setGzdbm("0001");
					hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf.setPzh(pzh);
					hPzEntityjf.setFlxh(flxh);
					// ------系统日期
					String temp_strx = "";
					Date dtx = new Date();
					SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
					temp_strx = sdfx.format(dtx);
					// -----
					if ("1".equals(ywpzEntity.getSfsxtpl())) {
						hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
					} else {
						hPzEntityjf.setPzrq(temp_strx);
					}
					// hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(i).getDjrq());
					hPzEntityjf.setFjzs(0);
					hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getXqmc()
							+ ywpzEntity.getHPzEntities().get(i).getXmmc()
							+ ywpzEntity.getHPzEntities().get(i).getMphm()
							+ ywpzEntity.getHPzEntities().get(i).getXm());
					// -----
					String maxzybm1 = baseMapper.selectmaxzybm();
					String newzybm1 = "";
					if ("".equals(maxzybm1) || maxzybm1 == null) {
						newzybm1 = "0001";
					} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
						String aa = Integer.parseInt(maxzybm1) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm1 = result;
					}
					HZyEntity zy1 = new HZyEntity();
					zy1.setZybm(newzybm1);
					zy1.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getXqmc()
							+ ywpzEntity.getHPzEntities().get(i).getXmmc()
							+ ywpzEntity.getHPzEntities().get(i).getMphm()
							+ ywpzEntity.getHPzEntities().get(i).getXm());
					zy1.setZtbm("0002");
					baseMapper.insertzy(zy1);
					// ----
					hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(i).getYzkmdm());
					hPzEntityjf.setJfje(0.0);
					hPzEntityjf.setDfje(ywpzEntity.getHPzEntities().get(i).getJe());
					hPzEntityjf.setSfsh("0");
					hPzEntityjf.setSfjz("0");
					hPzEntityjf.setLrfs("1");
					hPzEntityjf.setYwlx(ywpzEntity.getHPzEntities().get(i).getJsfs());
					hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(i).getZph());
					hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str = "";
					Date dt = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str = sdf.format(dt);
					hPzEntityjf.setZdsj(temp_str);
					hPzEntityjf.setZtbm("0002");
					hPzEntityjf.setJzsj(temp_str);
					hPzEntityjf.setPztype("记账");
					hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
					baseMapper.inserthpzjf(hPzEntityjf);
				}
			} else if ("0003".equals(ywpzEntity.getZtbm())) {// 2019以前旧科目生成规则
				// 2.生成凭证号(取当前会计期间最大凭证号+1)：
				int pzh = 0;
				// ------------------------------------
				// 处理凭证号插空问题
				List<String> lpzhgs = baseMapper.selectkjqjpzhgs(ywpzEntity.getKjqj());// 查此会计期间有多少条pzh
				String maxpzhck = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());// 查此会计期间最大pzh
				if (lpzhgs.isEmpty()) {
					String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
					if ("".equals(maxpzh) || maxpzh == null) {
						pzh = 1;
					} else if (!"".equals(maxpzh) || maxpzh != null) {
						String aa = Integer.parseInt(maxpzh) + 1 + "";
						DecimalFormat df = new DecimalFormat("0");
						String result = df.format(Integer.parseInt(aa));
						pzh = Integer.parseInt(result);
					}
				} else {
					int maxPZH = Integer.parseInt(maxpzhck);
					if (maxPZH == lpzhgs.size()) {// 如果相等则表示该会计期间pzh没有断号，则按pzh+1规则来生成pzh
						String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
						if ("".equals(maxpzh) || maxpzh == null) {
							pzh = 1;
						} else if (!"".equals(maxpzh) || maxpzh != null) {
							String aa = Integer.parseInt(maxpzh) + 1 + "";
							DecimalFormat df = new DecimalFormat("0");
							String result = df.format(Integer.parseInt(aa));
							pzh = Integer.parseInt(result);
						}
					} else {// 不相等则表示存在断号，需先补漏，全部补完了不断号之后再按pzh+1规则来生成pzh
						for (int i = 1; i <= maxPZH; i++) {
							if (lpzhgs.contains(i + "")) {

							} else {
								pzh = i;
								break;
							}
						}
					}
				}
				// ------------------------------------

				Collections.sort(ywpzEntity.getHPzEntities(), new Comparator<HPzEntity>() {// 按照单据日期升序排序
					@Override
					public int compare(HPzEntity o1, HPzEntity o2) {
						return o1.getDjrq().compareTo(o2.getDjrq());
					}
				});
				int flxh = 1;
				// 1.遍历每一个勾选的业务单据
				for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
					// a.先生成借方凭证
					HPzEntity hPzEntityjf = new HPzEntity();
					hPzEntityjf.setGzdbm("0001");
					hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf.setPzh(pzh);
					hPzEntityjf.setFlxh(flxh);
					// ------系统日期
					String temp_strx = "";
					Date dtx = new Date();
					SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
					temp_strx = sdfx.format(dtx);
					// -----
					if ("1".equals(ywpzEntity.getSfsxtpl())) {
						hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
					} else {
						hPzEntityjf.setPzrq(temp_strx);
					}
					// hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(i).getDjrq());
					hPzEntityjf.setFjzs(0);
					hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getXm());
					// -----
					String maxzybm1 = baseMapper.selectmaxzybm();
					String newzybm1 = "";
					if ("".equals(maxzybm1) || maxzybm1 == null) {
						newzybm1 = "0001";
					} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
						String aa = Integer.parseInt(maxzybm1) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm1 = result;
					}
					HZyEntity zy1 = new HZyEntity();
					zy1.setZybm(newzybm1);
					zy1.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getXm());
					zy1.setZtbm("0003");
					baseMapper.insertzy(zy1);
					// ----
					hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(i).getYhkmdm());
					hPzEntityjf.setJfje(ywpzEntity.getHPzEntities().get(i).getJe());
					hPzEntityjf.setDfje(0.0);
					hPzEntityjf.setSfsh("0");
					hPzEntityjf.setSfjz("0");
					hPzEntityjf.setLrfs("1");
					hPzEntityjf.setYwlx("03");
					hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(i).getZph());
					hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str = "";
					Date dt = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str = sdf.format(dt);
					hPzEntityjf.setZdsj(temp_str);
					hPzEntityjf.setZtbm("0003");
					hPzEntityjf.setPztype("记账");
					hPzEntityjf.setJzsj(temp_str);
					hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
					baseMapper.inserthpzjf(hPzEntityjf);
					hPzEntityjf.setDjbh(ywpzEntity.getHPzEntities().get(i).getDjbh());
					// 改单位预交单据生成凭证之后将pzh记录在ywpz该pzh字段单据中
					baseMapper.updateywpzpzh(hPzEntityjf);
					flxh = flxh + 1;

					// 个人凭证生成的时候，将辅助核算明细中该单据的pzh和cwkjqj刷进去
					baseMapper.updatefzhsmxdw(hPzEntityjf);
				}

				for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
					HPzEntity l = new HPzEntity();
					l.setKjqj(ywpzEntity.getKjqj());
					l.setPzh(pzh);
					flxh = baseMapper.selectmaxflxh(l);// 获取当前会计期间当前凭证号的最大flxh+1的值
					// b.再生成业主贷方凭证
					HPzEntity hPzEntityjf = new HPzEntity();
					hPzEntityjf.setGzdbm("0001");
					hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf.setPzh(pzh);
					hPzEntityjf.setFlxh(flxh);
					// ------系统日期
					String temp_strx = "";
					Date dtx = new Date();
					SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
					temp_strx = sdfx.format(dtx);
					// -----
					if ("1".equals(ywpzEntity.getSfsxtpl())) {
						hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
					} else {
						hPzEntityjf.setPzrq(temp_strx);
					}
					// hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(i).getDjrq());
					hPzEntityjf.setFjzs(0);
					hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getXqmc()
							+ ywpzEntity.getHPzEntities().get(i).getXmmc()
							+ ywpzEntity.getHPzEntities().get(i).getMphm()
							+ ywpzEntity.getHPzEntities().get(i).getXm());
					// -----
					String maxzybm1 = baseMapper.selectmaxzybm();
					String newzybm1 = "";
					if ("".equals(maxzybm1) || maxzybm1 == null) {
						newzybm1 = "0001";
					} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
						String aa = Integer.parseInt(maxzybm1) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm1 = result;
					}
					HZyEntity zy1 = new HZyEntity();
					zy1.setZybm(newzybm1);
					zy1.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(i).getXqmc()
							+ ywpzEntity.getHPzEntities().get(i).getXmmc()
							+ ywpzEntity.getHPzEntities().get(i).getMphm()
							+ ywpzEntity.getHPzEntities().get(i).getXm());
					zy1.setZtbm("0003");
					baseMapper.insertzy(zy1);
					// ----
					hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(i).getYzkmdm());
					hPzEntityjf.setJfje(0.0);
					hPzEntityjf.setDfje(ywpzEntity.getHPzEntities().get(i).getJe());
					hPzEntityjf.setSfsh("0");
					hPzEntityjf.setSfjz("0");
					hPzEntityjf.setLrfs("1");
					hPzEntityjf.setYwlx(ywpzEntity.getHPzEntities().get(i).getJsfs());
					hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(i).getZph());
					hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str = "";
					Date dt = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str = sdf.format(dt);
					hPzEntityjf.setZdsj(temp_str);
					hPzEntityjf.setZtbm("0003");
					hPzEntityjf.setJzsj(temp_str);
					hPzEntityjf.setPztype("记账");
					hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
					baseMapper.inserthpzjf(hPzEntityjf);
				}
			}

		} else if (1 == ywpzEntity.getSfhbfl() && "0".equals(ywpzEntity.getSftssc())) {
			// 合并分录(多条业主预交记录生成一条贷方凭证，借方生成多条凭证)
			double sum = 0.0;
			for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
				sum = sum + ywpzEntity.getHPzEntities().get(i).getJe();
			}
			if ("0002".equals(ywpzEntity.getZtbm())) {// 启用2019以后市局新科目生成规则
				// 2.生成凭证号(取当前会计期间最大凭证号+1)：
				int pzh = 0;
				// ------------------------------------
				// 处理凭证号插空问题
				List<String> lpzhgs = baseMapper.selectkjqjpzhgs(ywpzEntity.getKjqj());// 查此会计期间有多少条pzh
				String maxpzhck = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());// 查此会计期间最大pzh
				if (lpzhgs.isEmpty()) {
					String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
					if ("".equals(maxpzh) || maxpzh == null) {
						pzh = 1;
					} else if (!"".equals(maxpzh) || maxpzh != null) {
						String aa = Integer.parseInt(maxpzh) + 1 + "";
						DecimalFormat df = new DecimalFormat("0");
						String result = df.format(Integer.parseInt(aa));
						pzh = Integer.parseInt(result);
					}
				} else {
					int maxPZH = Integer.parseInt(maxpzhck);
					if (maxPZH == lpzhgs.size()) {// 如果相等则表示该会计期间pzh没有断号，则按pzh+1规则来生成pzh
						String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
						if ("".equals(maxpzh) || maxpzh == null) {
							pzh = 1;
						} else if (!"".equals(maxpzh) || maxpzh != null) {
							String aa = Integer.parseInt(maxpzh) + 1 + "";
							DecimalFormat df = new DecimalFormat("0");
							String result = df.format(Integer.parseInt(aa));
							pzh = Integer.parseInt(result);
						}
					} else {// 不相等则表示存在断号，需先补漏，全部补完了不断号之后再按pzh+1规则来生成pzh
						for (int i = 1; i <= maxPZH; i++) {
							if (lpzhgs.contains(i + "")) {

							} else {
								pzh = i;
								break;
							}
						}
					}
				}
				// ------------------------------------

				int flxh = 1;
				// ---------
				Collections.sort(ywpzEntity.getHPzEntities(), new Comparator<HPzEntity>() {// 按照单据日期升序排序
					@Override
					public int compare(HPzEntity o1, HPzEntity o2) {
						return o1.getDjrq().compareTo(o2.getDjrq());
					}
				});
				for (int j = 0; j < ywpzEntity.getHPzEntities().size(); j++) {
					// b.先生成银行借方凭证
					HPzEntity hPzEntityjf = new HPzEntity();
					hPzEntityjf.setGzdbm("0001");
					hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf.setPzh(pzh);
					hPzEntityjf.setFlxh(flxh);
					// ------系统日期
					String temp_strx = "";
					Date dtx = new Date();
					SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
					temp_strx = sdfx.format(dtx);
					// -----
					if ("1".equals(ywpzEntity.getSfsxtpl())) {
						hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
					} else {
						hPzEntityjf.setPzrq(temp_strx);
					}
					// hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(j).getDjrq());
					hPzEntityjf.setFjzs(0);
					hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(j).getBillname() + "-"
							+ ywpzEntity.getHPzEntities().get(j).getXm());
					// -----
					String maxzybm2 = baseMapper.selectmaxzybm();
					String newzybm2 = "";
					if ("".equals(maxzybm2) || maxzybm2 == null) {
						newzybm2 = "0001";
					} else if (!"".equals(maxzybm2) && maxzybm2 != null) {
						String aa = Integer.parseInt(maxzybm2) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm2 = result;
					}
					HZyEntity zy2 = new HZyEntity();
					zy2.setZybm(newzybm2);
					zy2.setZymc(ywpzEntity.getHPzEntities().get(j).getBillname() + "-"
							+ ywpzEntity.getHPzEntities().get(j).getXm());
					zy2.setZtbm("0002");
					baseMapper.insertzy(zy2);
					// ----
					hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(j).getYhkmdm());
					hPzEntityjf.setJfje(ywpzEntity.getHPzEntities().get(j).getJe());
					hPzEntityjf.setDfje(0.0);
					hPzEntityjf.setSfsh("0");
					hPzEntityjf.setSfjz("0");
					hPzEntityjf.setLrfs("1");
					hPzEntityjf.setYwlx("03");
					hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(j).getZph());
					hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str = "";
					Date dt = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str = sdf.format(dt);
					hPzEntityjf.setZdsj(temp_str);
					hPzEntityjf.setZtbm("0002");
					hPzEntityjf.setJzsj(temp_str);
					hPzEntityjf.setPztype("记账");
					hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
					baseMapper.inserthpzjf(hPzEntityjf);
					flxh = flxh + 1;
					hPzEntityjf.setDjbh(ywpzEntity.getHPzEntities().get(j).getDjbh());
					// 改单据生成凭证之后将pzh记录在ywpz该pzh字段单据中
					baseMapper.updateywpzpzh(hPzEntityjf);

					// 个人凭证生成的时候，将辅助核算明细中该单据的pzh和cwkjqj刷进去
					baseMapper.updatefzhsmxdw(hPzEntityjf);
				}

				// a.再生成业主贷方凭证
				HPzEntity l = new HPzEntity();
				l.setKjqj(ywpzEntity.getKjqj());
				l.setPzh(pzh);
				flxh = baseMapper.selectmaxflxh(l);// 获取当前会计期间当前凭证号的最大flxh+1的值
				double sumq = 0.0;
				for (HPzEntity p : ywpzEntity.getHPzEntities()) {
					sumq = sumq + p.getJe();
				}
				HPzEntity hPzEntityjf2 = new HPzEntity();
				hPzEntityjf2.setGzdbm("0001");
				hPzEntityjf2.setKjqj(ywpzEntity.getKjqj());
				hPzEntityjf2.setPzh(pzh);
				hPzEntityjf2.setFlxh(flxh);
				// ------系统日期
				String temp_strx = "";
				Date dtx = new Date();
				SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
				temp_strx = sdfx.format(dtx);
				// -----
				if ("1".equals(ywpzEntity.getSfsxtpl())) {
					hPzEntityjf2.setPzrq(ywpzEntity.getMaxywrq());
				} else {
					hPzEntityjf2.setPzrq(temp_strx);
				}
				// hPzEntityjf2.setPzrq(resultwa.get(x).get(0).getDjrq());
				hPzEntityjf2.setFjzs(0);
				hPzEntityjf2.setZymc(ywpzEntity.getHPzEntities().get(0).getBillname() + "_"
						+ ywpzEntity.getHPzEntities().get(0).getXqmc() + ywpzEntity.getHPzEntities().get(0).getXmmc()
						+ ywpzEntity.getHPzEntities().get(0).getMphm() + ywpzEntity.getHPzEntities().get(0).getXm()
						+ "等");
				// -----
				String maxzybm1 = baseMapper.selectmaxzybm();
				String newzybm1 = "";
				if ("".equals(maxzybm1) || maxzybm1 == null) {
					newzybm1 = "0001";
				} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
					String aa = Integer.parseInt(maxzybm1) + 1 + "";
					DecimalFormat df = new DecimalFormat("0000");
					String result = df.format(Integer.parseInt(aa));
					newzybm1 = result;
				}
				HZyEntity zy1 = new HZyEntity();
				zy1.setZybm(newzybm1);
				zy1.setZymc(ywpzEntity.getHPzEntities().get(0).getBillname() + "_"
						+ ywpzEntity.getHPzEntities().get(0).getXqmc() + ywpzEntity.getHPzEntities().get(0).getXmmc()
						+ ywpzEntity.getHPzEntities().get(0).getMphm() + ywpzEntity.getHPzEntities().get(0).getXm()
						+ "等");
				zy1.setZtbm("0002");
				baseMapper.insertzy(zy1);
				// ----

				hPzEntityjf2.setKm(ywpzEntity.getHPzEntities().get(0).getYzkmdm());
				hPzEntityjf2.setJfje(0.0);
				hPzEntityjf2.setDfje(sumq);
				hPzEntityjf2.setSfsh("0");
				hPzEntityjf2.setSfjz("0");
				hPzEntityjf2.setLrfs("1");
				hPzEntityjf2.setYwlx(ywpzEntity.getHPzEntities().get(0).getJsfs());
				hPzEntityjf2.setYwbh(ywpzEntity.getHPzEntities().get(0).getZph());
				hPzEntityjf2.setZdrbm(ywpzEntity.getZdrbm());
				String temp_str1 = "";
				Date dt1 = new Date();
				// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
				SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				temp_str1 = sdf1.format(dt1);
				hPzEntityjf2.setZdsj(temp_str1);
				hPzEntityjf2.setZtbm("0002");
				hPzEntityjf2.setPztype("记账");
				hPzEntityjf2.setJzsj(temp_str1);
				hPzEntityjf2.setZdrmc(ywpzEntity.getZdrmc());
				baseMapper.inserthpzjf(hPzEntityjf2);
			} else if ("0003".equals(ywpzEntity.getZtbm())) {// 用2019以前旧科目生成规则
				// 2.生成凭证号(取当前会计期间最大凭证号+1)：
				int pzh = 0;
				// ------------------------------------
				// 处理凭证号插空问题
				List<String> lpzhgs = baseMapper.selectkjqjpzhgs(ywpzEntity.getKjqj());// 查此会计期间有多少条pzh
				String maxpzhck = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());// 查此会计期间最大pzh
				if (lpzhgs.isEmpty()) {
					String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
					if ("".equals(maxpzh) || maxpzh == null) {
						pzh = 1;
					} else if (!"".equals(maxpzh) || maxpzh != null) {
						String aa = Integer.parseInt(maxpzh) + 1 + "";
						DecimalFormat df = new DecimalFormat("0");
						String result = df.format(Integer.parseInt(aa));
						pzh = Integer.parseInt(result);
					}
				} else {
					int maxPZH = Integer.parseInt(maxpzhck);
					if (maxPZH == lpzhgs.size()) {// 如果相等则表示该会计期间pzh没有断号，则按pzh+1规则来生成pzh
						String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
						if ("".equals(maxpzh) || maxpzh == null) {
							pzh = 1;
						} else if (!"".equals(maxpzh) || maxpzh != null) {
							String aa = Integer.parseInt(maxpzh) + 1 + "";
							DecimalFormat df = new DecimalFormat("0");
							String result = df.format(Integer.parseInt(aa));
							pzh = Integer.parseInt(result);
						}
					} else {// 不相等则表示存在断号，需先补漏，全部补完了不断号之后再按pzh+1规则来生成pzh
						for (int i = 1; i <= maxPZH; i++) {
							if (lpzhgs.contains(i + "")) {

							} else {
								pzh = i;
								break;
							}
						}
					}
				}
				// ------------------------------------

				int flxh = 1;
				// ---------
				Collections.sort(ywpzEntity.getHPzEntities(), new Comparator<HPzEntity>() {// 按照单据日期升序排序
					@Override
					public int compare(HPzEntity o1, HPzEntity o2) {
						return o1.getDjrq().compareTo(o2.getDjrq());
					}
				});
				for (int j = 0; j < ywpzEntity.getHPzEntities().size(); j++) {
					// b.先生成银行借方凭证
					HPzEntity hPzEntityjf = new HPzEntity();
					hPzEntityjf.setGzdbm("0001");
					hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf.setPzh(pzh);
					hPzEntityjf.setFlxh(flxh);
					// ------系统日期
					String temp_strx = "";
					Date dtx = new Date();
					SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
					temp_strx = sdfx.format(dtx);
					// -----
					if ("1".equals(ywpzEntity.getSfsxtpl())) {
						hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
					} else {
						hPzEntityjf.setPzrq(temp_strx);
					}
					// hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(j).getDjrq());
					hPzEntityjf.setFjzs(0);
					hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(j).getBillname() + "-"
							+ ywpzEntity.getHPzEntities().get(j).getXm());
					// -----
					String maxzybm2 = baseMapper.selectmaxzybm();
					String newzybm2 = "";
					if ("".equals(maxzybm2) || maxzybm2 == null) {
						newzybm2 = "0001";
					} else if (!"".equals(maxzybm2) && maxzybm2 != null) {
						String aa = Integer.parseInt(maxzybm2) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm2 = result;
					}
					HZyEntity zy2 = new HZyEntity();
					zy2.setZybm(newzybm2);
					zy2.setZymc(ywpzEntity.getHPzEntities().get(j).getBillname() + "-"
							+ ywpzEntity.getHPzEntities().get(j).getXm());
					zy2.setZtbm("0003");
					baseMapper.insertzy(zy2);
					// ----
					hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(j).getYhkmdm());
					hPzEntityjf.setJfje(ywpzEntity.getHPzEntities().get(j).getJe());
					hPzEntityjf.setDfje(0.0);
					hPzEntityjf.setSfsh("0");
					hPzEntityjf.setSfjz("0");
					hPzEntityjf.setLrfs("1");
					hPzEntityjf.setYwlx("03");
					hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(j).getZph());
					hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str = "";
					Date dt = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str = sdf.format(dt);
					hPzEntityjf.setZdsj(temp_str);
					hPzEntityjf.setZtbm("0003");
					hPzEntityjf.setJzsj(temp_str);
					hPzEntityjf.setPztype("记账");
					hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
					baseMapper.inserthpzjf(hPzEntityjf);
					flxh = flxh + 1;
					hPzEntityjf.setDjbh(ywpzEntity.getHPzEntities().get(j).getDjbh());
					// 改单据生成凭证之后将pzh记录在ywpz该pzh字段单据中
					baseMapper.updateywpzpzh(hPzEntityjf);

					// 个人凭证生成的时候，将辅助核算明细中该单据的pzh和cwkjqj刷进去
					baseMapper.updatefzhsmxdw(hPzEntityjf);
				}

				// a.再生成业主贷方凭证
				HPzEntity l = new HPzEntity();
				l.setKjqj(ywpzEntity.getKjqj());
				l.setPzh(pzh);
				flxh = baseMapper.selectmaxflxh(l);// 获取当前会计期间当前凭证号的最大flxh+1的值
				double sumq = 0.0;
				for (HPzEntity p : ywpzEntity.getHPzEntities()) {
					sumq = sumq + p.getJe();
				}
				HPzEntity hPzEntityjf2 = new HPzEntity();
				hPzEntityjf2.setGzdbm("0001");
				hPzEntityjf2.setKjqj(ywpzEntity.getKjqj());
				hPzEntityjf2.setPzh(pzh);
				hPzEntityjf2.setFlxh(flxh);
				// ------系统日期
				String temp_strx = "";
				Date dtx = new Date();
				SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
				temp_strx = sdfx.format(dtx);
				// -----
				if ("1".equals(ywpzEntity.getSfsxtpl())) {
					hPzEntityjf2.setPzrq(ywpzEntity.getMaxywrq());
				} else {
					hPzEntityjf2.setPzrq(temp_strx);
				}
				// hPzEntityjf2.setPzrq(resultwa.get(x).get(0).getDjrq());
				hPzEntityjf2.setFjzs(0);
				hPzEntityjf2.setZymc(ywpzEntity.getHPzEntities().get(0).getBillname() + "_"
						+ ywpzEntity.getHPzEntities().get(0).getXqmc() + ywpzEntity.getHPzEntities().get(0).getXmmc()
						+ ywpzEntity.getHPzEntities().get(0).getMphm() + ywpzEntity.getHPzEntities().get(0).getXm()
						+ "等");
				// -----
				String maxzybm1 = baseMapper.selectmaxzybm();
				String newzybm1 = "";
				if ("".equals(maxzybm1) || maxzybm1 == null) {
					newzybm1 = "0001";
				} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
					String aa = Integer.parseInt(maxzybm1) + 1 + "";
					DecimalFormat df = new DecimalFormat("0000");
					String result = df.format(Integer.parseInt(aa));
					newzybm1 = result;
				}
				HZyEntity zy1 = new HZyEntity();
				zy1.setZybm(newzybm1);
				zy1.setZymc(ywpzEntity.getHPzEntities().get(0).getBillname() + "_"
						+ ywpzEntity.getHPzEntities().get(0).getXqmc() + ywpzEntity.getHPzEntities().get(0).getXmmc()
						+ ywpzEntity.getHPzEntities().get(0).getMphm() + ywpzEntity.getHPzEntities().get(0).getXm()
						+ "等");
				zy1.setZtbm("0003");
				baseMapper.insertzy(zy1);
				// ----

				hPzEntityjf2.setKm(ywpzEntity.getHPzEntities().get(0).getYzkmdm());
				hPzEntityjf2.setJfje(0.0);
				hPzEntityjf2.setDfje(sumq);
				hPzEntityjf2.setSfsh("0");
				hPzEntityjf2.setSfjz("0");
				hPzEntityjf2.setLrfs("1");
				hPzEntityjf2.setYwlx(ywpzEntity.getHPzEntities().get(0).getJsfs());
				hPzEntityjf2.setYwbh(ywpzEntity.getHPzEntities().get(0).getZph());
				hPzEntityjf2.setZdrbm(ywpzEntity.getZdrbm());
				String temp_str1 = "";
				Date dt1 = new Date();
				// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
				SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				temp_str1 = sdf1.format(dt1);
				hPzEntityjf2.setZdsj(temp_str1);
				hPzEntityjf2.setZtbm("0003");
				hPzEntityjf2.setPztype("记账");
				hPzEntityjf2.setJzsj(temp_str1);
				hPzEntityjf2.setZdrmc(ywpzEntity.getZdrmc());
				baseMapper.inserthpzjf(hPzEntityjf2);
			}

		} else if (1 == ywpzEntity.getSfhbfl() && "1".equals(ywpzEntity.getSftssc())) {// 特殊规则，借方一行，贷方多行
			// 1.开放商代缴，post方式的个人单据都要特殊生成；即勾选的是同一天同一银行，票据号相同或
			// 2.同一天，同一银行，结算方式都为post机方式或3.者同一条，现金方式，同银行，票据号相同）
			// 合并分录(多条业主预交记录生成一条借方凭证，贷方生成多条凭证)
			double sum = 0.0;
			for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
				sum = sum + ywpzEntity.getHPzEntities().get(i).getJe();
			}
			if ("0002".equals(ywpzEntity.getZtbm())) {// 启用2019以后市局新科目生成规则
				// 2.生成凭证号(取当前会计期间最大凭证号+1)：
				int pzh = 0;
				// ------------------------------------
				// 处理凭证号插空问题
				List<String> lpzhgs = baseMapper.selectkjqjpzhgs(ywpzEntity.getKjqj());// 查此会计期间有多少条pzh
				String maxpzhck = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());// 查此会计期间最大pzh
				if (lpzhgs.isEmpty()) {
					String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
					if ("".equals(maxpzh) || maxpzh == null) {
						pzh = 1;
					} else if (!"".equals(maxpzh) || maxpzh != null) {
						String aa = Integer.parseInt(maxpzh) + 1 + "";
						DecimalFormat df = new DecimalFormat("0");
						String result = df.format(Integer.parseInt(aa));
						pzh = Integer.parseInt(result);
					}
				} else {
					int maxPZH = Integer.parseInt(maxpzhck);
					if (maxPZH == lpzhgs.size()) {// 如果相等则表示该会计期间pzh没有断号，则按pzh+1规则来生成pzh
						String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
						if ("".equals(maxpzh) || maxpzh == null) {
							pzh = 1;
						} else if (!"".equals(maxpzh) || maxpzh != null) {
							String aa = Integer.parseInt(maxpzh) + 1 + "";
							DecimalFormat df = new DecimalFormat("0");
							String result = df.format(Integer.parseInt(aa));
							pzh = Integer.parseInt(result);
						}
					} else {// 不相等则表示存在断号，需先补漏，全部补完了不断号之后再按pzh+1规则来生成pzh
						for (int i = 1; i <= maxPZH; i++) {
							if (lpzhgs.contains(i + "")) {

							} else {
								pzh = i;
								break;
							}
						}
					}
				}
				// ------------------------------------
				int flxh = 1;
				// b.先生成银行借方凭证
				HPzEntity hPzEntityjf = new HPzEntity();
				hPzEntityjf.setGzdbm("0001");
				hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
				hPzEntityjf.setPzh(pzh);
				hPzEntityjf.setFlxh(flxh);
				// ------系统日期
				String temp_strx = "";
				Date dtx = new Date();
				SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
				temp_strx = sdfx.format(dtx);
				// -----
				if ("1".equals(ywpzEntity.getSfsxtpl())) {
					hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
				} else {
					hPzEntityjf.setPzrq(temp_strx);
				}
				// hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(j).getDjrq());
				hPzEntityjf.setFjzs(0);
				hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(0).getBillname());
				// -----
				String maxzybm2 = baseMapper.selectmaxzybm();
				String newzybm2 = "";
				if ("".equals(maxzybm2) || maxzybm2 == null) {
					newzybm2 = "0001";
				} else if (!"".equals(maxzybm2) && maxzybm2 != null) {
					String aa = Integer.parseInt(maxzybm2) + 1 + "";
					DecimalFormat df = new DecimalFormat("0000");
					String result = df.format(Integer.parseInt(aa));
					newzybm2 = result;
				}
				HZyEntity zy2 = new HZyEntity();
				zy2.setZybm(newzybm2);
				zy2.setZymc(ywpzEntity.getHPzEntities().get(0).getBillname());
				zy2.setZtbm("0002");
				baseMapper.insertzy(zy2);
				// ----
				hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(0).getYhkmdm());
				hPzEntityjf.setJfje(sum);
				hPzEntityjf.setDfje(0.0);
				hPzEntityjf.setSfsh("0");
				hPzEntityjf.setSfjz("0");
				hPzEntityjf.setLrfs("1");
				hPzEntityjf.setYwlx("03");
				hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(0).getZph());
				hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
				String temp_str = "";
				Date dt = new Date();
				// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				temp_str = sdf.format(dt);
				hPzEntityjf.setZdsj(temp_str);
				hPzEntityjf.setZtbm("0002");
				hPzEntityjf.setJzsj(temp_str);
				hPzEntityjf.setPztype("记账");
				hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
				baseMapper.inserthpzjf(hPzEntityjf);

				for (int j = 0; j < ywpzEntity.getHPzEntities().size(); j++) {
					// a.再生成业主贷方凭证
					HPzEntity l = new HPzEntity();
					l.setKjqj(ywpzEntity.getKjqj());
					l.setPzh(pzh);
					flxh = baseMapper.selectmaxflxh(l);// 获取当前会计期间当前凭证号的最大flxh+1的值
					double sumq = 0.0;
					for (HPzEntity p : ywpzEntity.getHPzEntities()) {
						sumq = sumq + p.getJe();
					}
					HPzEntity hPzEntityjf2 = new HPzEntity();
					hPzEntityjf2.setGzdbm("0001");
					hPzEntityjf2.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf2.setPzh(pzh);
					hPzEntityjf2.setFlxh(flxh);
					// ------系统日期
					// String temp_strx = "";
					// Date dtx = new Date();
					// SimpleDateFormat sdfx = new
					// SimpleDateFormat("yyyy-MM-dd");
					temp_strx = sdfx.format(dtx);
					// -----
					if ("1".equals(ywpzEntity.getSfsxtpl())) {
						hPzEntityjf2.setPzrq(ywpzEntity.getMaxywrq());
					} else {
						hPzEntityjf2.setPzrq(temp_strx);
					}
					// hPzEntityjf2.setPzrq(resultwa.get(x).get(0).getDjrq());
					hPzEntityjf2.setFjzs(0);
					hPzEntityjf2.setZymc(ywpzEntity.getHPzEntities().get(j).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(j).getXqmc()
							+ ywpzEntity.getHPzEntities().get(j).getXmmc()
							+ ywpzEntity.getHPzEntities().get(j).getMphm()
							+ ywpzEntity.getHPzEntities().get(j).getXm());
					// -----
					String maxzybm1 = baseMapper.selectmaxzybm();
					String newzybm1 = "";
					if ("".equals(maxzybm1) || maxzybm1 == null) {
						newzybm1 = "0001";
					} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
						String aa = Integer.parseInt(maxzybm1) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm1 = result;
					}
					HZyEntity zy1 = new HZyEntity();
					zy1.setZybm(newzybm1);
					zy1.setZymc(ywpzEntity.getHPzEntities().get(j).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(j).getXqmc()
							+ ywpzEntity.getHPzEntities().get(j).getXmmc()
							+ ywpzEntity.getHPzEntities().get(j).getMphm()
							+ ywpzEntity.getHPzEntities().get(j).getXm());
					zy1.setZtbm("0002");
					baseMapper.insertzy(zy1);
					// ----

					hPzEntityjf2.setKm(ywpzEntity.getHPzEntities().get(j).getYzkmdm());
					hPzEntityjf2.setJfje(0.0);
					hPzEntityjf2.setDfje(ywpzEntity.getHPzEntities().get(j).getJe());
					hPzEntityjf2.setSfsh("0");
					hPzEntityjf2.setSfjz("0");
					hPzEntityjf2.setLrfs("1");
					hPzEntityjf2.setYwlx(ywpzEntity.getHPzEntities().get(j).getJsfs());
					hPzEntityjf2.setYwbh(ywpzEntity.getHPzEntities().get(j).getZph());
					hPzEntityjf2.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str1 = "";
					Date dt1 = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str1 = sdf1.format(dt1);
					hPzEntityjf2.setZdsj(temp_str1);
					hPzEntityjf2.setZtbm("0002");
					hPzEntityjf2.setPztype("记账");
					hPzEntityjf2.setJzsj(temp_str1);
					hPzEntityjf2.setZdrmc(ywpzEntity.getZdrmc());
					baseMapper.inserthpzjf(hPzEntityjf2);
					hPzEntityjf2.setDjbh(ywpzEntity.getHPzEntities().get(j).getDjbh());
					// 改单据生成凭证之后将pzh记录在ywpz该pzh字段单据中
					baseMapper.updateywpzpzh(hPzEntityjf2);
				}

			} else if ("0003".equals(ywpzEntity.getZtbm())) {// 用2019以前旧科目生成规则
				// 2.生成凭证号(取当前会计期间最大凭证号+1)：
				int pzh = 0;
				// ------------------------------------
				// 处理凭证号插空问题
				List<String> lpzhgs = baseMapper.selectkjqjpzhgs(ywpzEntity.getKjqj());// 查此会计期间有多少条pzh
				String maxpzhck = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());// 查此会计期间最大pzh
				if (lpzhgs.isEmpty()) {
					String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
					if ("".equals(maxpzh) || maxpzh == null) {
						pzh = 1;
					} else if (!"".equals(maxpzh) || maxpzh != null) {
						String aa = Integer.parseInt(maxpzh) + 1 + "";
						DecimalFormat df = new DecimalFormat("0");
						String result = df.format(Integer.parseInt(aa));
						pzh = Integer.parseInt(result);
					}
				} else {
					int maxPZH = Integer.parseInt(maxpzhck);
					if (maxPZH == lpzhgs.size()) {// 如果相等则表示该会计期间pzh没有断号，则按pzh+1规则来生成pzh
						String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
						if ("".equals(maxpzh) || maxpzh == null) {
							pzh = 1;
						} else if (!"".equals(maxpzh) || maxpzh != null) {
							String aa = Integer.parseInt(maxpzh) + 1 + "";
							DecimalFormat df = new DecimalFormat("0");
							String result = df.format(Integer.parseInt(aa));
							pzh = Integer.parseInt(result);
						}
					} else {// 不相等则表示存在断号，需先补漏，全部补完了不断号之后再按pzh+1规则来生成pzh
						for (int i = 1; i <= maxPZH; i++) {
							if (lpzhgs.contains(i + "")) {

							} else {
								pzh = i;
								break;
							}
						}
					}
				}
				// ------------------------------------
				int flxh = 1;
				// b.先生成银行借方凭证
				HPzEntity hPzEntityjf = new HPzEntity();
				hPzEntityjf.setGzdbm("0001");
				hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
				hPzEntityjf.setPzh(pzh);
				hPzEntityjf.setFlxh(flxh);
				// ------系统日期
				String temp_strx = "";
				Date dtx = new Date();
				SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
				temp_strx = sdfx.format(dtx);
				// -----
				if ("1".equals(ywpzEntity.getSfsxtpl())) {
					hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
				} else {
					hPzEntityjf.setPzrq(temp_strx);
				}
				// hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(j).getDjrq());
				hPzEntityjf.setFjzs(0);
				hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(0).getBillname());
				// -----
				String maxzybm2 = baseMapper.selectmaxzybm();
				String newzybm2 = "";
				if ("".equals(maxzybm2) || maxzybm2 == null) {
					newzybm2 = "0001";
				} else if (!"".equals(maxzybm2) && maxzybm2 != null) {
					String aa = Integer.parseInt(maxzybm2) + 1 + "";
					DecimalFormat df = new DecimalFormat("0000");
					String result = df.format(Integer.parseInt(aa));
					newzybm2 = result;
				}
				HZyEntity zy2 = new HZyEntity();
				zy2.setZybm(newzybm2);
				zy2.setZymc(ywpzEntity.getHPzEntities().get(0).getBillname());
				zy2.setZtbm("0003");
				baseMapper.insertzy(zy2);
				// ----
				hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(0).getYhkmdm());
				hPzEntityjf.setJfje(sum);
				hPzEntityjf.setDfje(0.0);
				hPzEntityjf.setSfsh("0");
				hPzEntityjf.setSfjz("0");
				hPzEntityjf.setLrfs("1");
				hPzEntityjf.setYwlx("03");
				hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(0).getZph());
				hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
				String temp_str = "";
				Date dt = new Date();
				// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				temp_str = sdf.format(dt);
				hPzEntityjf.setZdsj(temp_str);
				hPzEntityjf.setZtbm("0003");
				hPzEntityjf.setJzsj(temp_str);
				hPzEntityjf.setPztype("记账");
				hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
				baseMapper.inserthpzjf(hPzEntityjf);

				for (int j = 0; j < ywpzEntity.getHPzEntities().size(); j++) {
					// a.再生成业主贷方凭证
					HPzEntity l = new HPzEntity();
					l.setKjqj(ywpzEntity.getKjqj());
					l.setPzh(pzh);
					flxh = baseMapper.selectmaxflxh(l);// 获取当前会计期间当前凭证号的最大flxh+1的值
					double sumq = 0.0;
					for (HPzEntity p : ywpzEntity.getHPzEntities()) {
						sumq = sumq + p.getJe();
					}
					HPzEntity hPzEntityjf2 = new HPzEntity();
					hPzEntityjf2.setGzdbm("0001");
					hPzEntityjf2.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf2.setPzh(pzh);
					hPzEntityjf2.setFlxh(flxh);
					// ------系统日期
					// String temp_strx = "";
					// Date dtx = new Date();
					// SimpleDateFormat sdfx = new
					// SimpleDateFormat("yyyy-MM-dd");
					temp_strx = sdfx.format(dtx);
					// -----
					if ("1".equals(ywpzEntity.getSfsxtpl())) {
						hPzEntityjf2.setPzrq(ywpzEntity.getMaxywrq());
					} else {
						hPzEntityjf2.setPzrq(temp_strx);
					}
					// hPzEntityjf2.setPzrq(resultwa.get(x).get(0).getDjrq());
					hPzEntityjf2.setFjzs(0);
					hPzEntityjf2.setZymc(ywpzEntity.getHPzEntities().get(j).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(j).getXqmc()
							+ ywpzEntity.getHPzEntities().get(j).getXmmc()
							+ ywpzEntity.getHPzEntities().get(j).getMphm()
							+ ywpzEntity.getHPzEntities().get(j).getXm());
					// -----
					String maxzybm1 = baseMapper.selectmaxzybm();
					String newzybm1 = "";
					if ("".equals(maxzybm1) || maxzybm1 == null) {
						newzybm1 = "0001";
					} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
						String aa = Integer.parseInt(maxzybm1) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm1 = result;
					}
					HZyEntity zy1 = new HZyEntity();
					zy1.setZybm(newzybm1);
					zy1.setZymc(ywpzEntity.getHPzEntities().get(j).getBillname() + "_"
							+ ywpzEntity.getHPzEntities().get(j).getXqmc()
							+ ywpzEntity.getHPzEntities().get(j).getXmmc()
							+ ywpzEntity.getHPzEntities().get(j).getMphm()
							+ ywpzEntity.getHPzEntities().get(j).getXm());
					zy1.setZtbm("0003");
					baseMapper.insertzy(zy1);
					// ----

					hPzEntityjf2.setKm(ywpzEntity.getHPzEntities().get(j).getYzkmdm());
					hPzEntityjf2.setJfje(0.0);
					hPzEntityjf2.setDfje(ywpzEntity.getHPzEntities().get(j).getJe());
					hPzEntityjf2.setSfsh("0");
					hPzEntityjf2.setSfjz("0");
					hPzEntityjf2.setLrfs("1");
					hPzEntityjf2.setYwlx(ywpzEntity.getHPzEntities().get(j).getJsfs());
					hPzEntityjf2.setYwbh(ywpzEntity.getHPzEntities().get(j).getZph());
					hPzEntityjf2.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str1 = "";
					Date dt1 = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str1 = sdf1.format(dt1);
					hPzEntityjf2.setZdsj(temp_str1);
					hPzEntityjf2.setZtbm("0003");
					hPzEntityjf2.setPztype("记账");
					hPzEntityjf2.setJzsj(temp_str1);
					hPzEntityjf2.setZdrmc(ywpzEntity.getZdrmc());
					baseMapper.inserthpzjf(hPzEntityjf2);
					hPzEntityjf2.setDjbh(ywpzEntity.getHPzEntities().get(j).getDjbh());
					// 改单据生成凭证之后将pzh记录在ywpz该pzh字段单据中
					baseMapper.updateywpzpzh(hPzEntityjf2);
				}
			}
		}
		return R.ok();
	}

	@Override
	public PageInfo<YwpzEntity> queryByPageGGSYFTPZ(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzEntity> ywHPzEntities = baseMapper.queryByPageGGSYFTPZ(ywpzEntity);
		// 1.获取每笔公共收益分摊的核算科目。
		for (int i = 0; i < ywHPzEntities.size(); i++) {
			// 获取该公共收益分摊的银行科目代码
			HKmEntity hKmEntitya = baseMapper.selectbymc(ywHPzEntities.get(i).getYhmc());
			// 设置该单据的银行核算科目
			ywHPzEntities.get(i).setYhkmdm(hKmEntitya.getKm() + "001");
			ywHPzEntities.get(i).setYhkmmc("活期存款");
		}
		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywHPzEntities);
		return pageInfo;
	}

	@Override
	public R insertGGSYFTPZSC(YwpzEntity ywpzEntity) {
		// 1.检查核算期间是否记账
		// HPzEntity h = baseMapper.selecthoprator(ywpzEntity.getZdrmc());
		// HPzEntity hh = baseMapper.selectsysuser(ywpzEntity.getZdrmc());
		// if (isObjectNotEmpty(hh) == false) {
		// return R.error("操作员不存在");
		// }
		// // 2.检查是否是主账套
		// HPzEntity h2 = baseMapper.selectzt(h.getZtbm());
		// if ("0".equals(h2.getSfzt())) {
		// return R.error("当前帐套不是主帐套,不能生成凭证!");
		// } else if ("1".equals(h2.getSfzt())) {
		//
		// }

		// 2.生成凭证号(取当前会计期间最大凭证号+1)：
		String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
		int pzh = 1;
		if ("".equals(maxpzh) || maxpzh == null) {
			pzh = 1;
		} else if (!"".equals(maxpzh) || maxpzh != null) {
			String aa = Integer.parseInt(maxpzh) + 1 + "";
			DecimalFormat df = new DecimalFormat("0");
			String result = df.format(Integer.parseInt(aa));
			pzh = Integer.parseInt(result);
		}
		int flxh = 1;
		// 1.遍历每一个勾选的业务单据
		for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
			// 1.每个业务单据生成两条凭证，一个银行借方凭证，一个公共收益分摊贷方凭证，凭证号相同，分录序号不同。

			for (int j = 0; j < 2; j++) {
				if (j == 0) {
					// a.先生成银行借方凭证
					HPzEntity hPzEntityjf = new HPzEntity();
					hPzEntityjf.setGzdbm("0001");
					hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf.setPzh(pzh);
					hPzEntityjf.setFlxh(flxh);
					hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(i).getDjrq());
					hPzEntityjf.setFjzs(0);
					if (ywpzEntity.getHPzEntities().get(i).getZph() != null
							|| !"".equals(ywpzEntity.getHPzEntities().get(i).getZph())) {
						hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "-"
								+ ywpzEntity.getHPzEntities().get(i).getZph());
						// -----
						String maxzybm1 = baseMapper.selectmaxzybm();
						String newzybm1 = "";
						if ("".equals(maxzybm1) || maxzybm1 == null) {
							newzybm1 = "0001";
						} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
							String aa = Integer.parseInt(maxzybm1) + 1 + "";
							DecimalFormat df = new DecimalFormat("0000");
							String result = df.format(Integer.parseInt(aa));
							newzybm1 = result;
						}
						HZyEntity zy1 = new HZyEntity();
						zy1.setZybm(newzybm1);
						zy1.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "-"
								+ ywpzEntity.getHPzEntities().get(i).getZph());
						zy1.setZtbm("0001");
						baseMapper.insertzy(zy1);
						// ----
					} else if (ywpzEntity.getHPzEntities().get(i).getZph() == null
							|| "".equals(ywpzEntity.getHPzEntities().get(i).getZph())) {
						hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname());
					}

					hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(i).getYhkmdm());
					hPzEntityjf.setJfje(ywpzEntity.getHPzEntities().get(i).getJe());
					hPzEntityjf.setDfje(0.0);
					hPzEntityjf.setSfsh("0");
					hPzEntityjf.setSfjz("0");
					hPzEntityjf.setLrfs("1");
					hPzEntityjf.setYwlx("04");
					if (ywpzEntity.getHPzEntities().get(i).getZph() != null
							|| !"".equals(ywpzEntity.getHPzEntities().get(i).getZph())) {
						hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(i).getZph());
					}

					hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str = "";
					Date dt = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str = sdf.format(dt);
					hPzEntityjf.setZdsj(temp_str);
					hPzEntityjf.setJzsj(temp_str);
					hPzEntityjf.setZtbm("0001");
					hPzEntityjf.setPztype("记账");
					hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
					baseMapper.inserthpzjf(hPzEntityjf);
					hPzEntityjf.setDjbh(ywpzEntity.getHPzEntities().get(i).getDjbh());
					// 改单据生成凭证之后将pzh记录在ywpz该pzh字段单据中
					baseMapper.updateywpzpzh(hPzEntityjf);
					flxh = flxh + 1;
				} else if (j == 1) {
					// b.再生成公共收益分摊贷方凭证
					HPzEntity hPzEntityjf = new HPzEntity();
					hPzEntityjf.setGzdbm("0001");
					hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
					hPzEntityjf.setPzh(pzh);
					hPzEntityjf.setFlxh(flxh);
					hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(i).getDjrq());
					hPzEntityjf.setFjzs(0);
					hPzEntityjf.setZymc("公共收益分摊");
					// -----
					String maxzybm1 = baseMapper.selectmaxzybm();
					String newzybm1 = "";
					if ("".equals(maxzybm1) || maxzybm1 == null) {
						newzybm1 = "0001";
					} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
						String aa = Integer.parseInt(maxzybm1) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm1 = result;
					}
					HZyEntity zy1 = new HZyEntity();
					zy1.setZybm(newzybm1);
					zy1.setZymc("公共收益分摊");
					zy1.setZtbm("0001");
					baseMapper.insertzy(zy1);
					// ----
					hPzEntityjf.setKm(ywpzEntity.getYhdm());// 科目下拉框银行科目代码字段
					hPzEntityjf.setJfje(0.0);
					hPzEntityjf.setDfje(ywpzEntity.getHPzEntities().get(i).getJe());
					hPzEntityjf.setSfsh("0");
					hPzEntityjf.setSfjz("0");
					hPzEntityjf.setLrfs("1");
					hPzEntityjf.setYwlx(ywpzEntity.getHPzEntities().get(i).getJsfs());
					if (ywpzEntity.getHPzEntities().get(i).getZph() != null
							|| !"".equals(ywpzEntity.getHPzEntities().get(i).getZph())) {
						hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(i).getZph());
					}

					hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
					String temp_str = "";
					Date dt = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str = sdf.format(dt);
					hPzEntityjf.setZdsj(temp_str);
					hPzEntityjf.setJzsj(temp_str);
					hPzEntityjf.setZtbm("0001");
					hPzEntityjf.setPztype("记账");
					hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
					baseMapper.inserthpzjf(hPzEntityjf);
					flxh = flxh + 1;
				}
			}

		}

		return R.ok();
	}

	@Override
	public List<HPzEntity> insertPZLR(YwpzEntity ywpzEntity) {
		// 3.生成凭证号(取当前会计期间最大凭证号+1)：
		// String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
		int pzh = 1;
		// ------------------------------------
		// 处理凭证号插空问题
		List<String> lpzhgs = baseMapper.selectkjqjpzhgs(ywpzEntity.getKjqj());// 查此会计期间有多少条pzh
		String maxpzhck = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());// 查此会计期间最大pzh
		if (lpzhgs.isEmpty()) {
			String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
			if ("".equals(maxpzh) || maxpzh == null) {
				pzh = 1;
			} else if (!"".equals(maxpzh) || maxpzh != null) {
				String aa = Integer.parseInt(maxpzh) + 1 + "";
				DecimalFormat df = new DecimalFormat("0");
				String result = df.format(Integer.parseInt(aa));
				pzh = Integer.parseInt(result);
			}
		} else {
			int maxPZH = Integer.parseInt(maxpzhck);
			if (maxPZH == lpzhgs.size()) {// 如果相等则表示该会计期间pzh没有断号，则按pzh+1规则来生成pzh
				String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
				if ("".equals(maxpzh) || maxpzh == null) {
					pzh = 1;
				} else if (!"".equals(maxpzh) || maxpzh != null) {
					String aa = Integer.parseInt(maxpzh) + 1 + "";
					DecimalFormat df = new DecimalFormat("0");
					String result = df.format(Integer.parseInt(aa));
					pzh = Integer.parseInt(result);
				}
			} else {// 不相等则表示存在断号，需先补漏，全部补完了不断号之后再按pzh+1规则来生成pzh
				for (int i = 1; i <= maxPZH; i++) {
					if (lpzhgs.contains(i + "")) {

					} else {
						pzh = i;
						break;
					}
				}
			}
		}

		// ------------------------------------
		int flxh = 1;
		// 1.遍历每一个勾选的业务单据
		for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
			if (ywpzEntity.getHPzEntities().get(i).getZymc() != null) {
				// 凭证号相同，分录序号不同。
				// 生成凭证
				HPzEntity hPzEntityjf = new HPzEntity();
				hPzEntityjf.setGzdbm("0001");
				hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
				hPzEntityjf.setPzh(pzh);
				hPzEntityjf.setFlxh(flxh);
				hPzEntityjf.setPzrq(ywpzEntity.getPzrq());// 凭证日期
				hPzEntityjf.setFjzs(ywpzEntity.getFjzs());
				hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(i).getZymc());
				HZyEntity z = baseMapper.selectzy(ywpzEntity.getHPzEntities().get(i).getZymc());
				// 如果录入的时候是新增的摘要（摘要表里没有的）则生成凭证的时候自动插入到摘要表
				if (isObjectNotEmpty(z) == false) {
					String maxzybm = baseMapper.selectmaxzybm();
					String newzybm = "";
					if ("".equals(maxzybm) || maxzybm == null) {
						newzybm = "0001";
					} else if (!"".equals(maxzybm) && maxzybm != null) {
						String aa = Integer.parseInt(maxzybm) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm = result;
					}
					HZyEntity zy = new HZyEntity();
					zy.setZybm(newzybm);
					zy.setZymc(ywpzEntity.getHPzEntities().get(i).getZymc());
					int res = ywpzEntity.getKjqj().compareTo("2020-12");
					if (res <= 0) {
						zy.setZtbm("0002");
					} else {
						zy.setZtbm("0003");
					}
					baseMapper.insertzy(zy);
				}
				hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(i).getYhkmdm());
				hPzEntityjf.setJfje(ywpzEntity.getHPzEntities().get(i).getJfje());
				hPzEntityjf.setDfje(ywpzEntity.getHPzEntities().get(i).getDfje());
				hPzEntityjf.setSfsh("0");
				hPzEntityjf.setSfjz("0");
				hPzEntityjf.setLrfs("0");
				// hPzEntityjf.setYwlx(ywpzEntity.getHPzEntities().get(i).getJsfs());
				// if (ywpzEntity.getHPzEntities().get(i).getZph() != null
				// || !"".equals(ywpzEntity.getHPzEntities().get(i).getZph())) {
				// hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(i).getZph());
				// }
				hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
				String temp_str = "";
				Date dt = new Date();
				// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				temp_str = sdf.format(dt);
				hPzEntityjf.setZdsj(temp_str);
				int res = ywpzEntity.getKjqj().compareTo("2020-12");
				if (res <= 0) {
					hPzEntityjf.setZtbm("0002");
				} else {
					hPzEntityjf.setZtbm("0003");
				}
				hPzEntityjf.setPztype("记账");
				hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
				// hPzEntityjf.setPjrq(temp_str);// 结算时间
				baseMapper.inserthpzjf(hPzEntityjf);
				flxh = flxh + 1;
			}

		}
		HPzEntity hd = new HPzEntity();
		hd.setKjqj(ywpzEntity.getKjqj());
		hd.setZtbm("0003");
		hd.setPzh(pzh);
		hd.setPzlrcx("00");
		List<HPzEntity> l = PZCXMSD(hd);

		return l;
	}

	@Override
	public PageInfo<HPzEntity> queryByPagePZCX(Integer pageNum, Integer pageSize, HPzEntity hPzEntity) {
		HPzEntity z = baseMapper.queryByPagePZCXHJ(hPzEntity);
		PageHelper.startPage(pageNum, pageSize);
		List<HPzEntity> hPzEntities = baseMapper.queryByPagePZCX(hPzEntity);
		hPzEntities.add(z);
		PageInfo<HPzEntity> pageInfo = new PageInfo<HPzEntity>(hPzEntities);
		return pageInfo;
	}

	@Override
	public R deletePZ(List<HPzEntity> hPzEntities) {
		for (HPzEntity hPzEntity : hPzEntities) {
			List<YwpzEntity> list = baseMapper.selectywdj(hPzEntity);
			if (list.isEmpty()) {

			} else {
				for (YwpzEntity y : list) {
					baseMapper.updateywpzpzhnull(y.getDjbh());
					YwpzEntity yo = baseMapper.selectfzhsmxdj(y.getDjbh());
					if (isObjectNotEmpty(yo) == true) {
						baseMapper.updatefzhsmxdj(yo.getDjbh());
					}
				}
			}
			if("已处理交存收入结转".equals(hPzEntity.getZymc())){
				baseMapper.deletePZ(hPzEntity);
				HKmyeEntity e=new HKmyeEntity();
				e.setZtbm(hPzEntity.getZtbm());
				e.setKjqj(hPzEntity.getKjqj());
				e.setJfje(hPzEntity.getJfje());
				e.setHskmdm("400101");
				baseMapper.updatekmyeqmjehtjf(e);
				HKmyeEntity e1=new HKmyeEntity();
				e1.setZtbm(hPzEntity.getZtbm());
				e1.setKjqj(hPzEntity.getKjqj());
				e1.setDfje(hPzEntity.getJfje());
				e1.setHskmdm("300101");
				baseMapper.updatekmyeqmjehtdf(e1);
			}else if("待处理交存收入结转".equals(hPzEntity.getZymc())){
				baseMapper.deletePZ(hPzEntity);
				HKmyeEntity e=new HKmyeEntity();
				e.setZtbm(hPzEntity.getZtbm());
				e.setKjqj(hPzEntity.getKjqj());
				e.setJfje(hPzEntity.getJfje());
				e.setHskmdm("400102");
				baseMapper.updatekmyeqmjehtjf(e);
				HKmyeEntity e1=new HKmyeEntity();
				e1.setZtbm(hPzEntity.getZtbm());
				e1.setKjqj(hPzEntity.getKjqj());
				e1.setDfje(hPzEntity.getJfje());
				e1.setHskmdm("300102");
				baseMapper.updatekmyeqmjehtdf(e1);
			}else if("维修支出结转".equals(hPzEntity.getZymc())){
				baseMapper.deletePZ(hPzEntity);
				HKmyeEntity e=new HKmyeEntity();
				e.setZtbm(hPzEntity.getZtbm());
				e.setKjqj(hPzEntity.getKjqj());
				e.setDfje(hPzEntity.getJfje());
				e.setHskmdm("5001");
				baseMapper.updatekmyeqmjehtdf(e);
				HKmyeEntity e1=new HKmyeEntity();
				e1.setZtbm(hPzEntity.getZtbm());
				e1.setKjqj(hPzEntity.getKjqj());
				e1.setJfje(hPzEntity.getJfje());
				e1.setHskmdm("300101");
				baseMapper.updatekmyeqmjehtjf(e1);
			}else if("返还支出结转".equals(hPzEntity.getZymc())){
				baseMapper.deletePZ(hPzEntity);
				HKmyeEntity e=new HKmyeEntity();
				e.setZtbm(hPzEntity.getZtbm());
				e.setKjqj(hPzEntity.getKjqj());
				e.setDfje(hPzEntity.getJfje());
				e.setHskmdm("5101");
				baseMapper.updatekmyeqmjehtdf(e);
				HKmyeEntity e1=new HKmyeEntity();
				e1.setZtbm(hPzEntity.getZtbm());
				e1.setKjqj(hPzEntity.getKjqj());
				e1.setJfje(hPzEntity.getJfje());
				e1.setHskmdm("300101");
				baseMapper.updatekmyeqmjehtjf(e1);
			}else{
				baseMapper.deletePZ(hPzEntity);
			}
			
		}
		return R.ok();
	}

	@Override
	public List<HPzEntity> PZHZCX(HPzEntity hPzEntity) {
		List<HPzEntity> list2 = new ArrayList<HPzEntity>();
		// 查凭证表中所有科目
		List<HPzEntity> list = baseMapper.selectkm3(hPzEntity);
		if ("0003".equals(hPzEntity.getZtbm())) {
			if (!list.isEmpty()) {
				double sumjfje1001 = 0;
				double sumdfje1001 = 0;
				// 汇总102银行存款借贷方金额
				for (int i = 0; i < list.size(); i++) {
					if ("1001".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() > 6) {
						sumjfje1001 = sumjfje1001 + list.get(i).getJfje();
						sumdfje1001 = sumdfje1001 + list.get(i).getDfje();
					}
				}
				HPzEntity h = new HPzEntity();
				h.setKm("1001");
				h.setKmmc("银行存款");
				h.setJfje(sumjfje1001);
				h.setDfje(sumdfje1001);
				list2.add(h);

				double sumjfje1012 = 0;
				double sumdfje1012 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("1012".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() == 4) {
						sumjfje1012 = sumjfje1012 + list.get(i).getJfje();
						sumdfje1012 = sumdfje1012 + list.get(i).getDfje();
					}
				}
				HPzEntity h2 = new HPzEntity();
				h2.setKm("1012");
				h2.setKmmc("其他应收款");
				h2.setJfje(sumjfje1012);
				h2.setDfje(sumdfje1012);
				list2.add(h2);

				double sumjfje1101 = 0;
				double sumdfje1101 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("1101".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() == 4) {
						sumjfje1101 = sumjfje1101 + list.get(i).getJfje();
						sumdfje1101 = sumdfje1101 + list.get(i).getDfje();
					}
				}
				HPzEntity h3 = new HPzEntity();
				h3.setKm("1101");
				h3.setKmmc("国债投资");
				h3.setJfje(sumjfje1101);
				h3.setDfje(sumdfje1101);
				list2.add(h3);

				double sumjfje1201 = 0;
				double sumdfje1201 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("1201".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() == 4) {
						sumjfje1201 = sumjfje1201 + list.get(i).getJfje();
						sumdfje1201 = sumdfje1201 + list.get(i).getDfje();
					}
				}
				HPzEntity h4 = new HPzEntity();
				h4.setKm("1201");
				h4.setKmmc("备用金");
				h4.setJfje(sumjfje1201);
				h4.setDfje(sumdfje1201);
				list2.add(h4);

				double sumjfje2001 = 0;
				double sumdfje2001 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("2001".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() == 4) {
						sumjfje2001 = sumjfje2001 + list.get(i).getJfje();
						sumdfje2001 = sumdfje2001 + list.get(i).getDfje();
					}
				}
				HPzEntity hp = new HPzEntity();
				hp.setKm("2001");
				hp.setKmmc("应付房屋灭失返还资金");
				hp.setJfje(sumjfje2001);
				hp.setDfje(sumdfje2001);
				list2.add(hp);

				double sumjfje3001 = 0;
				double sumdfje3001 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("3001".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() == 6) {
						sumjfje3001 = sumjfje3001 + list.get(i).getJfje();
						sumdfje3001 = sumdfje3001 + list.get(i).getDfje();
					}
				}
				HPzEntity h5 = new HPzEntity();
				h5.setKm("3001");
				h5.setKmmc("商品住宅维修资金");
				h5.setJfje(sumjfje3001);
				h5.setDfje(sumdfje3001);
				list2.add(h5);

				double sumjfje3002 = 0;
				double sumdfje3002 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("3002".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() == 4) {
						sumjfje3002 = sumjfje3002 + list.get(i).getJfje();
						sumdfje3002 = sumdfje3002 + list.get(i).getDfje();
					}
				}
				HPzEntity h6 = new HPzEntity();
				h6.setKm("3002");
				h6.setKmmc("已售公有住房维修资金");
				h6.setJfje(sumjfje3002);
				h6.setDfje(sumdfje3002);
				list2.add(h6);

				double sumjfje3101 = 0;
				double sumdfje3101 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("3101".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm()
							.length() == 4/*
											 * && !"401001".equals(list.get(i).
											 * getKm())
											 */) {
						sumjfje3101 = sumjfje3101 + list.get(i).getJfje();
						sumdfje3101 = sumdfje3101 + list.get(i).getDfje();
					}
				}
				HPzEntity h7 = new HPzEntity();
				h7.setKm("3101");
				h7.setKmmc("待分配累计收益");
				h7.setJfje(sumjfje3101);
				h7.setDfje(sumdfje3101);
				list2.add(h7);

				double sumjfje4001 = 0;
				double sumdfje4001 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("4001".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() == 6) {
						sumjfje4001 = sumjfje4001 + list.get(i).getJfje();
						sumdfje4001 = sumdfje4001 + list.get(i).getDfje();
					}
				}
				HPzEntity h8 = new HPzEntity();
				h8.setKm("4001");
				h8.setKmmc("交存收入");
				h8.setJfje(sumjfje4001);
				h8.setDfje(sumdfje4001);
				list2.add(h8);

				double sumjfje4101 = 0;
				double sumdfje4101 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("4101".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() == 4) {
						sumjfje4101 = sumjfje4101 + list.get(i).getJfje();
						sumdfje4101 = sumdfje4101 + list.get(i).getDfje();
					}
				}
				HPzEntity h9 = new HPzEntity();
				h9.setKm("4101");
				h9.setKmmc("存款利息收入");
				h9.setJfje(sumjfje4101);
				h9.setDfje(sumdfje4101);
				list2.add(h9);

				double sumjfje4102 = 0;
				double sumdfje4102 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("4102".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() == 4) {
						sumjfje4102 = sumjfje4102 + list.get(i).getJfje();
						sumdfje4102 = sumdfje4102 + list.get(i).getDfje();
					}
				}
				HPzEntity h10 = new HPzEntity();
				h10.setKm("4102");
				h10.setKmmc("国债利息收入");
				h10.setJfje(sumjfje4102);
				h10.setDfje(sumdfje4102);
				list2.add(h10);

				double sumjfje4201 = 0;
				double sumdfje4201 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("4201".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() == 4) {
						sumjfje4201 = sumjfje4201 + list.get(i).getJfje();
						sumdfje4201 = sumdfje4201 + list.get(i).getDfje();
					}
				}
				HPzEntity h11 = new HPzEntity();
				h11.setKm("4201");
				h11.setKmmc("经营收入");
				h11.setJfje(sumjfje4201);
				h11.setDfje(sumdfje4201);
				list2.add(h11);

				double sumjfje4301 = 0;
				double sumdfje4301 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("4301".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() == 4) {
						sumjfje4301 = sumjfje4301 + list.get(i).getJfje();
						sumdfje4301 = sumdfje4301 + list.get(i).getDfje();
					}
				}
				HPzEntity h12 = new HPzEntity();
				h12.setKm("4301");
				h12.setKmmc("共用设施处置收入");
				h12.setJfje(sumjfje4301);
				h12.setDfje(sumdfje4301);
				list2.add(h12);

				double sumjfje4901 = 0;
				double sumdfje4901 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("4901".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() == 4) {
						sumjfje4901 = sumjfje4901 + list.get(i).getJfje();
						sumdfje4901 = sumdfje4901 + list.get(i).getDfje();
					}
				}
				HPzEntity h13 = new HPzEntity();
				h13.setKm("4901");
				h13.setKmmc("其他收入");
				h13.setJfje(sumjfje4901);
				h13.setDfje(sumdfje4901);
				list2.add(h13);

				double sumjfje5001 = 0;
				double sumdfje5001 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("5001".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() == 4) {
						sumjfje5001 = sumjfje5001 + list.get(i).getJfje();
						sumdfje5001 = sumdfje5001 + list.get(i).getDfje();
					}
				}
				HPzEntity h14 = new HPzEntity();
				h14.setKm("5001");
				h14.setKmmc("维修支出");
				h14.setJfje(sumjfje5001);
				h14.setDfje(sumdfje5001);
				list2.add(h14);

				double sumjfje5101 = 0;
				double sumdfje5101 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("5101".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() == 4) {
						sumjfje5101 = sumjfje5101 + list.get(i).getJfje();
						sumdfje5101 = sumdfje5101 + list.get(i).getDfje();
					}
				}
				HPzEntity h15 = new HPzEntity();
				h15.setKm("5101");
				h15.setKmmc("返还支出");
				h15.setJfje(sumjfje5101);
				h15.setDfje(sumdfje5101);
				list2.add(h15);

				double sumjfje5901 = 0;
				double sumdfje5901 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("5901".equals(list.get(i).getKm().substring(0, 4)) && list.get(i).getKm().length() == 4) {
						sumjfje5901 = sumjfje5901 + list.get(i).getJfje();
						sumdfje5901 = sumdfje5901 + list.get(i).getDfje();
					}
				}
				HPzEntity h16 = new HPzEntity();
				h16.setKm("5901");
				h16.setKmmc("其他支出");
				h16.setJfje(sumjfje5901);
				h16.setDfje(sumdfje5901);
				list2.add(h16);
			}
		} else if ("0002".equals(hPzEntity.getZtbm())) {
			if (!list.isEmpty()) {
				double sumjfje101 = 0;
				double sumdfje101 = 0;
				// 汇总102银行存款借贷方金额
				for (int i = 0; i < list.size(); i++) {
					if ("101".equals(list.get(i).getKm().substring(0, 3)) && list.get(i).getKm().length() > 6) {
						sumjfje101 = sumjfje101 + list.get(i).getJfje();
						sumdfje101 = sumdfje101 + list.get(i).getDfje();
					}
				}
				HPzEntity h = new HPzEntity();
				h.setKm("101");
				h.setKmmc("银行存款");
				h.setJfje(sumjfje101);
				h.setDfje(sumdfje101);
				list2.add(h);

				double sumjfje201 = 0;
				double sumdfje201 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("201".equals(list.get(i).getKm().substring(0, 3)) && list.get(i).getKm().length() == 6) {
						sumjfje201 = sumjfje201 + list.get(i).getJfje();
						sumdfje201 = sumdfje201 + list.get(i).getDfje();
					}
				}
				HPzEntity h2 = new HPzEntity();
				h2.setKm("201");
				h2.setKmmc("商品住宅维修资金");
				h2.setJfje(sumjfje201);
				h2.setDfje(sumdfje201);
				list2.add(h2);

				double sumjfje211 = 0;
				double sumdfje211 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("211".equals(list.get(i).getKm().substring(0, 3)) && list.get(i).getKm().length() == 3) {
						sumjfje211 = sumjfje211 + list.get(i).getJfje();
						sumdfje211 = sumdfje211 + list.get(i).getDfje();
					}
				}
				HPzEntity h3 = new HPzEntity();
				h3.setKm("211");
				h3.setKmmc("专项应付款");
				h3.setJfje(sumjfje211);
				h3.setDfje(sumdfje211);
				list2.add(h3);

				double sumjfje212 = 0;
				double sumdfje212 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("212".equals(list.get(i).getKm().substring(0, 3)) && list.get(i).getKm().length() == 3) {
						sumjfje212 = sumjfje212 + list.get(i).getJfje();
						sumdfje212 = sumdfje212 + list.get(i).getDfje();
					}
				}
				HPzEntity h4 = new HPzEntity();
				h4.setKm("212");
				h4.setKmmc("其他应付款");
				h4.setJfje(sumjfje212);
				h4.setDfje(sumdfje212);
				list2.add(h4);

				double sumjfje112 = 0;
				double sumdfje112 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("112".equals(list.get(i).getKm().substring(0, 3)) && list.get(i).getKm().length() == 3) {
						sumjfje112 = sumjfje112 + list.get(i).getJfje();
						sumdfje112 = sumdfje112 + list.get(i).getDfje();
					}
				}
				HPzEntity hp = new HPzEntity();
				hp.setKm("112");
				hp.setKmmc("其他应收款");
				hp.setJfje(sumjfje112);
				hp.setDfje(sumdfje112);
				list2.add(hp);

				double sumjfje301 = 0;
				double sumdfje301 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("301".equals(list.get(i).getKm().substring(0, 3)) && list.get(i).getKm().length() == 3) {
						sumjfje301 = sumjfje301 + list.get(i).getJfje();
						sumdfje301 = sumdfje301 + list.get(i).getDfje();
					}
				}
				HPzEntity h5 = new HPzEntity();
				h5.setKm("301");
				h5.setKmmc("增值收益");
				h5.setJfje(sumjfje301);
				h5.setDfje(sumdfje301);
				list2.add(h5);

				double sumjfje311 = 0;
				double sumdfje311 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("311".equals(list.get(i).getKm().substring(0, 3)) && list.get(i).getKm().length() == 6) {
						sumjfje311 = sumjfje311 + list.get(i).getJfje();
						sumdfje311 = sumdfje311 + list.get(i).getDfje();
					}
				}
				HPzEntity h6 = new HPzEntity();
				h6.setKm("311");
				h6.setKmmc("增值收益分配");
				h6.setJfje(sumjfje311);
				h6.setDfje(sumdfje311);
				list2.add(h6);

				double sumjfje401 = 0;
				double sumdfje401 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("401".equals(list.get(i).getKm().substring(0, 3)) && list.get(i).getKm()
							.length() >= 6/*
											 * && !"401001".equals(list.get(i).
											 * getKm())
											 */) {
						sumjfje401 = sumjfje401 + list.get(i).getJfje();
						sumdfje401 = sumdfje401 + list.get(i).getDfje();
					}
				}
				HPzEntity h7 = new HPzEntity();
				h7.setKm("401");
				h7.setKmmc("业务收入");
				h7.setJfje(sumjfje401);
				h7.setDfje(sumdfje401);
				list2.add(h7);

				double sumjfje411 = 0;
				double sumdfje411 = 0;
				for (int i = 0; i < list.size(); i++) {
					if ("411".equals(list.get(i).getKm().substring(0, 3)) && list.get(i).getKm().length() == 6) {
						sumjfje411 = sumjfje411 + list.get(i).getJfje();
						sumdfje411 = sumdfje411 + list.get(i).getDfje();
					}
				}
				HPzEntity h8 = new HPzEntity();
				h8.setKm("411");
				h8.setKmmc("业务支出");
				h8.setJfje(sumjfje411);
				h8.setDfje(sumdfje411);
				list2.add(h8);
			}
		}

		HPzEntity zpzs = new HPzEntity();
		List<HPzEntity> hzpzhfjs = baseMapper.selectpzzsfjhz(hPzEntity);
		if (!hzpzhfjs.isEmpty()) {
			zpzs.setZpzzs(hzpzhfjs.size());
			int zuixiao = hzpzhfjs.get(0).getPzh();
			zpzs.setZxpzh(zuixiao);
			zpzs.setZdpzh(hzpzhfjs.get(hzpzhfjs.size() - 1).getPzh());
			List<HPzEntity> fjs = baseMapper.selectfjhz(hPzEntity);
			int sumfjzs = 0;
			for (HPzEntity fj : fjs) {
				sumfjzs = sumfjzs + fj.getFjzs();
			}
			zpzs.setZfjzs(sumfjzs);
		}
		list2.add(zpzs);
		return list2;
	}

	@Override
	public PageInfo<HPzEntity> queryByPagePZSH(Integer pageNum, Integer pageSize, HPzEntity hPzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<HPzEntity> hPzEntities = baseMapper.queryByPagePZSH(hPzEntity);
		PageInfo<HPzEntity> pageInfo = new PageInfo<HPzEntity>(hPzEntities);
		return pageInfo;
	}

	@Override
	public List<HPzEntity> PZSHXQ(HPzEntity hPzEntity) {

		List<HPzEntity> listj = baseMapper.selectPZSHXQj(hPzEntity);
		List<HPzEntity> listd = baseMapper.selectPZSHXQd(hPzEntity);
		List<HPzEntity> list2 = new ArrayList<HPzEntity>();
		Double sumj = 0.0;
		for (HPzEntity q : listj) {
			list2.add(q);
			sumj = sumj + q.getJfje();
		}
		for (HPzEntity w : listd) {
			list2.add(w);
		}
		int card = new Double(sumj).intValue();
		String a = Integer.toString(card);
		HPzEntity dx = new HPzEntity();
		if ("-".equals(a.substring(0, 1))) {
			dx.setJedx(MoneyUtil.toChinese(a.substring(1)));
		} else {
			dx.setJedx(MoneyUtil.toChinese(a));
		}
		list2.add(dx);
		return list2;
	}

	@Override
	public R PZSH(YwpzEntity ywpzEntity) {
		// 1.检查操作员是否存在
		// HPzEntity h = baseMapper.selecthoprator(ywpzEntity.getZdrmc());//
		// 通过当前用户查operator操作员表查询该用户是否存在（顺便查询ztbm）。
		// HPzEntity hh = baseMapper.selectsysuser(ywpzEntity.getZdrmc());
		// if (isObjectNotEmpty(hh) == false) {
		// return R.error("操作员不存在");
		// }
		for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
			// 2.审核人与制单人不能相同
			if (ywpzEntity.getZdrmc().equals(ywpzEntity.getHPzEntities().get(i).getZdrmc())) {
				return R.error("审核人与制单人相同，无法审核");
			} // 3.每个凭证号借方金额与贷方金额必须相等
				// else if (ywpzEntity.getHPzEntities().get(i).getJfje() !=
				// ywpzEntity.getHPzEntities().get(i).getDfje()) {
				// return R.error("每个凭证的借方金额与贷方金额必须相等才能审核");
				// }
				// 4.满足上面的判断，接下来对未审核的凭证进行审核
			ywpzEntity.getHPzEntities().get(i).setShrbm(ywpzEntity.getZdrbm());// 设置审核人编码
			ywpzEntity.getHPzEntities().get(i).setShrmc(ywpzEntity.getZdrmc());// 设置审核人
			ywpzEntity.getHPzEntities().get(i).setSfsh("1");// 设置审核状态
			String temp_str = "";
			Date dt = new Date();
			// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			temp_str = sdf.format(dt);
			ywpzEntity.getHPzEntities().get(i).setShsj(temp_str);// 设置审核时间
			baseMapper.updatePZSH(ywpzEntity.getHPzEntities().get(i));
		}
		return R.ok();
	}

	@Override
	public PageInfo<HPzEntity> queryByPagePZJZ(Integer pageNum, Integer pageSize, HPzEntity hPzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<HPzEntity> w = baseMapper.queryByPagePZWJZ(hPzEntity);
		List<HPzEntity> y = baseMapper.queryByPagePZYJZ(hPzEntity);
		List<HPzEntity> hPzEntities = new ArrayList<HPzEntity>();
		for (HPzEntity a : w) {
			hPzEntities.add(a);
		}
		for (HPzEntity b : y) {
			hPzEntities.add(b);
		}
		for (HPzEntity p1 : hPzEntities) {
			String ljkjqj = "2016-03";// 会计期间是小于或等于2016-03就是老系统凭证
			String pzkjqj = p1.getKjqj();
			int res = pzkjqj.compareTo(ljkjqj);
			if (res > 0) {// 则不是老系统凭证
				p1.setSflpz("0");
			} else {
				p1.setSflpz("1");
			}
		}
		PageInfo<HPzEntity> pageInfo = new PageInfo<HPzEntity>(hPzEntities);
		return pageInfo;
	}

	@Override
	public R PZQXSH(YwpzEntity ywpzEntity) {
		for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
			// 1.判断该凭证审核人与当前操作员是否一致
			// if
			// (!ywpzEntity.getZdrmc().equals(ywpzEntity.getHPzEntities().get(i).getShrmc()))
			// {
			// return R.error("审核人与当前操作员不相同！不能取消审核！");
			// }
			// 2.将已审核的凭证进行取消
			ywpzEntity.getHPzEntities().get(i).setShrbm("");
			ywpzEntity.getHPzEntities().get(i).setShrmc("");
			ywpzEntity.getHPzEntities().get(i).setSfsh("0");
			ywpzEntity.getHPzEntities().get(i).setShsj("");
			baseMapper.updatePZSH(ywpzEntity.getHPzEntities().get(i));
		}
		return R.ok();
	}

	@Override
	public R PZJZ(YwpzEntity ywpzEntity) {
		// 1.检查操作员是否存在
		// HPzEntity h = baseMapper.selecthoprator(ywpzEntity.getZdrmc());//
		// 通过当前用户查operator操作员表查询该用户是否存在（顺便查询ztbm）。
		// HPzEntity hh = baseMapper.selectsysuser(ywpzEntity.getZdrmc());
		// if (isObjectNotEmpty(hh) == false) {
		// return R.error("操作员不存在");
		// }
		for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
			// 2.凭证记账
			ywpzEntity.getHPzEntities().get(i).setJzrbm(ywpzEntity.getZdrbm());// 设置记账人编码
			ywpzEntity.getHPzEntities().get(i).setJzrmc(ywpzEntity.getZdrmc());// 设置记账人
			ywpzEntity.getHPzEntities().get(i).setSfjz("1");// 设置记账状态
			String temp_str = "";
			Date dt = new Date();
			// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			temp_str = sdf.format(dt);
			ywpzEntity.getHPzEntities().get(i).setJzsj(temp_str);// 设置记账时间
			baseMapper.updatePZJZ(ywpzEntity.getHPzEntities().get(i));
		}
		return R.ok();
	}

	@Override
	public R PZQXJZ(YwpzEntity ywpzEntity) {
		System.out.println("11111");
		for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
			// 1.判断当前操作人与该凭证的记账人是否一致
			// if
			// (!ywpzEntity.getZdrmc().equals(ywpzEntity.getHPzEntities().get(i).getJzrmc()))
			// {
			// return R.error("当前操作人与该凭证的记账人不相同！不能取消记账！");
			// }
			// 2.将已记账的凭证进行取消
			ywpzEntity.getHPzEntities().get(i).setJzrbm("");
			ywpzEntity.getHPzEntities().get(i).setJzrmc("");
			ywpzEntity.getHPzEntities().get(i).setSfjz("0");
			ywpzEntity.getHPzEntities().get(i).setJzsj("");
			baseMapper.updatePZJZ(ywpzEntity.getHPzEntities().get(i));
		}
		return R.ok();
	}

	@Override
	public List<HPzEntity> PZCXMSD(HPzEntity hPzEntity) {
		String ljkjqj = "2020-12";//
		String pzkjqj = hPzEntity.getKjqj();
		int res = pzkjqj.compareTo(ljkjqj);
		if (res > 0) {// 则不是老系统凭证
			hPzEntity.setZtbm("0003");
		} else {
			hPzEntity.setZtbm("0002");
		}
		List<HPzEntity> list2 = new ArrayList<HPzEntity>();
		// pzlrcx：00(表示不点那四个按钮（首张，上张，下张，末张）直接点查询)，01表示查首张，02表示查上张，03表示查下张,04表示查末张,05默认进来
		if ("00".equals(hPzEntity.getPzlrcx())) {
			// 表示直接点查询，此处不做任何处理
			int count = baseMapper.selectkjqjpzhsfcz(hPzEntity);
			List<HPzEntity> listj = baseMapper.selectPZSHXQj(hPzEntity);
			List<HPzEntity> listd = baseMapper.selectPZSHXQd(hPzEntity);
			Double sumj = 0.0;
			for (HPzEntity q : listj) {
				list2.add(q);
				sumj = sumj + q.getJfje();
			}
			for (HPzEntity w : listd) {
				list2.add(w);
			}
			// String a = sumj.toString();
			int card = new Double(sumj).intValue();
			String a = Integer.toString(card);
			HPzEntity dx = new HPzEntity();
			if ("-".equals(a.substring(0, 1))) {
				dx.setJedx(MoneyUtil.toChinese(a.substring(1)));
			} else {
				dx.setJedx(MoneyUtil.toChinese(a));
			}
			// int minpzh=baseMapper.selectMINpzh(hPzEntity);
			String minpzh2 = baseMapper.selectMINpzh2(hPzEntity);
			String MAXpzh = baseMapper.selectmaxpzh(hPzEntity.getKjqj());
			if (!"".equals(minpzh2) && minpzh2 != null && MAXpzh != null && !"".equals(MAXpzh)) {
				if (hPzEntity.getPzh() == Integer.parseInt(minpzh2) && hPzEntity.getPzh() == Integer.parseInt(MAXpzh)) {
					dx.setSz("1");
					dx.setMz("1");
				} else if (hPzEntity.getPzh() != Integer.parseInt(minpzh2)
						&& hPzEntity.getPzh() != Integer.parseInt(MAXpzh)) {
					dx.setSz("0");
					dx.setMz("0");
				} else if (hPzEntity.getPzh() == Integer.parseInt(minpzh2)
						&& hPzEntity.getPzh() != Integer.parseInt(MAXpzh)) {
					dx.setSz("1");
					dx.setMz("0");
				} else if (hPzEntity.getPzh() != Integer.parseInt(minpzh2)
						&& hPzEntity.getPzh() == Integer.parseInt(MAXpzh)) {
					dx.setSz("0");
					dx.setMz("1");
				}
			}
			if (count == 0) {
				dx.setSfypz("0");
			} else if (count != 0) {
				dx.setSfypz("1");
			}
			list2.add(dx);
		} else if ("01".equals(hPzEntity.getPzlrcx())) {// 查首张
			// 表示查首张，则查次会计期间最小的凭证号
			int MINpzh = baseMapper.selectMINpzh(hPzEntity);
			hPzEntity.setPzh(MINpzh);
			List<HPzEntity> listj = baseMapper.selectPZSHXQj(hPzEntity);
			List<HPzEntity> listd = baseMapper.selectPZSHXQd(hPzEntity);
			Double sumj = 0.0;
			for (HPzEntity q : listj) {
				list2.add(q);
				sumj = sumj + q.getJfje();
			}
			for (HPzEntity w : listd) {
				list2.add(w);
			}
			// String a = sumj.toString();
			int card = new Double(sumj).intValue();
			String a = Integer.toString(card);
			HPzEntity dx = new HPzEntity();
			if ("-".equals(a.substring(0, 1))) {
				dx.setJedx(MoneyUtil.toChinese(a.substring(1)));
			} else {
				dx.setJedx(MoneyUtil.toChinese(a));
			}
			int minpzh = baseMapper.selectMINpzh(hPzEntity);
			String MAXpzh = baseMapper.selectmaxpzh(hPzEntity.getKjqj());
			if (hPzEntity.getPzh() == minpzh && hPzEntity.getPzh() == Integer.parseInt(MAXpzh)) {
				dx.setSz("1");
				dx.setMz("1");
			} else if (hPzEntity.getPzh() != minpzh && hPzEntity.getPzh() != Integer.parseInt(MAXpzh)) {
				dx.setSz("0");
				dx.setMz("0");
			} else if (hPzEntity.getPzh() == minpzh && hPzEntity.getPzh() != Integer.parseInt(MAXpzh)) {
				dx.setSz("1");
				dx.setMz("0");
			} else if (hPzEntity.getPzh() != minpzh && hPzEntity.getPzh() == Integer.parseInt(MAXpzh)) {
				dx.setSz("0");
				dx.setMz("1");
			}
			list2.add(dx);
		} else if ("02".equals(hPzEntity.getPzlrcx())) {// 查上张
			// 先查此会计期间的所有凭证号
			List<String> pzhlist = baseMapper.selectallpzh(hPzEntity);
			for (int i = 0; i < pzhlist.size(); i++) {
				if (hPzEntity.getPzh() == Integer.parseInt(pzhlist.get(i))) {
					hPzEntity.setPzh(Integer.parseInt(pzhlist.get(i - 1)));
					break;
				}
			}
			List<HPzEntity> listj = baseMapper.selectPZSHXQj(hPzEntity);
			List<HPzEntity> listd = baseMapper.selectPZSHXQd(hPzEntity);
			Double sumj = 0.0;
			for (HPzEntity q : listj) {
				list2.add(q);
				sumj = sumj + q.getJfje();
			}
			for (HPzEntity w : listd) {
				list2.add(w);
			}
			// String a = sumj.toString();
			int card = new Double(sumj).intValue();
			String a = Integer.toString(card);
			HPzEntity dx = new HPzEntity();
			if ("-".equals(a.substring(0, 1))) {
				dx.setJedx(MoneyUtil.toChinese(a.substring(1)));
			} else {
				dx.setJedx(MoneyUtil.toChinese(a));
			}
			int minpzh = baseMapper.selectMINpzh(hPzEntity);
			String MAXpzh = baseMapper.selectmaxpzh(hPzEntity.getKjqj());
			if (hPzEntity.getPzh() == minpzh && hPzEntity.getPzh() == Integer.parseInt(MAXpzh)) {
				dx.setSz("1");
				dx.setMz("1");
			} else if (hPzEntity.getPzh() != minpzh && hPzEntity.getPzh() != Integer.parseInt(MAXpzh)) {
				dx.setSz("0");
				dx.setMz("0");
			} else if (hPzEntity.getPzh() == minpzh && hPzEntity.getPzh() != Integer.parseInt(MAXpzh)) {
				dx.setSz("1");
				dx.setMz("0");
			} else if (hPzEntity.getPzh() != minpzh && hPzEntity.getPzh() == Integer.parseInt(MAXpzh)) {
				dx.setSz("0");
				dx.setMz("1");
			}
			list2.add(dx);
		} else if ("03".equals(hPzEntity.getPzlrcx())) {// 查下张
			// 先查此会计期间的所有凭证号
			List<String> pzhlist = baseMapper.selectallpzh(hPzEntity);
			for (int i = 0; i < pzhlist.size(); i++) {
				if (hPzEntity.getPzh() == Integer.parseInt(pzhlist.get(i))) {
					hPzEntity.setPzh(Integer.parseInt(pzhlist.get(i + 1)));
					break;
				}
			}
			List<HPzEntity> listj = baseMapper.selectPZSHXQj(hPzEntity);
			List<HPzEntity> listd = baseMapper.selectPZSHXQd(hPzEntity);
			Double sumj = 0.0;
			for (HPzEntity q : listj) {
				list2.add(q);
				sumj = sumj + q.getJfje();
			}
			for (HPzEntity w : listd) {
				list2.add(w);
			}
			// String a = sumj.toString();
			int card = new Double(sumj).intValue();
			String a = Integer.toString(card);
			HPzEntity dx = new HPzEntity();
			if ("-".equals(a.substring(0, 1))) {
				dx.setJedx(MoneyUtil.toChinese(a.substring(1)));
			} else {
				dx.setJedx(MoneyUtil.toChinese(a));
			}
			int minpzh = baseMapper.selectMINpzh(hPzEntity);
			String MAXpzh = baseMapper.selectmaxpzh(hPzEntity.getKjqj());
			if (hPzEntity.getPzh() == minpzh && hPzEntity.getPzh() == Integer.parseInt(MAXpzh)) {
				dx.setSz("1");
				dx.setMz("1");
			} else if (hPzEntity.getPzh() != minpzh && hPzEntity.getPzh() != Integer.parseInt(MAXpzh)) {
				dx.setSz("0");
				dx.setMz("0");
			} else if (hPzEntity.getPzh() == minpzh && hPzEntity.getPzh() != Integer.parseInt(MAXpzh)) {
				dx.setSz("1");
				dx.setMz("0");
			} else if (hPzEntity.getPzh() != minpzh && hPzEntity.getPzh() == Integer.parseInt(MAXpzh)) {
				dx.setSz("0");
				dx.setMz("1");
			}
			list2.add(dx);
		} else if ("04".equals(hPzEntity.getPzlrcx())) {// 查末张
			String MAXpzh = baseMapper.selectmaxpzh(hPzEntity.getKjqj());
			hPzEntity.setPzh(Integer.parseInt(MAXpzh));
			List<HPzEntity> listj = baseMapper.selectPZSHXQj(hPzEntity);
			List<HPzEntity> listd = baseMapper.selectPZSHXQd(hPzEntity);
			Double sumj = 0.0;
			for (HPzEntity q : listj) {
				list2.add(q);
				sumj = sumj + q.getJfje();
			}
			for (HPzEntity w : listd) {
				list2.add(w);
			}
			// String a = sumj.toString();
			int card = new Double(sumj).intValue();
			String a = Integer.toString(card);
			HPzEntity dx = new HPzEntity();
			if ("-".equals(a.substring(0, 1))) {
				dx.setJedx(MoneyUtil.toChinese(a.substring(1)));
			} else {
				dx.setJedx(MoneyUtil.toChinese(a));
			}
			int minpzh = baseMapper.selectMINpzh(hPzEntity);
			// String MAXpzh=baseMapper.selectmaxpzh(hPzEntity.getKjqj());
			if (hPzEntity.getPzh() == minpzh && hPzEntity.getPzh() == Integer.parseInt(MAXpzh)) {
				dx.setSz("1");
				dx.setMz("1");
			} else if (hPzEntity.getPzh() != minpzh && hPzEntity.getPzh() != Integer.parseInt(MAXpzh)) {
				dx.setSz("0");
				dx.setMz("0");
			} else if (hPzEntity.getPzh() == minpzh && hPzEntity.getPzh() != Integer.parseInt(MAXpzh)) {
				dx.setSz("1");
				dx.setMz("0");
			} else if (hPzEntity.getPzh() != minpzh && hPzEntity.getPzh() == Integer.parseInt(MAXpzh)) {
				dx.setSz("0");
				dx.setMz("1");
			}
			list2.add(dx);
		} else if ("05".equals(hPzEntity.getPzlrcx())) {
			int count = baseMapper.selectkjqjpzhsfcz(hPzEntity);
			HPzEntity dx = new HPzEntity();
			if (count == 0) {
				dx.setSfypz("0");
			} else {
				dx.setSfypz("1");
			}
			list2.add(dx);
		}

		return list2;
	}

	@Override
	public PageInfo<YwpzEntity> queryByPagePZCZ(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzEntity> ywpzEntities = new ArrayList<YwpzEntity>();
		if ("01".equals(ywpzEntity.getDjlx()) || "03".equals(ywpzEntity.getDjlx())
				|| "04".equals(ywpzEntity.getDjlx())) {
			ywpzEntities = baseMapper.queryByPagePZCZ(ywpzEntity);
		} else if ("02".equals(ywpzEntity.getDjlx())) {
			ywpzEntities = baseMapper.queryByPagePZCZ2(ywpzEntity);
		} else {
			ywpzEntities = baseMapper.queryByPagePZCZ3(ywpzEntity);
		}
		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywpzEntities);
		return pageInfo;
	}

	@Override
	public YwpzEntity selectdw(String id) {

		return baseMapper.selectdw(id);
	}

	@Override
	public YwpzEntity selectdwzck(String id) {

		return baseMapper.selectdwzck(id);
	}

	@Override
	public void PZHCZ(HPzEntity hPzEntity) {

		List<HPzEntity> list = baseMapper.selectpzh(hPzEntity);
		int newpzh = 1;
		for (HPzEntity h : list) {
			if (h.getPzh() == newpzh) {
				newpzh = newpzh + 1;
			} else {
				// 1.重整之前通过旧的凭证号和会计期间从ywpz中找到相对应的业务单据
				List<YwpzEntity> y = baseMapper.selectywdj(h);
				if (y.isEmpty()) {
					// 为空则表示没有对应的业务单据，该pzh为手工录入的凭证。
				} else {
					for (YwpzEntity y1 : y) {
						// 2.更新修改后的凭证号。
						h.setDjbh(y1.getDjbh());
						h.setNewpzh(newpzh);
						baseMapper.updatedjpzh(h);
					}
				}
				// 3.重整凭证号，让此会计期间的凭证号连续，不能间断。
				h.setNewpzh(newpzh);
				baseMapper.updatepzpzh(h);
				newpzh = newpzh + 1;
			}
		}

	}

	@Override
	public void PZRQGSGB() {// 将原始数据凭证表里的日期格式转换为新系统的日期格式脚本方法
		// 查询凭证表中原始数据所有的记录
		List<HPzEntity> list = baseMapper.selectyspz();
		// 遍历修改日期格式
		for (HPzEntity h : list) {
			baseMapper.updaterqgs(h);
		}
	}

	@Override
	public PageInfo<YwpzEntity> queryByPageZQPZSC(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzEntity> ywpzEntities = new ArrayList<YwpzEntity>();
		List<YwpzEntity> ywpzEntitiesSCBF = baseMapper.queryByPageZQPZSC(ywpzEntity);
		List<YwpzEntity> ywpzEntitiesYEBF = baseMapper.queryByPageZQPZSC2(ywpzEntity);

		for (YwpzEntity y : ywpzEntitiesSCBF) {
			String djrq = y.getDjrq();
			String gdrq = "2020-12-31";// 切换新旧科目的临界日期
			int res = djrq.compareTo(gdrq);
			if (res <= 0) {// 用2021以前市局科目
				y.setZtbm("0002");
				// 1.借方科目：
				y.setKfskmdm("201003");
				y.setKfskmdmmc("商品住宅维修资金-使用");
				// 2.贷方科目
				// 获取银行科目代码
				HKmEntity hKmEntitya = baseMapper.selectbymc2(y.getYhmc());
				// 设置该单据的银行核算科目
				y.setYhkmdm(hKmEntitya.getKm() + "001");
				ywpzEntities.add(y);
			} else if (res > 0) {// 2021以后科目
				y.setZtbm("0003");
				// 1.借方科目：
				y.setKfskmdm("5001");
				y.setKfskmdmmc("维修支出");
				// 2.贷方科目
				// 获取银行科目代码
				HKmEntity hKmEntitya = baseMapper.selectbymc22(y.getYhmc());
				// 设置该单据的银行核算科目
				y.setYhkmdm(hKmEntitya.getKm() + "01");
				ywpzEntities.add(y);
			}

		}
		for (YwpzEntity y : ywpzEntitiesYEBF) {
			String djrq = y.getDjrq();
			String gdrq = "2020-12-31";// 切换新旧科目的临界日期
			int res = djrq.compareTo(gdrq);
			if (res <= 0) {// 用2021以前市局科目
				y.setZtbm("0002");
				// 1.借方科目：
				y.setKfskmdm("201003");
				y.setKfskmdmmc("商品住宅维修资金-使用");
				// 2.贷方科目
				// 获取银行科目代码
				HKmEntity hKmEntitya = baseMapper.selectbymc2(y.getYhmc());
				// 设置该单据的银行核算科目
				y.setYhkmdm(hKmEntitya.getKm() + "001");
				ywpzEntities.add(y);
			} else if (res > 0) {// 2021以后科目
				y.setZtbm("0003");
				// 1.借方科目：
				y.setKfskmdm("5001");
				y.setKfskmdmmc("维修支出");
				// 2.贷方科目
				// 获取银行科目代码
				HKmEntity hKmEntitya = baseMapper.selectbymc22(y.getYhmc());
				// 设置该单据的银行核算科目
				y.setYhkmdm(hKmEntitya.getKm() + "01");
				ywpzEntities.add(y);
			}
		}

		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywpzEntities);
		return pageInfo;
	}

	@Override
	public R insertZQPZSC(YwpzEntity ywpzEntity) {
		String djrq = ywpzEntity.getKjqj();
		String gdrq = "2020-12";// 切换新旧科目的临界日期
		int res = djrq.compareTo(gdrq);
		String ztbm = "0002";
		if (res > 0) {// 用2021以前市局科目
			ztbm = "0003";
		}
		List<HPzEntity> hPzEntities = ywpzEntity.getHPzEntities();
		if (0 == ywpzEntity.getSfhbfl()) {// 不合并分录
			// 支取凭证都是一条一条生成的，也不存在合并分录这一说法，都是一条单据生成一个凭证号，对应两条分录，先借后贷。
			// 1.生成凭证号(取当前会计期间最大凭证号+1)：
			int pzh = 1;
			// ------------------------------------
			// 处理凭证号插空问题
			List<String> lpzhgs = baseMapper.selectkjqjpzhgs(ywpzEntity.getKjqj());// 查此会计期间有多少条pzh
			String maxpzhck = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());// 查此会计期间最大pzh
			if (lpzhgs.isEmpty()) {
				String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
				if ("".equals(maxpzh) || maxpzh == null) {
					pzh = 1;
				} else if (!"".equals(maxpzh) || maxpzh != null) {
					String aa = Integer.parseInt(maxpzh) + 1 + "";
					DecimalFormat df = new DecimalFormat("0");
					String result = df.format(Integer.parseInt(aa));
					pzh = Integer.parseInt(result);
				}
			} else {
				int maxPZH = Integer.parseInt(maxpzhck);
				if (maxPZH == lpzhgs.size()) {// 如果相等则表示该会计期间pzh没有断号，则按pzh+1规则来生成pzh
					String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
					if ("".equals(maxpzh) || maxpzh == null) {
						pzh = 1;
					} else if (!"".equals(maxpzh) || maxpzh != null) {
						String aa = Integer.parseInt(maxpzh) + 1 + "";
						DecimalFormat df = new DecimalFormat("0");
						String result = df.format(Integer.parseInt(aa));
						pzh = Integer.parseInt(result);
					}
				} else {// 不相等则表示存在断号，需先补漏，全部补完了不断号之后再按pzh+1规则来生成pzh
					for (int i = 1; i <= maxPZH; i++) {
						if (lpzhgs.contains(i + "")) {

						} else {
							pzh = i;
							break;
						}
					}
				}
			}

			// ------------------------------------
			int flxh = 1;
			for (int i = 0; i < hPzEntities.size(); i++) {
				// a.先生成借方凭证
				HPzEntity hPzEntityjf = new HPzEntity();
				hPzEntityjf.setGzdbm("0001");
				hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
				hPzEntityjf.setPzh(pzh);
				hPzEntityjf.setFlxh(flxh);
				// ------系统日期
				String temp_strx = "";
				Date dtx = new Date();
				SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
				temp_strx = sdfx.format(dtx);
				HPzEntity hPzEntity = hPzEntities.get(i);
				hPzEntityjf.setPzrq(hPzEntity.getDjrq());
				hPzEntityjf.setFjzs(0);
				String zymc = hPzEntity.getWxbw();
				hPzEntityjf.setZymc(zymc);
				// -----
				String maxzybm = baseMapper.selectmaxzybm();
				String newzybm = "";
				if ("".equals(maxzybm) || maxzybm == null) {
					newzybm = "0001";
				} else if (!"".equals(maxzybm) && maxzybm != null) {
					String aa = Integer.parseInt(maxzybm) + 1 + "";
					DecimalFormat df = new DecimalFormat("0000");
					String result = df.format(Integer.parseInt(aa));
					newzybm = result;
				}
				HZyEntity zy = new HZyEntity();
				zy.setZybm(newzybm);
				zy.setZymc(zymc);
				zy.setZtbm(ztbm);
				baseMapper.insertzy(zy);
				// -------
				hPzEntityjf.setKm(hPzEntity.getKfskmdm());
				hPzEntityjf.setJfje(hPzEntity.getJe());
				hPzEntityjf.setDfje(0.0);
				hPzEntityjf.setSfsh("0");
				hPzEntityjf.setSfjz("0");
				hPzEntityjf.setLrfs("1");
				hPzEntityjf.setYwlx(hPzEntity.getDjlx());
				hPzEntityjf.setYwbh(hPzEntity.getZph());
				hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
				String temp_str = "";
				Date dt = new Date();
				// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				temp_str = sdf.format(dt);
				hPzEntityjf.setZdsj(temp_str);
				hPzEntityjf.setZtbm(ztbm);
				hPzEntityjf.setPztype("记账");
				hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
				hPzEntityjf.setJzsj(temp_str);
				baseMapper.inserthpzjf(hPzEntityjf);
				hPzEntityjf.setDjbh(hPzEntity.getDjbh());
				// 改单据生成凭证之后将pzh记录在ywpz该pzh字段单据中
				baseMapper.updateywpzpzh(hPzEntityjf);
				flxh = flxh + 1;

				// // 单位凭证生成的时候，将辅助核算明细中该单据的pzh和cwkjqj刷进去
				 baseMapper.updatefzhsmxdw(hPzEntityjf);
			}
			for (int i = 0; i < hPzEntities.size(); i++) {
				// b.再生成贷方凭证
				HPzEntity l = new HPzEntity();
				l.setKjqj(ywpzEntity.getKjqj());
				l.setPzh(pzh);
				flxh = baseMapper.selectmaxflxh(l);// 获取当前会计期间当前凭证号的最大flxh+1的值
				HPzEntity hPzEntityjf = new HPzEntity();
				hPzEntityjf.setGzdbm("0001");
				hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
				hPzEntityjf.setPzh(pzh);
				hPzEntityjf.setFlxh(flxh);
				// ------系统日期
				String temp_strx = "";
				Date dtx = new Date();
				SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
				temp_strx = sdfx.format(dtx);
				HPzEntity hPzEntity = hPzEntities.get(i);
				hPzEntityjf.setPzrq(hPzEntity.getDjrq());
				hPzEntityjf.setFjzs(0);
				String zymc = hPzEntity.getWxbw();
				hPzEntityjf.setZymc(zymc);
				// -----
				String maxzybm = baseMapper.selectmaxzybm();
				String newzybm = "";
				if ("".equals(maxzybm) || maxzybm == null) {
					newzybm = "0001";
				} else if (!"".equals(maxzybm) && maxzybm != null) {
					String aa = Integer.parseInt(maxzybm) + 1 + "";
					DecimalFormat df = new DecimalFormat("0000");
					String result = df.format(Integer.parseInt(aa));
					newzybm = result;
				}
				HZyEntity zy = new HZyEntity();
				zy.setZybm(newzybm);
				zy.setZymc(zymc);
				zy.setZtbm(ztbm);
				baseMapper.insertzy(zy);
				// -----
				hPzEntityjf.setKm(hPzEntity.getYhkmdm());
				hPzEntityjf.setJfje(0.0);
				hPzEntityjf.setDfje(hPzEntity.getJe());
				hPzEntityjf.setSfsh("0");
				hPzEntityjf.setSfjz("0");
				hPzEntityjf.setLrfs("1");
				String temp_str1 = "";
				Date dt1 = new Date();
				// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
				SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				temp_str1 = sdf1.format(dt1);
				hPzEntityjf.setJzsj(temp_str1);
				hPzEntityjf.setYwlx(hPzEntity.getJsfs());
				hPzEntityjf.setYwbh(hPzEntity.getZph());
				hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
				String temp_str = "";
				Date dt = new Date();
				// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				temp_str = sdf.format(dt);
				hPzEntityjf.setZdsj(temp_str);
				hPzEntityjf.setZtbm(ztbm);
				hPzEntityjf.setPztype("记账");
				hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
				baseMapper.inserthpzjf(hPzEntityjf);
			}
		} else if (1 == ywpzEntity.getSfhbfl()) {// 合并分录
			// 一贷多借，借方：维修资金使用，贷方：银行存款。
			// 1.生成凭证号(取当前会计期间最大凭证号+1)：
			int pzh = 1;
			// ------------------------------------
			// 处理凭证号插空问题
			List<String> lpzhgs = baseMapper.selectkjqjpzhgs(ywpzEntity.getKjqj());// 查此会计期间有多少条pzh
			String maxpzhck = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());// 查此会计期间最大pzh
			if (lpzhgs.isEmpty()) {
				String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
				if ("".equals(maxpzh) || maxpzh == null) {
					pzh = 1;
				} else if (!"".equals(maxpzh) || maxpzh != null) {
					String aa = Integer.parseInt(maxpzh) + 1 + "";
					DecimalFormat df = new DecimalFormat("0");
					String result = df.format(Integer.parseInt(aa));
					pzh = Integer.parseInt(result);
				}
			} else {
				int maxPZH = Integer.parseInt(maxpzhck);
				if (maxPZH == lpzhgs.size()) {// 如果相等则表示该会计期间pzh没有断号，则按pzh+1规则来生成pzh
					String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
					if ("".equals(maxpzh) || maxpzh == null) {
						pzh = 1;
					} else if (!"".equals(maxpzh) || maxpzh != null) {
						String aa = Integer.parseInt(maxpzh) + 1 + "";
						DecimalFormat df = new DecimalFormat("0");
						String result = df.format(Integer.parseInt(aa));
						pzh = Integer.parseInt(result);
					}
				} else {// 不相等则表示存在断号，需先补漏，全部补完了不断号之后再按pzh+1规则来生成pzh
					for (int i = 1; i <= maxPZH; i++) {
						if (lpzhgs.contains(i + "")) {

						} else {
							pzh = i;
							break;
						}
					}
				}
			}

			// ------------------------------------
			int flxh = 1;
			for (int i = 0; i < hPzEntities.size(); i++) {
				// a.先生成借方凭证
				HPzEntity hPzEntityjf = new HPzEntity();
				hPzEntityjf.setGzdbm("0001");
				hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
				hPzEntityjf.setPzh(pzh);
				hPzEntityjf.setFlxh(flxh);
				// ------系统日期
				String temp_strx = "";
				Date dtx = new Date();
				SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
				temp_strx = sdfx.format(dtx);
				HPzEntity hPzEntity = hPzEntities.get(i);
				hPzEntityjf.setPzrq(hPzEntity.getDjrq());
				hPzEntityjf.setFjzs(0);
				String zymc = hPzEntity.getWxbw();
				hPzEntityjf.setZymc(zymc);
				// -----
				String maxzybm = baseMapper.selectmaxzybm();
				String newzybm = "";
				if ("".equals(maxzybm) || maxzybm == null) {
					newzybm = "0001";
				} else if (!"".equals(maxzybm) && maxzybm != null) {
					String aa = Integer.parseInt(maxzybm) + 1 + "";
					DecimalFormat df = new DecimalFormat("0000");
					String result = df.format(Integer.parseInt(aa));
					newzybm = result;
				}
				HZyEntity zy = new HZyEntity();
				zy.setZybm(newzybm);
				zy.setZymc(zymc);
				zy.setZtbm(ztbm);
				baseMapper.insertzy(zy);
				// -------
				hPzEntityjf.setKm(hPzEntity.getKfskmdm());
				hPzEntityjf.setJfje(hPzEntity.getJe());
				hPzEntityjf.setDfje(0.0);
				hPzEntityjf.setSfsh("0");
				hPzEntityjf.setSfjz("0");
				hPzEntityjf.setLrfs("1");
				hPzEntityjf.setYwlx(hPzEntity.getDjlx());
				hPzEntityjf.setYwbh(hPzEntity.getZph());
				hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
				String temp_str = "";
				Date dt = new Date();
				// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				temp_str = sdf.format(dt);
				hPzEntityjf.setZdsj(temp_str);
				hPzEntityjf.setZtbm(ztbm);
				hPzEntityjf.setPztype("记账");
				hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
				hPzEntityjf.setJzsj(temp_str);
				baseMapper.inserthpzjf(hPzEntityjf);
				hPzEntityjf.setDjbh(hPzEntity.getDjbh());
				// 改单据生成凭证之后将pzh记录在ywpz该pzh字段单据中
				baseMapper.updateywpzpzh(hPzEntityjf);
				flxh = flxh + 1;
				// // 单位凭证生成的时候，将辅助核算明细中该单据的pzh和cwkjqj刷进去
				 baseMapper.updatefzhsmxdw(hPzEntityjf);
			}
			Double sumdfje = 0.0;
			String zymc = "";
			for (int i = 0; i < hPzEntities.size(); i++) {
				sumdfje += hPzEntities.get(i).getJe();
				if (i == 0) {
					zymc += hPzEntities.get(i).getXqmc() + "_" + hPzEntities.get(i).getXmmc();
				} else {
					zymc = zymc + "," + hPzEntities.get(i).getXmmc();
				}
			}
			// b.再生成贷方凭证
			HPzEntity l = new HPzEntity();
			l.setKjqj(ywpzEntity.getKjqj());
			l.setPzh(pzh);
			flxh = baseMapper.selectmaxflxh(l);// 获取当前会计期间当前凭证号的最大flxh+1的值
			HPzEntity hPzEntityjf = new HPzEntity();
			hPzEntityjf.setGzdbm("0001");
			hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
			hPzEntityjf.setPzh(pzh);
			hPzEntityjf.setFlxh(flxh);
			// ------系统日期
			String temp_strx = "";
			Date dtx = new Date();
			SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
			temp_strx = sdfx.format(dtx);
			HPzEntity hPzEntity = hPzEntities.get(0);
			hPzEntityjf.setPzrq(hPzEntity.getDjrq());
			hPzEntityjf.setFjzs(0);
			hPzEntityjf.setZymc(zymc);
			// -----
			String maxzybm = baseMapper.selectmaxzybm();
			String newzybm = "";
			if ("".equals(maxzybm) || maxzybm == null) {
				newzybm = "0001";
			} else if (!"".equals(maxzybm) && maxzybm != null) {
				String aa = Integer.parseInt(maxzybm) + 1 + "";
				DecimalFormat df = new DecimalFormat("0000");
				String result = df.format(Integer.parseInt(aa));
				newzybm = result;
			}
			HZyEntity zy = new HZyEntity();
			zy.setZybm(newzybm);
			zy.setZymc(zymc);
			zy.setZtbm(ztbm);
			baseMapper.insertzy(zy);
			// -----
			hPzEntityjf.setKm(hPzEntity.getYhkmdm());
			hPzEntityjf.setJfje(0.0);
			hPzEntityjf.setDfje(sumdfje);
			hPzEntityjf.setSfsh("0");
			hPzEntityjf.setSfjz("0");
			hPzEntityjf.setLrfs("1");
			String temp_str1 = "";
			Date dt1 = new Date();
			// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
			SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			temp_str1 = sdf1.format(dt1);
			hPzEntityjf.setJzsj(temp_str1);
			hPzEntityjf.setYwlx(hPzEntity.getJsfs());
			hPzEntityjf.setYwbh(hPzEntity.getZph());
			hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
			String temp_str = "";
			Date dt = new Date();
			// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			temp_str = sdf.format(dt);
			hPzEntityjf.setZdsj(temp_str);
			hPzEntityjf.setZtbm(ztbm);
			hPzEntityjf.setPztype("记账");
			hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
			baseMapper.inserthpzjf(hPzEntityjf);
		}

		return R.ok();

	}

	@Override
	public R PZXGBC(List<HPzEntity> list) {

		for (int i = 0; i < list.size(); i++) {
			// ----
			if (list.get(i).getPzh() == 0) {// 修改时新加的分录
				// 查询当前pzh最大flxh+1
				int flxh = baseMapper.selectmaxflxh(list.get(0));
				// 查询当前pzh的其中一条分录
				HPzEntity h1 = baseMapper.selectonefl(list.get(0));
				list.get(i).setGzdbm("0001");
				list.get(i).setKjqj(h1.getKjqj());
				list.get(i).setPzh(h1.getPzh());
				list.get(i).setFlxh(flxh);
				list.get(i).setPzrq(h1.getPzrq());
				list.get(i).setFjzs(h1.getFjzs());
				list.get(i).setSfsh(h1.getSfsh());
				list.get(i).setSfjz(h1.getSfjz());
				list.get(i).setLrfs(h1.getLrfs());
				list.get(i).setZdrbm(h1.getZdrbm());
				list.get(i).setZdsj(h1.getZdsj());
				list.get(i).setZtbm(h1.getZtbm());
				list.get(i).setPztype(h1.getPztype());
				list.get(i).setZdrmc(h1.getZdrmc());
				baseMapper.inserthpzjf(list.get(i));
			} else {// 修改已有的分录
				HZyEntity zy = baseMapper.selectzy(list.get(i).getZymc());
				if (isObjectNotEmpty(zy) == false) {
					String maxzybm1 = baseMapper.selectmaxzybm();
					String newzybm1 = "";
					if ("".equals(maxzybm1) || maxzybm1 == null) {
						newzybm1 = "0001";
					} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
						String aa = Integer.parseInt(maxzybm1) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm1 = result;
					}
					HZyEntity zy1 = new HZyEntity();
					zy1.setZybm(newzybm1);
					zy1.setZymc(list.get(i).getZymc());
					zy1.setZtbm("0001");
					baseMapper.insertzy(zy1);
				}
				baseMapper.updatepz(list.get(i));
			}

		}
		return R.ok();
	}

	/**
	 * 获取重复的元素值(单位相同科目业务分类)
	 *
	 * @param projectLandVos
	 *            项目片块数据集合
	 * @return List<List < ProjectLandVo>> 返回重复的项目片块数据
	 */
	private static List<List<HPzEntity>> getDuplicateElements(List<HPzEntity> hPzEntities) {// 将同一个list对象中具有相同属性的对象放入到一个新的list中
		// 用于接收重复的项目片块数据，返回给方法的调用者
		List<List<HPzEntity>> result = new ArrayList<List<HPzEntity>>();
		// 用于临时保存重复的项目片块数据
		Map<String, List<HPzEntity>> map = new TreeMap<String, List<HPzEntity>>();

		for (HPzEntity bean : hPzEntities) {
			// 判断当前值是否已经在map中存在
			if (map.containsKey(bean.getKfskmdm())) {
				List<HPzEntity> hasObj = map.get(bean.getKfskmdm());
				// 对象拷贝
				HPzEntity landTarget = new HPzEntity();
				BeanUtil.copyProperties(bean, landTarget);
				hasObj.add(landTarget);
				new ArrayList<HPzEntity>().add(landTarget);
				map.put(bean.getKfskmdm(), hasObj);
			} else {
				List<HPzEntity> newObj = new ArrayList<HPzEntity>();
				HPzEntity landTarget = new HPzEntity();
				BeanUtil.copyProperties(bean, landTarget);
				newObj.add(landTarget);
				map.put(bean.getKfskmdm(), newObj);
			}
		}
		// 取出所有的重复的数据值，存入到result中
		for (Map.Entry<String, List<HPzEntity>> entry : map.entrySet()) {
			result.add(entry.getValue());
		}
		return result;

	}

	/**
	 * 获取重复的元素值(业主相同科目业务分类)
	 *
	 * @param projectLandVos
	 *            项目片块数据集合
	 * @return List<List < ProjectLandVo>> 返回重复的项目片块数据
	 */
	private static List<List<HPzEntity>> getDuplicateElements2(List<HPzEntity> hPzEntities) {// 将同一个list对象中具有相同属性的对象放入到一个新的list中
		// 用于接收重复的项目片块数据，返回给方法的调用者
		List<List<HPzEntity>> result = new ArrayList<List<HPzEntity>>();
		// 用于临时保存重复的项目片块数据
		Map<String, List<HPzEntity>> map = new TreeMap<String, List<HPzEntity>>();

		for (HPzEntity bean : hPzEntities) {
			// 判断当前值是否已经在map中存在
			if (map.containsKey(bean.getYzkmdm())) {
				List<HPzEntity> hasObj = map.get(bean.getYzkmdm());
				// 对象拷贝
				HPzEntity landTarget = new HPzEntity();
				BeanUtil.copyProperties(bean, landTarget);
				hasObj.add(landTarget);
				new ArrayList<HPzEntity>().add(landTarget);
				map.put(bean.getYzkmdm(), hasObj);
			} else {
				List<HPzEntity> newObj = new ArrayList<HPzEntity>();
				HPzEntity landTarget = new HPzEntity();
				BeanUtil.copyProperties(bean, landTarget);
				newObj.add(landTarget);
				map.put(bean.getYzkmdm(), newObj);
			}
		}
		// 取出所有的重复的数据值，存入到result中
		for (Map.Entry<String, List<HPzEntity>> entry : map.entrySet()) {
			result.add(entry.getValue());
		}
		return result;

	}

	@Override
	public List<HPzEntity> PZSHXQPL(HPzEntity hPzEntity) {// 页面选择同一个凭证号的多个分录批量打印
		List<HPzEntity> listj = baseMapper.selectPZSHXQj2(hPzEntity);
		List<HPzEntity> listd = baseMapper.selectPZSHXQd2(hPzEntity);
		List<HPzEntity> list2 = new ArrayList<HPzEntity>();
		Double sumj = 0.0;
		for (HPzEntity q : listj) {
			list2.add(q);
			sumj = sumj + q.getJfje();
		}
		for (HPzEntity w : listd) {
			list2.add(w);
		}
		String a = sumj.toString();
		HPzEntity dx = new HPzEntity();
		if ("-".equals(a.substring(0, 1))) {
			dx.setHjdx(MoneyUtil.toChinese(a.substring(1)));
		} else {
			dx.setHjdx(MoneyUtil.toChinese(a));
		}
		dx.setHjxx(sumj);
		if (!list2.isEmpty()) {
			list2.add(dx);
		}

		return list2;
	}

	@Override
	public List<HPzEntity> selectjzsr(YwpzEntity ywpzEntity) {

		return baseMapper.selectjzsr(ywpzEntity);
	}

	@Override
	public List<HPzEntity> selectjzzc(YwpzEntity ywpzEntity) {

		return baseMapper.selectjzzc(ywpzEntity);
	}

	@Override
	public void insertCWJZSZPZ(YwpzEntity ywpzEntity) {
		// 1.结转收入查询
		List<HPzEntity> listsr = baseMapper.selectjzsr(ywpzEntity);

		if (listsr.isEmpty()) {

		} else {
			// 2.结转收入凭证生成(结转收入)
			// 生成凭证号(取当前会计期间最大凭证号+1)：
			String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
			int pzh = 1;
			if ("".equals(maxpzh) || maxpzh == null) {
				pzh = 1;
			} else if (!"".equals(maxpzh) || maxpzh != null) {
				String aa = Integer.parseInt(maxpzh) + 1 + "";
				DecimalFormat df = new DecimalFormat("0");
				String result = df.format(Integer.parseInt(aa));
				pzh = Integer.parseInt(result);
			}
			int flxh = 1;
			Double sumsr = 0.0;
			for (HPzEntity psr : listsr) {
				if (psr.getJfje().compareTo(psr.getDfje()) == 0) {

				} else {// 借贷方不相等，说明还未进行结转收支生成凭证，则进行结转收支生成凭证。
					// 先生成借方
					HPzEntity p = new HPzEntity();
					p.setPztype("记账");
					p.setZtbm("0001");
					p.setGzdbm("0001");
					String temp_str = "";
					Date dt = new Date();
					// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					temp_str = sdf.format(dt);
					p.setPzrq(ywpzEntity.getPzrq());
					p.setZdsj(temp_str);
					p.setSfsh("0");
					p.setSfjz("0");
					p.setKjqj(ywpzEntity.getKjqj());
					p.setPzh(pzh);
					p.setFjzs(0);
					p.setFlxh(flxh);
					p.setYwlx("");
					p.setYwbh("");
					p.setZymc("结转收入");
					// -----
					String maxzybm = baseMapper.selectmaxzybm();
					String newzybm = "";
					if ("".equals(maxzybm) || maxzybm == null) {
						newzybm = "0001";
					} else if (!"".equals(maxzybm) && maxzybm != null) {
						String aa = Integer.parseInt(maxzybm) + 1 + "";
						DecimalFormat df = new DecimalFormat("0000");
						String result = df.format(Integer.parseInt(aa));
						newzybm = result;
					}
					HZyEntity zy = new HZyEntity();
					zy.setZybm(newzybm);
					zy.setZymc("结转收入");
					zy.setZtbm("0001");
					baseMapper.insertzy(zy);
					// -----
					p.setKm(psr.getKm());
					p.setJfje(psr.getDfje() - psr.getJfje());
					p.setDfje(0.0);
					p.setZdrmc(ywpzEntity.getZdrmc());
					p.setZdrbm(ywpzEntity.getZdrbm());
					p.setLrfs("1");
					baseMapper.inserthpzjf(p);
					flxh = flxh + 1;
					sumsr = sumsr + (psr.getDfje() - psr.getJfje());
				}
			}
			// 再生成贷方
			HPzEntity p = new HPzEntity();
			p.setPztype("记账");
			p.setZtbm("0001");
			p.setGzdbm("0001");
			String temp_str = "";
			Date dt = new Date();
			// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			temp_str = sdf.format(dt);
			p.setPzrq(ywpzEntity.getPzrq());
			p.setZdsj(temp_str);
			p.setSfsh("0");
			p.setSfjz("0");
			p.setKjqj(ywpzEntity.getKjqj());
			p.setPzh(pzh);
			p.setFjzs(0);
			p.setFlxh(flxh);
			p.setYwlx("");
			p.setYwbh("");
			p.setZymc("结转收入");
			p.setKm(ywpzEntity.getKm());
			p.setJfje(0.0);
			p.setDfje(sumsr);
			p.setZdrmc(ywpzEntity.getZdrmc());
			p.setZdrbm(ywpzEntity.getZdrbm());
			p.setLrfs("1");
			baseMapper.inserthpzjf(p);
		}

		// 1.结转支出查询
		List<HPzEntity> listzc = baseMapper.selectjzzc(ywpzEntity);
		if (listzc.isEmpty()) {

		} else {
			// 2.结转支出凭证生成(结转支出)
			// 生成凭证号(取当前会计期间最大凭证号+1)：
			String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
			int pzh = 1;
			if ("".equals(maxpzh) || maxpzh == null) {
				pzh = 1;
			} else if (!"".equals(maxpzh) || maxpzh != null) {
				String aa = Integer.parseInt(maxpzh) + 1 + "";
				DecimalFormat df = new DecimalFormat("0");
				String result = df.format(Integer.parseInt(aa));
				pzh = Integer.parseInt(result);
			}
			Double sumzc = 0.0;
			for (HPzEntity pzc : listzc) {
				sumzc = sumzc + (pzc.getJfje() - pzc.getDfje());
			}
			int flxh = 1;
			// 先生成借方
			HPzEntity p = new HPzEntity();
			p.setPztype("记账");
			p.setZtbm("0001");
			p.setGzdbm("0001");
			String temp_str = "";
			Date dt = new Date();
			// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			temp_str = sdf.format(dt);
			p.setPzrq(ywpzEntity.getPzrq());
			p.setZdsj(temp_str);
			p.setSfsh("0");
			p.setSfjz("0");
			p.setKjqj(ywpzEntity.getKjqj());
			p.setPzh(pzh);
			p.setFjzs(0);
			p.setFlxh(flxh);
			p.setYwlx("");
			p.setYwbh("");
			p.setZymc("结转支出");
			// -----
			String maxzybm = baseMapper.selectmaxzybm();
			String newzybm = "";
			if ("".equals(maxzybm) || maxzybm == null) {
				newzybm = "0001";
			} else if (!"".equals(maxzybm) && maxzybm != null) {
				String aa = Integer.parseInt(maxzybm) + 1 + "";
				DecimalFormat df = new DecimalFormat("0000");
				String result = df.format(Integer.parseInt(aa));
				newzybm = result;
			}
			HZyEntity zy = new HZyEntity();
			zy.setZybm(newzybm);
			zy.setZymc("结转支出");
			zy.setZtbm("0001");
			baseMapper.insertzy(zy);
			// -----
			p.setKm(ywpzEntity.getKm());
			p.setJfje(sumzc);
			p.setDfje(0.0);
			p.setZdrmc(ywpzEntity.getZdrmc());
			p.setZdrbm(ywpzEntity.getZdrbm());
			p.setLrfs("1");
			baseMapper.inserthpzjf(p);
			flxh = flxh + 1;
			for (HPzEntity pzc : listzc) {
				if (pzc.getJfje().compareTo(pzc.getDfje()) == 0) {

				} else {// 借贷方不相等，说明还未进行结转收支生成凭证，则进行结转收支生成凭证。
					// 再生成贷方
					HPzEntity p1 = new HPzEntity();
					p1.setPztype("记账");
					p1.setZtbm("0001");
					p1.setGzdbm("0001");
					p1.setPzrq(ywpzEntity.getPzrq());
					p1.setZdsj(temp_str);
					p1.setSfsh("0");
					p1.setSfjz("0");
					p1.setKjqj(ywpzEntity.getKjqj());
					p1.setPzh(pzh);
					p1.setFjzs(0);
					p1.setFlxh(flxh);
					p1.setYwlx("");
					p1.setYwbh("");
					p1.setZymc("结转支出");
					p1.setKm(pzc.getKm());
					p1.setJfje(0.0);
					p1.setDfje(pzc.getJfje() - pzc.getDfje());
					p1.setZdrmc(ywpzEntity.getZdrmc());
					p1.setZdrbm(ywpzEntity.getZdrbm());
					p1.setLrfs("1");
					baseMapper.inserthpzjf(p1);
					flxh = flxh + 1;
				}
			}
		}

	}

	@Override
	public List<HPzEntity> PZSHXQPL2(HPzEntity hPzEntity) {//// 页面选择不同凭证号的一个或多个分录批量打印
		List<HPzEntity> listj = baseMapper.selectPZSHXQj(hPzEntity);
		List<HPzEntity> listd = baseMapper.selectPZSHXQd(hPzEntity);
		List<HPzEntity> list2 = new ArrayList<HPzEntity>();
		Double sumj = 0.0;
		for (HPzEntity q : listj) {
			list2.add(q);
			sumj = sumj + q.getJfje();
		}
		for (HPzEntity w : listd) {
			list2.add(w);
		}
		// String a = sumj.toString();
		int card = new Double(sumj).intValue();
		String a = Integer.toString(card);
		HPzEntity dx = new HPzEntity();
		if ("-".equals(a.substring(0, 1))) {
			dx.setHjdx(MoneyUtil.toChinese(a.substring(1)));
		} else {
			dx.setHjdx(MoneyUtil.toChinese(a));
		}
		dx.setHjxx(sumj);
		if (!list2.isEmpty()) {
			list2.add(dx);
		}

		return list2;
	}

	@Override
	public int selectytlx(YwpzEntity ywpzEntity) {

		return baseMapper.selectytlx(ywpzEntity);
	}

	@Override
	public HYtlxbEntity selectjxrq(YwpzEntity ywpzEntity) {

		return baseMapper.selectjxrq(ywpzEntity);
	}

	@Override
	public HYtlxbEntity selectytxx(String id) {

		return baseMapper.selectytxx(id);
	}

	@Override
	public void insertCWYTLXPZSC(YwpzEntity ywpzEntity) {
		// 2.生成凭证号(取当前会计期间最大凭证号+1)：
		String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
		int pzh = 0;
		if ("".equals(maxpzh) || maxpzh == null) {
			pzh = 1;
		} else if (!"".equals(maxpzh) || maxpzh != null) {
			String aa = Integer.parseInt(maxpzh) + 1 + "";
			DecimalFormat df = new DecimalFormat("0");
			String result = df.format(Integer.parseInt(aa));
			pzh = Integer.parseInt(result);
		}
		int flxh = 1;
		for (int j = 0; j < 2; j++) {
			if (j == 0) {
				// a.先生成贷方凭证
				HPzEntity hPzEntityjf = new HPzEntity();
				hPzEntityjf.setGzdbm("0001");
				hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
				hPzEntityjf.setPzh(pzh);
				hPzEntityjf.setFlxh(flxh);
				hPzEntityjf.setPzrq(ywpzEntity.getPzrq());
				hPzEntityjf.setFjzs(0);
				hPzEntityjf.setZymc(ywpzEntity.getKjqj() + "预提利息");
				// -----
				String maxzybm = baseMapper.selectmaxzybm();
				String newzybm = "";
				if ("".equals(maxzybm) || maxzybm == null) {
					newzybm = "0001";
				} else if (!"".equals(maxzybm) && maxzybm != null) {
					String aa = Integer.parseInt(maxzybm) + 1 + "";
					DecimalFormat df = new DecimalFormat("0000");
					String result = df.format(Integer.parseInt(aa));
					newzybm = result;
				}
				HZyEntity zy = new HZyEntity();
				zy.setZybm(newzybm);
				zy.setZymc(ywpzEntity.getKjqj() + "预提利息");
				zy.setZtbm("0001");
				baseMapper.insertzy(zy);
				// -------
				hPzEntityjf.setKm(ywpzEntity.getYtkm());
				hPzEntityjf.setJfje(0.0);
				hPzEntityjf.setDfje(ywpzEntity.getHYtlxbEntity().getLx());
				hPzEntityjf.setSfsh("0");
				hPzEntityjf.setSfjz("0");
				hPzEntityjf.setLrfs("1");
				hPzEntityjf.setYwlx("");
				hPzEntityjf.setYwbh("99");
				hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
				String temp_str = "";
				Date dt = new Date();
				// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				temp_str = sdf.format(dt);
				hPzEntityjf.setZdsj(temp_str);
				hPzEntityjf.setZtbm("0001");
				hPzEntityjf.setPztype("记账");
				hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
				hPzEntityjf.setJzsj(temp_str);
				baseMapper.inserthpzjf(hPzEntityjf);
				flxh = flxh + 1;
			} else if (j == 1) {
				// b.再生成借方凭证
				HPzEntity hPzEntityjf = new HPzEntity();
				hPzEntityjf.setGzdbm("0001");
				hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
				hPzEntityjf.setPzh(pzh);
				hPzEntityjf.setFlxh(flxh);
				hPzEntityjf.setPzrq(ywpzEntity.getPzrq());
				hPzEntityjf.setFjzs(0);
				hPzEntityjf.setZymc("预提利息");
				// -----
				String maxzybm = baseMapper.selectmaxzybm();
				String newzybm = "";
				if ("".equals(maxzybm) || maxzybm == null) {
					newzybm = "0001";
				} else if (!"".equals(maxzybm) && maxzybm != null) {
					String aa = Integer.parseInt(maxzybm) + 1 + "";
					DecimalFormat df = new DecimalFormat("0000");
					String result = df.format(Integer.parseInt(aa));
					newzybm = result;
				}
				HZyEntity zy = new HZyEntity();
				zy.setZybm(newzybm);
				zy.setZymc("预提利息");
				zy.setZtbm("0001");
				baseMapper.insertzy(zy);
				// -----
				hPzEntityjf.setKm(ywpzEntity.getYwzckm());
				hPzEntityjf.setJfje(ywpzEntity.getHYtlxbEntity().getLx());
				hPzEntityjf.setDfje(0.0);
				hPzEntityjf.setSfsh("0");
				hPzEntityjf.setSfjz("0");
				hPzEntityjf.setLrfs("1");
				String temp_str1 = "";
				Date dt1 = new Date();
				// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
				SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				temp_str1 = sdf1.format(dt1);
				hPzEntityjf.setJzsj(temp_str1);
				hPzEntityjf.setYwlx("");
				hPzEntityjf.setYwbh("99");
				hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
				String temp_str = "";
				Date dt = new Date();
				// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				temp_str = sdf.format(dt);
				hPzEntityjf.setZdsj(temp_str);
				hPzEntityjf.setZtbm("0001");
				hPzEntityjf.setPztype("记账");
				hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
				baseMapper.inserthpzjf(hPzEntityjf);
				flxh = flxh + 1;
			}
		}
		XtcsEntity xtcs = baseMapper.selectxtcs();
		// 在预提利息表中记录此次预提利息操作
		ywpzEntity.getHYtlxbEntity().setPzh(pzh);
		ywpzEntity.getHYtlxbEntity().setKjqj(ywpzEntity.getKjqj());
		ywpzEntity.getHYtlxbEntity().setJxnd(ywpzEntity.getJxnd());
		ywpzEntity.getHYtlxbEntity().setJxrq(ywpzEntity.getPzrq());
		ywpzEntity.getHYtlxbEntity().setDqll(xtcs.getDqll());
		ywpzEntity.getHYtlxbEntity().setHqll(xtcs.getHqll());
		baseMapper.insertytlxb(ywpzEntity.getHYtlxbEntity());
	}

	@Override
	public PageInfo<HYtlxbEntity> queryByPageYTLX(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<HYtlxbEntity> hYtlxbEntities = baseMapper.queryByPageYTLX(ywpzEntity);
		PageInfo<HYtlxbEntity> pageInfo = new PageInfo<HYtlxbEntity>(hYtlxbEntities);
		return pageInfo;
	}

	@Override
	public String selectztbmbykjqj(HPzEntity hPzEntity) {
		String ztbm = "";
		String qskjqj = hPzEntity.getQskjqj();
		String zzkjqj = hPzEntity.getZzkjqj();
		String gdrq = "2020-12";// 切换新旧科目的临界日期
		int resq = qskjqj.compareTo(gdrq);
		int resz = zzkjqj.compareTo(gdrq);
		if (resq <= 0 && resz <= 0) {
			ztbm = "0002";
		} else if (resq > 0 && resz > 0) {
			ztbm = "0003";
		} else {
			ztbm = "false";
		}
		return ztbm;
	}

	@Override
	public PageInfo<YwpzEntity> queryByPageTKPZ(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		List<YwpzEntity> ywHPzEntities111 = baseMapper.queryByPageTKPZ(ywpzEntity);
		Double sumje = 0.0;
		for (YwpzEntity y : ywHPzEntities111) {
			sumje = sumje + y.getJe();
		}
		sumje = (double) Math.round(sumje * 100) / 100;
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzEntity> ywHPzEntities = baseMapper.queryByPageTKPZ(ywpzEntity);
		if (!ywHPzEntities.isEmpty()) {
			ywHPzEntities.get(0).setJezh(sumje);
		}
		for (YwpzEntity y : ywHPzEntities) {
			String djrq = y.getDjrq();
			String gdrq = "2020-12-31";// 切换新旧科目的临界日期
			int res = djrq.compareTo(gdrq);
			if (res <= 0) {// 用2021以前市局科目
				y.setZtbm("0002");
				// 1.贷方科目：新科目不按单位个人缴分，按交存分。所以每一笔单据业务的开发商科目代码都是：201001，开发商科目名称都是：“商品住宅维修资金-交存”
				// 1.借方
				y.setYhkmdm("201004");
				y.setYzkmdmmc("商品住宅维修资金-退款");
				// 2.贷方科目
				// 获取该开发商预交的银行科目代码
				HKmEntity hKmEntitya = baseMapper.selectbymc2(y.getYhmc());
				// 设置该单据的银行核算科目
				y.setYzkmdm(hKmEntitya.getKm() + "001");

			} else if (res > 0) {// 用2021以后科目规则
				y.setZtbm("0003");
				// 1.贷方科目：新科目不按单位个人缴分，按交存分。所以每一笔单据业务的开发商科目代码都是：201001，开发商科目名称都是：“商品住宅维修资金-交存”
				// 1.借方
				y.setYhkmdm("5101");
				y.setYzkmdmmc("返还支出");
				// 2.贷方科目
				// 获取该开发商预交的银行科目代码
				HKmEntity hKmEntitya = baseMapper.selectbymc22(y.getYhmc());
				// 设置该单据的银行核算科目
				y.setYzkmdm(hKmEntitya.getKm() + "01");
			}
		}

		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywHPzEntities);
		return pageInfo;
	}

	@Override
	public R insertTKPZSC(YwpzEntity ywpzEntity) {
		String djrq = ywpzEntity.getKjqj();
		String gdrq = "2020-12";// 切换新旧科目的临界日期
		int res = djrq.compareTo(gdrq);
		String ztbm = "0002";
		if (res > 0) {// 用2021以前市局科目
			ztbm = "0003";
		}
		// 2.生成凭证号(取当前会计期间最大凭证号+1)：
		int pzh = 0;
		// ------------------------------------
		// 处理凭证号插空问题
		List<String> lpzhgs = baseMapper.selectkjqjpzhgs(ywpzEntity.getKjqj());// 查此会计期间有多少条pzh
		String maxpzhck = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());// 查此会计期间最大pzh
		if (lpzhgs.isEmpty()) {
			String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
			if ("".equals(maxpzh) || maxpzh == null) {
				pzh = 1;
			} else if (!"".equals(maxpzh) || maxpzh != null) {
				String aa = Integer.parseInt(maxpzh) + 1 + "";
				DecimalFormat df = new DecimalFormat("0");
				String result = df.format(Integer.parseInt(aa));
				pzh = Integer.parseInt(result);
			}
		} else {
			int maxPZH = Integer.parseInt(maxpzhck);
			if (maxPZH == lpzhgs.size()) {// 如果相等则表示该会计期间pzh没有断号，则按pzh+1规则来生成pzh
				String maxpzh = baseMapper.selectmaxpzh(ywpzEntity.getKjqj());
				if ("".equals(maxpzh) || maxpzh == null) {
					pzh = 1;
				} else if (!"".equals(maxpzh) || maxpzh != null) {
					String aa = Integer.parseInt(maxpzh) + 1 + "";
					DecimalFormat df = new DecimalFormat("0");
					String result = df.format(Integer.parseInt(aa));
					pzh = Integer.parseInt(result);
				}
			} else {// 不相等则表示存在断号，需先补漏，全部补完了不断号之后再按pzh+1规则来生成pzh
				for (int i = 1; i <= maxPZH; i++) {
					if (lpzhgs.contains(i + "")) {

					} else {
						pzh = i;
						break;
					}
				}
			}
		}
		// ------------------------------------

		Collections.sort(ywpzEntity.getHPzEntities(), new Comparator<HPzEntity>() {// 按照单据日期升序排序
			@Override
			public int compare(HPzEntity o1, HPzEntity o2) {
				return o1.getDjrq().compareTo(o2.getDjrq());
			}
		});
		int flxh = 1;
		// 1.遍历每一个勾选的业务单据
		for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
			// a.先生成借方凭证
			HPzEntity hPzEntityjf = new HPzEntity();
			hPzEntityjf.setGzdbm("0001");
			hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
			hPzEntityjf.setPzh(pzh);
			hPzEntityjf.setFlxh(flxh);
			// ------系统日期
			String temp_strx = "";
			Date dtx = new Date();
			SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
			temp_strx = sdfx.format(dtx);
			// -----
			if ("1".equals(ywpzEntity.getSfsxtpl())) {
				hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
			} else {
				hPzEntityjf.setPzrq(temp_strx);
			}
			// hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(i).getDjrq());
			hPzEntityjf.setFjzs(0);
			hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
					+ ywpzEntity.getHPzEntities().get(i).getXm());
			// -----
			String maxzybm1 = baseMapper.selectmaxzybm();
			String newzybm1 = "";
			if ("".equals(maxzybm1) || maxzybm1 == null) {
				newzybm1 = "0001";
			} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
				String aa = Integer.parseInt(maxzybm1) + 1 + "";
				DecimalFormat df = new DecimalFormat("0000");
				String result = df.format(Integer.parseInt(aa));
				newzybm1 = result;
			}
			HZyEntity zy1 = new HZyEntity();
			zy1.setZybm(newzybm1);
			zy1.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
					+ ywpzEntity.getHPzEntities().get(i).getXm());
			zy1.setZtbm(ztbm);
			baseMapper.insertzy(zy1);
			// ----
			hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(i).getYhkmdm());
			hPzEntityjf.setJfje(ywpzEntity.getHPzEntities().get(i).getJe());
			hPzEntityjf.setDfje(0.0);
			hPzEntityjf.setSfsh("0");
			hPzEntityjf.setSfjz("0");
			hPzEntityjf.setLrfs("1");
			hPzEntityjf.setYwlx("03");
			hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(i).getZph());
			hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
			String temp_str = "";
			Date dt = new Date();
			// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			temp_str = sdf.format(dt);
			hPzEntityjf.setZdsj(temp_str);
			hPzEntityjf.setZtbm(ztbm);
			hPzEntityjf.setPztype("记账");
			hPzEntityjf.setJzsj(temp_str);
			hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
			baseMapper.inserthpzjf(hPzEntityjf);
			hPzEntityjf.setDjbh(ywpzEntity.getHPzEntities().get(i).getDjbh());
			// 改单位预交单据生成凭证之后将pzh记录在ywpz该pzh字段单据中
			baseMapper.updateywpzpzh(hPzEntityjf);
			flxh = flxh + 1;

			// 个人凭证生成的时候，将辅助核算明细中该单据的pzh和cwkjqj刷进去
			baseMapper.updatefzhsmxdw(hPzEntityjf);
		}

		for (int i = 0; i < ywpzEntity.getHPzEntities().size(); i++) {
			HPzEntity l = new HPzEntity();
			l.setKjqj(ywpzEntity.getKjqj());
			l.setPzh(pzh);
			flxh = baseMapper.selectmaxflxh(l);// 获取当前会计期间当前凭证号的最大flxh+1的值
			// b.再生成业主贷方凭证
			HPzEntity hPzEntityjf = new HPzEntity();
			hPzEntityjf.setGzdbm("0001");
			hPzEntityjf.setKjqj(ywpzEntity.getKjqj());
			hPzEntityjf.setPzh(pzh);
			hPzEntityjf.setFlxh(flxh);
			// ------系统日期
			String temp_strx = "";
			Date dtx = new Date();
			SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
			temp_strx = sdfx.format(dtx);
			// -----
			if ("1".equals(ywpzEntity.getSfsxtpl())) {
				hPzEntityjf.setPzrq(ywpzEntity.getMaxywrq());
			} else {
				hPzEntityjf.setPzrq(temp_strx);
			}
			// hPzEntityjf.setPzrq(ywpzEntity.getHPzEntities().get(i).getDjrq());
			hPzEntityjf.setFjzs(0);
			hPzEntityjf.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
					+ ywpzEntity.getHPzEntities().get(i).getXqmc() + ywpzEntity.getHPzEntities().get(i).getXmmc()
					+ ywpzEntity.getHPzEntities().get(i).getMphm() + ywpzEntity.getHPzEntities().get(i).getXm());
			// -----
			String maxzybm1 = baseMapper.selectmaxzybm();
			String newzybm1 = "";
			if ("".equals(maxzybm1) || maxzybm1 == null) {
				newzybm1 = "0001";
			} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
				String aa = Integer.parseInt(maxzybm1) + 1 + "";
				DecimalFormat df = new DecimalFormat("0000");
				String result = df.format(Integer.parseInt(aa));
				newzybm1 = result;
			}
			HZyEntity zy1 = new HZyEntity();
			zy1.setZybm(newzybm1);
			zy1.setZymc(ywpzEntity.getHPzEntities().get(i).getBillname() + "_"
					+ ywpzEntity.getHPzEntities().get(i).getXqmc() + ywpzEntity.getHPzEntities().get(i).getXmmc()
					+ ywpzEntity.getHPzEntities().get(i).getMphm() + ywpzEntity.getHPzEntities().get(i).getXm());
			zy1.setZtbm(ztbm);
			baseMapper.insertzy(zy1);
			// ----
			hPzEntityjf.setKm(ywpzEntity.getHPzEntities().get(i).getYzkmdm());
			hPzEntityjf.setJfje(0.0);
			hPzEntityjf.setDfje(ywpzEntity.getHPzEntities().get(i).getJe());
			hPzEntityjf.setSfsh("0");
			hPzEntityjf.setSfjz("0");
			hPzEntityjf.setLrfs("1");
			hPzEntityjf.setYwlx(ywpzEntity.getHPzEntities().get(i).getJsfs());
			hPzEntityjf.setYwbh(ywpzEntity.getHPzEntities().get(i).getZph());
			hPzEntityjf.setZdrbm(ywpzEntity.getZdrbm());
			String temp_str = "";
			Date dt = new Date();
			// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			temp_str = sdf.format(dt);
			hPzEntityjf.setZdsj(temp_str);
			hPzEntityjf.setZtbm(ztbm);
			hPzEntityjf.setJzsj(temp_str);
			hPzEntityjf.setPztype("记账");
			hPzEntityjf.setZdrmc(ywpzEntity.getZdrmc());
			baseMapper.inserthpzjf(hPzEntityjf);
		}
		return R.ok();
	}

	@Override
	public List<YwpzEntity> selectbbtjszb(String kjqj) {
		List<YwpzEntity> list = baseMapper.selectbbtjszb();// 查表结构数据
		List<HPzEntity> list2 = baseMapper.selectszbypz(kjqj);// h_pz查该年生成的所有凭证信息
		Double bm1 = 0.0;
		Double bm2 = 0.0;
		Double bm3 = 0.0;
		Double bm4 = 0.0;
		Double bm5 = 0.0;
		Double bm6 = 0.0;
		Double bm7 = 0.0;
		Double bm8 = 0.0;
		Double bm9 = 0.0;
		Double bm10 = 0.0;
		Double bm11 = 0.0;
		Double bm12 = 0.0;

		Double bm111 = 0.0;
		Double bm22 = 0.0;
		Double bm33 = 0.0;
		Double bm44 = 0.0;
		Double bm55 = 0.0;
		Double bm66 = 0.0;
		Double bm77 = 0.0;
		Double bm88 = 0.0;
		Double bm99 = 0.0;
		Double bm100 = 0.0;
		Double bm1111 = 0.0;
		Double bm122 = 0.0;
		for (HPzEntity p : list2) {
			// --------------------------------------------------------------------------本月
			if ("4001".equals(p.getKm().substring(0, 4)) && kjqj.equals(p.getKjqj())) {
				bm2 += p.getDfje();
			} else if ("4101".equals(p.getKm()) && kjqj.equals(p.getKjqj())) {
				bm3 += p.getDfje();
			} else if ("4102".equals(p.getKm()) && kjqj.equals(p.getKjqj())) {
				bm4 += p.getDfje();
			} else if ("4201".equals(p.getKm()) && kjqj.equals(p.getKjqj())) {
				bm5 += p.getDfje();
			} else if ("4301".equals(p.getKm()) && kjqj.equals(p.getKjqj())) {
				bm6 += p.getDfje();
			} else if ("4901".equals(p.getKm()) && kjqj.equals(p.getKjqj())) {
				bm7 += p.getDfje();
			} else if ("5001".equals(p.getKm()) && kjqj.equals(p.getKjqj())) {
				bm9 += p.getJfje();
			} else if ("5101".equals(p.getKm()) && kjqj.equals(p.getKjqj())) {
				bm10 += p.getJfje();
			} else if ("5901".equals(p.getKm()) && kjqj.equals(p.getKjqj())) {
				bm11 += p.getJfje();
			}
			// -----------------------------------------------------------------------------------------
			// 本年
			if ("4001".equals(p.getKm().substring(0, 4))) {
				bm22 += p.getDfje();
			} else if ("4101".equals(p.getKm())) {
				bm33 += p.getDfje();
			} else if ("4102".equals(p.getKm())) {
				bm44 += p.getDfje();
			} else if ("4201".equals(p.getKm())) {
				bm55 += p.getDfje();
			} else if ("4301".equals(p.getKm())) {
				bm66 += p.getDfje();
			} else if ("4901".equals(p.getKm())) {
				bm77 += p.getDfje();
			} else if ("5001".equals(p.getKm())) {
				bm99 += p.getJfje();
			} else if ("5101".equals(p.getKm())) {
				bm100 += p.getJfje();
			} else if ("5901".equals(p.getKm())) {
				bm1111 += p.getJfje();
			}
		}
		bm1 = bm2 + bm3 + bm4 + bm5 + bm6 + bm7;// 本月本期收入
		bm8 = bm9 + bm10 + bm11;// 本月本期支出
		if (bm1 - bm8 >= 0) {
			bm12 = bm1 - bm8;// 本月本期收支差额
		} else {
			bm12 = bm8 - bm1;// 本月本期收支差额
		}
		bm111 = bm22 + bm33 + bm44 + bm55 + bm66 + bm77;// 本年本期收入
		bm88 = bm99 + bm100 + bm1111;// 本年本期支出
		if (bm111 - bm88 >= 0) {
			bm122 = bm111 - bm88;// 本年本期收支差额
		} else {
			bm122 = bm88 - bm111;// 本年本期收支差额
		}
		for (YwpzEntity y : list) {
			if ("1".equals(y.getBm())) {
				if (bm1 > 0) {
					y.setBys(bm1);
				}
				if (bm111 > 0) {
					y.setBnljs(bm111);
				}
			} else if ("2".equals(y.getBm())) {
				if (bm2 > 0) {
					y.setBys(bm2);
				}
				if (bm22 > 0) {
					y.setBnljs(bm22);
				}
			} else if ("3".equals(y.getBm())) {
				if (bm3 > 0) {
					y.setBys(bm3);
				}
				if (bm33 > 0) {
					y.setBnljs(bm33);
				}
			} else if ("4".equals(y.getBm())) {
				if (bm4 > 0) {
					y.setBys(bm4);
				}
				if (bm44 > 0) {
					y.setBnljs(bm44);
				}
			} else if ("5".equals(y.getBm())) {
				if (bm5 > 0) {
					y.setBys(bm5);
				}
				if (bm55 > 0) {
					y.setBnljs(bm55);
				}
			} else if ("6".equals(y.getBm())) {
				if (bm6 > 0) {
					y.setBys(bm6);
				}
				if (bm66 > 0) {
					y.setBnljs(bm66);
				}
			} else if ("7".equals(y.getBm())) {
				if (bm7 > 0) {
					y.setBys(bm7);
				}
				if (bm77 > 0) {
					y.setBnljs(bm77);
				}
			} else if ("8".equals(y.getBm())) {
				if (bm8 > 0) {
					y.setBys(bm8);
				}
				if (bm88 > 0) {
					y.setBnljs(bm88);
				}
			} else if ("9".equals(y.getBm())) {
				if (bm9 > 0) {
					y.setBys(bm9);
				}
				if (bm99 > 0) {
					y.setBnljs(bm99);
				}
			} else if ("10".equals(y.getBm())) {
				if (bm10 > 0) {
					y.setBys(bm10);
				}
				if (bm100 > 0) {
					y.setBnljs(bm100);
				}
			} else if ("11".equals(y.getBm())) {
				if (bm11 > 0) {
					y.setBys(bm11);
				}
				if (bm1111 > 0) {
					y.setBnljs(bm1111);
				}
			} else if ("12".equals(y.getBm())) {
				if (bm12 > 0) {
					y.setBys(bm12);
				}
				if (bm122 > 0) {
					y.setBnljs(bm122);
				}
			}
		}
		return list;
	}

	@Override
	public List<YwpzEntity> selectbbtjjzcbdb(String kjqj) {
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
		java.util.Date date = null;
		try {
			date = formatter.parse(kjqj);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} // Date格式
		Calendar calBegin = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calBegin.setTime(date);
		calBegin.add(Calendar.YEAR, -1);
		String datestr = formatter.format(calBegin.getTime());// 上年
		// 查净资产变动表
		List<YwpzEntity> list = baseMapper.selectbbtjjzcbdb();
		// 查上年12月份的
		List<HKmyeEntity> list1 = baseMapper.selectkmyexxxx(datestr + "-12");// 上年年末
		// 查本年1月份的
		List<HKmyeEntity> list2 = baseMapper.selectkmyexxxx(kjqj.substring(0, 4) + "-01");// 本年年初
		//'4001','4201','4301','5001','5101','400101','4101','4102','4901','5901','3101'
		List<HPzEntity> list3=baseMapper.selectpzfse(kjqj.substring(0, 4));
		Double sum400102df=0.0;
		Double sum400102jf=0.0;
		Double sum4201df=0.0;
		Double sum4201jf=0.0;
		Double sum4301df=0.0;
		Double sum4301jf=0.0;
		Double sum5001df=0.0;
		Double sum5001jf=0.0;
		Double sum5101df=0.0;
		Double sum5101jf=0.0;
		Double sum400101df=0.0;
		Double sum400101jf=0.0;
		Double sum4101df=0.0;
		Double sum4101jf=0.0;
		Double sum4102df=0.0;
		Double sum4102jf=0.0;
		Double sum4901df=0.0;
		Double sum4901jf=0.0;
		Double sum5901df=0.0;
		Double sum5901jf=0.0;
		Double sum3101df=0.0;
		Double sum3101jf=0.0;
		for(HPzEntity pp:list3){
			if("400101".equals(pp.getKm())){
				sum400101df+=pp.getDfje();
				sum400101jf+=pp.getJfje();
			}else if("400102".equals(pp.getKm())){
				if(!"挂账期初数".equals(pp.getZymc())){
					sum400102df+=pp.getDfje();
					sum400102jf+=pp.getJfje();	
				}
			}else if("4201".equals(pp.getKm())){
				sum4201df+=pp.getDfje();
				sum4201jf+=pp.getJfje();
			}else if("4301".equals(pp.getKm())){
				sum4301df+=pp.getDfje();
				sum4301jf+=pp.getJfje();
			}else if("5001".equals(pp.getKm())){
				sum5001df+=pp.getDfje();
				sum5001jf+=pp.getJfje();
			}else if("5101".equals(pp.getKm())){
				sum5101df+=pp.getDfje();
				sum5101jf+=pp.getJfje();
			}else if("4101".equals(pp.getKm())){
				sum4101df+=pp.getDfje();
				sum4101jf+=pp.getJfje();
			}else if("4102".equals(pp.getKm())){
				sum4102df+=pp.getDfje();
				sum4102jf+=pp.getJfje();
			}else if("4901".equals(pp.getKm())){
				sum4901df+=pp.getDfje();
				sum4901jf+=pp.getJfje();
			}else if("5901".equals(pp.getKm())){
				sum5901df+=pp.getDfje();
				sum5901jf+=pp.getJfje();
			}else if("3101".equals(pp.getKm())){
				sum3101df+=pp.getDfje();
				sum3101jf+=pp.getJfje();
			}
		}
		// --------------------第四行：(一)+(二)+(三)
		Double bm4wx = 0.0;
		Double bm4dfp = 0.0;
		// ----------------------第八行：三+四
		Double bm3wx = 0.0;
		Double bm3dfp = 0.0;
		for (YwpzEntity y : list) {
			if ("1".equals(y.getBm())) {// 第一行
				if ("2020".equals(datestr)) {
					// 说明若上年是2020年，则直接取表里的值(要将2020-12月份的值直接存入表中)，
				} else {
					// 若是2021年及以后的，都通过科目余额表算上年余额（属性是贷方，加贷减借=累计贷方-累计借方）
					// 查上年3001的期初
					Double sumljdf = 0.0;
					Double sumljjf = 0.0;
					Double sumljdf2 = 0.0;
					Double sumljjf2 = 0.0;
					for (HKmyeEntity p : list1) {
						if ("300101".equals(p.getHskmdm()) || "300102".equals(p.getHskmdm())
								|| "300103".equals(p.getHskmdm()) || "300104".equals(p.getHskmdm())) {
							if (p.getLjdfje() != null) {
								sumljdf += p.getLjdfje();
							}
							if (p.getLjjfje() != null) {
								sumljjf += p.getLjjfje();
							}
						} else if ("3101".equals(p.getHskmdm())) {
							if (p.getLjdfje() != null) {
								sumljdf2 += p.getLjdfje();
							}
							if (p.getLjjfje() != null) {
								sumljjf2 += p.getLjjfje();
							}
						}
					}
					Double spwxzj = sumljdf - sumljjf;
					Double dfpwxzj = sumljdf2 - sumljjf2;
					if (spwxzj != 0) {
						y.setSpzzwxzj(spwxzj);
					}else{
						y.setSpzzwxzj(null);
					}
					if (dfpwxzj != 0) {
						y.setDfpljsy(dfpwxzj);
					}else{
						y.setDfpljsy(null);
					}
				}
			} else if ("3".equals(y.getBm())) {
				Double sumqcye = 0.0;
				Double sumqcye2 = 0.0;
				for (HKmyeEntity p : list2) {
					if ("300101".equals(p.getHskmdm()) || "300102".equals(p.getHskmdm())
							|| "300103".equals(p.getHskmdm()) || "300104".equals(p.getHskmdm())) {
						if (p.getQcye() != null) {
							sumqcye += p.getQcye();
						}
					} else if ("3101".equals(p.getHskmdm())) {
						if (p.getQcye() != null) {
							sumqcye2 += p.getQcye();
						}
					}
				}
				if (sumqcye != 0) {
					y.setSpzzwxzj(sumqcye);
					bm3wx = bm3wx + sumqcye;
				}
				if (sumqcye2 != 0) {
					y.setDfpljsy(sumqcye2);
					bm3dfp = bm3dfp + sumqcye2;
				}
			} else if ("5".equals(y.getBm())) {
				Double sumje = 0.0;
				Double sumje2 = 0.0;
				sumje=sum400101df+sum400102df+sum4201df+sum4301df-sum5001jf-sum5101jf;
				sumje2=sum4101df+sum4102df+sum4901df-sum5901jf;
				if (sumje != 0) {
					y.setSpzzwxzj(sumje);
					bm4wx = bm4wx + sumje;
				}
				if (sumje2 != 0) {
					y.setDfpljsy(sumje2);
					bm4dfp = bm4dfp + sumje2;
				}
			} else if ("6".equals(y.getBm())) {
				Double sum1 = 0.0;
				Double sum2 = 0.0;
//				sum1=sum3101df;
				sum1=sum3101jf;
				if (sum1 != 0) {
					y.setSpzzwxzj(sum1);
					bm4wx = bm4wx + sum1;
				}
				if (sum2 != 0) {
					y.setDfpljsy(sum2);
					bm4dfp = bm4dfp + sum2;
				}
			} else if ("7".equals(y.getBm())) {
				Double sumje = 0.0;
				Double sumje2 = 0.0;
//				sumje=sum400101jf+sum4201jf+sum4301jf-sum5001df-sum5101df;
//				sumje2=sum4101jf+sum4102jf+sum4901jf-sum5901df;
				if (sumje != 0) {
					y.setSpzzwxzj(sumje);
					bm4wx = bm4wx + sumje;
				}
				if (sumje2 != 0) {
					y.setDfpljsy(sumje2);
					bm4dfp = bm4dfp + sumje2;
				}
			}
		}
		for (YwpzEntity y2 : list) {
			if ("4".equals(y2.getBm())) {
				if (bm4wx != 0) {
					y2.setSpzzwxzj(bm4wx);
				}
				if (bm4dfp != 0) {
					y2.setDfpljsy(bm4dfp);
				}
			} else if ("8".equals(y2.getBm())) {
				Double bm8sumwx = bm3wx + bm4wx;
				Double bm8sumdfp = bm3dfp + bm4dfp;
				if (bm8sumwx != 0) {
					y2.setSpzzwxzj(bm8sumwx);
				}
				if (bm8sumdfp != 0) {
					y2.setDfpljsy(bm8sumdfp);
				}
			}
		}

		return list;
	}

	@Override
	public int QMJZ(HPzEntity hPzEntity) {
		if ("400101".equals(hPzEntity.getKm())) {
			HKmyeEntity e0 = new HKmyeEntity();
			e0.setKjqj(hPzEntity.getPzrq().substring(0, 7));
			e0.setHskmdm("400101");
			e0.setQmjz("1");
			baseMapper.updatekmye(e0);
			// ------------------------------------------------------------------------------------------1.交存收入科目(400101)期末结转
			// a.通过所选择的凭证日期，查h_pz表中凭证日期该年月的400101科目的贷方发生额
			HPzEntity p = new HPzEntity();
			p.setKjqj(hPzEntity.getPzrq().substring(0, 7));
			p.setKm("400101");
			HPzEntity p1 = baseMapper.selectpzkm(p);
			// b.然后将该发生额复制到h_kmye表的商品住宅维修资金300101科目的贷方发生额中
			if (isObjectNotEmpty(p1)) {
				HKmyeEntity e = new HKmyeEntity();
				e.setKjqj(hPzEntity.getPzrq().substring(0, 7));
				e.setHskmdm("300101");
				HKmyeEntity e1 = new HKmyeEntity();
				e1.setKjqj(hPzEntity.getPzrq().substring(0, 7));
				e1.setHskmdm("300101");
				if (p1.getDfje() != null) {
					e1.setDfje(p1.getDfje());
				}
				baseMapper.updatekmye(e1);
				if (p1.getDfje() != null) {
					// c.然后在h_kmye表本身的400101科目上的借方发生额补上复制过去的贷方发生和，使其借贷平衡，始终保证400101科目没有余额
					HKmyeEntity e2 = new HKmyeEntity();
					e2.setKjqj(hPzEntity.getPzrq().substring(0, 7));
					e2.setHskmdm("400101");
					e2.setJfje(p1.getDfje());
					baseMapper.updatekmye(e2);
					hPzEntity.setJe(p1.getDfje());// 为了生成结转凭证记录的发生额
				}
				// d.最后生成结转的凭证，保证凭证平衡
				QMHZPZSC(hPzEntity);

			}
			// ------------------------------------------------------------------------------------------
		}else if ("400102".equals(hPzEntity.getKm())) {
			HKmyeEntity e0 = new HKmyeEntity();
			e0.setKjqj(hPzEntity.getPzrq().substring(0, 7));
			e0.setHskmdm("400102");
			e0.setQmjz("1");
			baseMapper.updatekmye(e0);
			// ------------------------------------------------------------------------------------------1.交存收入科目(400102)期末结转
			// a.通过所选择的凭证日期，查h_pz表中凭证日期该年月的400102科目的贷方发生额
			HPzEntity p = new HPzEntity();
			p.setKjqj(hPzEntity.getPzrq().substring(0, 7));
			p.setKm("400102");
			HPzEntity p1 = baseMapper.selectpzkm(p);
			// b.然后将该发生额复制到h_kmye表的商品住宅维修资金300101科目的贷方发生额中
			if (isObjectNotEmpty(p1)) {
				HKmyeEntity e = new HKmyeEntity();
				e.setKjqj(hPzEntity.getPzrq().substring(0, 7));
				e.setHskmdm("300102");
				HKmyeEntity e1 = new HKmyeEntity();
				e1.setKjqj(hPzEntity.getPzrq().substring(0, 7));
				e1.setHskmdm("300102");
				if (p1.getDfje() != null) {
					e1.setDfje(p1.getDfje());
				}
				baseMapper.updatekmye(e1);
				if (p1.getDfje() != null) {
					// c.然后在h_kmye表本身的400102科目上的借方发生额补上复制过去的贷方发生和，使其借贷平衡，始终保证400101科目没有余额
					HKmyeEntity e2 = new HKmyeEntity();
					e2.setKjqj(hPzEntity.getPzrq().substring(0, 7));
					e2.setHskmdm("400102");
					e2.setJfje(p1.getDfje());
					baseMapper.updatekmye(e2);
					hPzEntity.setJe(p1.getDfje());// 为了生成结转凭证记录的发生额
				}
				// d.最后生成结转的凭证，保证凭证平衡
				QMHZPZSC(hPzEntity);

			}
			// ------------------------------------------------------------------------------------------
		} else if ("5001".equals(hPzEntity.getKm())) {
			HKmyeEntity e0 = new HKmyeEntity();
			e0.setKjqj(hPzEntity.getPzrq().substring(0, 7));
			e0.setHskmdm("5001");
			e0.setQmjz("1");
			baseMapper.updatekmye(e0);
			// ------------------------------------------------------------------------------------------2.维修支出科目(5001)期末结转
			// a.通过所选择的凭证日期，查h_pz表中凭证日期该年月的5001科目的贷方发生额
			HPzEntity p = new HPzEntity();
			p.setKjqj(hPzEntity.getPzrq().substring(0, 7));
			p.setKm("5001");
			HPzEntity p1 = baseMapper.selectpzkm(p);
			// b.然后将该发生额复制到h_kmye表的商品住宅维修资金5001科目的借方发生额中
			if (isObjectNotEmpty(p1)) {
				HKmyeEntity e = new HKmyeEntity();
				e.setKjqj(hPzEntity.getPzrq().substring(0, 7));
				e.setHskmdm("300101");
				HKmyeEntity e1 = new HKmyeEntity();
				e1.setKjqj(hPzEntity.getPzrq().substring(0, 7));
				e1.setHskmdm("300101");
				if (p1.getJfje() != null) {
					e1.setJfje(p1.getJfje());
				}
				baseMapper.updatekmye(e1);
				if (p1.getJfje() != null) {
					// c.然后在h_kmye表本身的5001科目上的贷方发生额补上复制过去的借方发生和，使其借贷平衡，始终保证5001科目没有余额
					HKmyeEntity e2 = new HKmyeEntity();
					e2.setKjqj(hPzEntity.getPzrq().substring(0, 7));
					e2.setHskmdm("5001");
					e2.setDfje(p1.getJfje());
					baseMapper.updatekmye(e2);
					hPzEntity.setJe(p1.getJfje());// 为了生成结转凭证记录的发生额
				}
				// d.最后生成结转的凭证，保证凭证平衡
				QMHZPZSC(hPzEntity);
			}
			// ------------------------------------------------------------------------------------------
		} else if ("5101".equals(hPzEntity.getKm())) {
			HKmyeEntity e0 = new HKmyeEntity();
			e0.setKjqj(hPzEntity.getPzrq().substring(0, 7));
			e0.setHskmdm("5101");
			e0.setQmjz("1");
			baseMapper.updatekmye(e0);
			// ------------------------------------------------------------------------------------------3.返还支出科目(5101)期末结转
			// a.通过所选择的凭证日期，查h_pz表中凭证日期该年月的5101科目的贷方发生额
			HPzEntity p = new HPzEntity();
			p.setKjqj(hPzEntity.getPzrq().substring(0, 7));
			p.setKm("5101");
			HPzEntity p1 = baseMapper.selectpzkm(p);
			// b.然后将该发生额复制到h_kmye表的商品住宅维修资金5101科目的借方发生额中
			if (isObjectNotEmpty(p1)) {
				HKmyeEntity e = new HKmyeEntity();
				e.setKjqj(hPzEntity.getPzrq().substring(0, 7));
				e.setHskmdm("300101");
				HKmyeEntity e1 = new HKmyeEntity();
				e1.setKjqj(hPzEntity.getPzrq().substring(0, 7));
				e1.setHskmdm("300101");
				if (p1.getJfje() != null) {
					e1.setJfje(p1.getJfje());
				}
				baseMapper.updatekmye(e1);
				if (p1.getJfje() != null) {
					// c.然后在h_kmye表本身的5101科目上的贷方发生额补上复制过去的借方发生和，使其借贷平衡，始终保证5101科目没有余额
					HKmyeEntity e2 = new HKmyeEntity();
					e2.setKjqj(hPzEntity.getPzrq().substring(0, 7));
					e2.setHskmdm("5101");
					e2.setDfje(p1.getJfje());
					baseMapper.updatekmye(e2);
					hPzEntity.setJe(p1.getJfje());// 为了生成结转凭证记录的发生额
				}
				// d.最后生成结转的凭证，保证凭证平衡
				QMHZPZSC(hPzEntity);
			}
			// ------------------------------------------------------------------------------------------
		}
		return 0;
	}

	/**
	 * 期末结转凭证生成公共方法
	 * 
	 * @param hPzEntity
	 */
	public void QMHZPZSC(HPzEntity hPzEntity) {
		// =============================
		// 2.生成凭证号(取当前会计期间最大凭证号+1)：
		int pzh = 0;
		// ------------------------------------
		// 处理凭证号插空问题
		List<String> lpzhgs = baseMapper.selectkjqjpzhgs(hPzEntity.getPzrq().substring(0, 7));// 查此会计期间有多少条pzh
		String maxpzhck = baseMapper.selectmaxpzh(hPzEntity.getPzrq().substring(0, 7));// 查此会计期间最大pzh
		if (lpzhgs.isEmpty()) {
			String maxpzh = baseMapper.selectmaxpzh(hPzEntity.getPzrq().substring(0, 7));
			if ("".equals(maxpzh) || maxpzh == null) {
				pzh = 1;
			} else if (!"".equals(maxpzh) || maxpzh != null) {
				String aa = Integer.parseInt(maxpzh) + 1 + "";
				DecimalFormat df = new DecimalFormat("0");
				String result = df.format(Integer.parseInt(aa));
				pzh = Integer.parseInt(result);
			}
		} else {
			int maxPZH = Integer.parseInt(maxpzhck);
			if (maxPZH == lpzhgs.size()) {// 如果相等则表示该会计期间pzh没有断号，则按pzh+1规则来生成pzh
				String maxpzh = baseMapper.selectmaxpzh(hPzEntity.getPzrq().substring(0, 7));
				if ("".equals(maxpzh) || maxpzh == null) {
					pzh = 1;
				} else if (!"".equals(maxpzh) || maxpzh != null) {
					String aa = Integer.parseInt(maxpzh) + 1 + "";
					DecimalFormat df = new DecimalFormat("0");
					String result = df.format(Integer.parseInt(aa));
					pzh = Integer.parseInt(result);
				}
			} else {// 不相等则表示存在断号，需先补漏，全部补完了不断号之后再按pzh+1规则来生成pzh
				for (int i = 1; i <= maxPZH; i++) {
					if (lpzhgs.contains(i + "")) {

					} else {
						pzh = i;
						break;
					}
				}
			}
		}
		// 借方
		int flxh = 1;
		HPzEntity hPzEntityjf = new HPzEntity();
		hPzEntityjf.setGzdbm("0001");
		hPzEntityjf.setKjqj(hPzEntity.getPzrq().substring(0, 7));
		hPzEntityjf.setPzh(pzh);
		hPzEntityjf.setFlxh(flxh);
		// ------系统日期
		String temp_strx = "";
		Date dtx = new Date();
		SimpleDateFormat sdfx = new SimpleDateFormat("yyyy-MM-dd");
		temp_strx = sdfx.format(dtx);
		hPzEntityjf.setPzrq(hPzEntity.getPzrq());
		hPzEntityjf.setFjzs(0);
		if ("400101".equals(hPzEntity.getKm())) {
			hPzEntityjf.setZymc("已处理交存收入结转");
		}else if ("400102".equals(hPzEntity.getKm())) {
			hPzEntityjf.setZymc("待处理交存收入结转");
		} else if ("5001".equals(hPzEntity.getKm())) {
			hPzEntityjf.setZymc("维修支出结转");
		} else if ("5101".equals(hPzEntity.getKm())) {
			hPzEntityjf.setZymc("返还支出结转");
		}
		// ----------------------------------------------------记录摘要
		String maxzybm1 = baseMapper.selectmaxzybm();
		String newzybm1 = "";
		if ("".equals(maxzybm1) || maxzybm1 == null) {
			newzybm1 = "0001";
		} else if (!"".equals(maxzybm1) && maxzybm1 != null) {
			String aa = Integer.parseInt(maxzybm1) + 1 + "";
			DecimalFormat df = new DecimalFormat("0000");
			String result = df.format(Integer.parseInt(aa));
			newzybm1 = result;
		}
		HZyEntity zy1 = new HZyEntity();
		zy1.setZybm(newzybm1);
		if ("400101".equals(hPzEntity.getKm())) {
			zy1.setZymc("已处理交存收入结转");
		}else if ("400102".equals(hPzEntity.getKm())) {
			zy1.setZymc("待处理交存收入结转");
		} else if ("5001".equals(hPzEntity.getKm())) {
			zy1.setZymc("维修支出结转");
		} else if ("5101".equals(hPzEntity.getKm())) {
			zy1.setZymc("返还支出结转");
		}
		zy1.setZtbm("0003");
		baseMapper.insertzy(zy1);
		// -------------------------------------------------------
		if ("400101".equals(hPzEntity.getKm())) {
			hPzEntityjf.setKm("400101");
		}else if ("400102".equals(hPzEntity.getKm())) {
			hPzEntityjf.setKm("400102");
		} else if ("5001".equals(hPzEntity.getKm())) {
			hPzEntityjf.setKm("300101");
		} else if ("5101".equals(hPzEntity.getKm())) {
			hPzEntityjf.setKm("300101");
		}
		if ("400101".equals(hPzEntity.getKm())) {
			hPzEntityjf.setJfje(hPzEntity.getJe());
			hPzEntityjf.setDfje(0.0);
		}else if ("400102".equals(hPzEntity.getKm())) {
			hPzEntityjf.setJfje(hPzEntity.getJe());
			hPzEntityjf.setDfje(0.0);
		} else if ("5001".equals(hPzEntity.getKm())) {
			hPzEntityjf.setJfje(hPzEntity.getJe());
			hPzEntityjf.setDfje(0.0);
		} else if ("5101".equals(hPzEntity.getKm())) {
			hPzEntityjf.setJfje(hPzEntity.getJe());
			hPzEntityjf.setDfje(0.0);
		}
		hPzEntityjf.setSfsh("0");
		hPzEntityjf.setSfjz("0");
		hPzEntityjf.setLrfs("1");
		hPzEntityjf.setYwlx("66");
		hPzEntityjf.setYwbh("6666");
		hPzEntityjf.setZdrbm(hPzEntity.getZdrbm());
		String temp_str = "";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		temp_str = sdf.format(dt);
		hPzEntityjf.setZdsj(temp_str);
		hPzEntityjf.setZtbm("0003");
		hPzEntityjf.setPztype("记账");
		hPzEntityjf.setJzsj(temp_str);
		hPzEntityjf.setZdrmc(hPzEntity.getZdrmc());
		baseMapper.inserthpzjf(hPzEntityjf);
		flxh = flxh + 1;
		// 将辅助核算明细中该单据的pzh和cwkjqj刷进去
		baseMapper.updatefzhsmxdw(hPzEntityjf);

		// 贷方
		HPzEntity l = new HPzEntity();
		l.setKjqj(hPzEntity.getPzrq().substring(0, 7));
		l.setPzh(pzh);
		flxh = baseMapper.selectmaxflxh(l);// 获取当前会计期间当前凭证号的最大flxh+1的值
		HPzEntity hPzEntityjf2 = new HPzEntity();
		hPzEntityjf2.setGzdbm("0001");
		hPzEntityjf2.setKjqj(hPzEntity.getPzrq().substring(0, 7));
		hPzEntityjf2.setPzh(pzh);
		hPzEntityjf2.setFlxh(flxh);
		hPzEntityjf2.setPzrq(hPzEntity.getPzrq());
		hPzEntityjf2.setFjzs(0);
		if ("400101".equals(hPzEntity.getKm())) {
			hPzEntityjf2.setZymc("已处理交存收入结转");
		}else if ("400102".equals(hPzEntity.getKm())) {
			hPzEntityjf2.setZymc("待处理交存收入结转");
		} else if ("5001".equals(hPzEntity.getKm())) {
			hPzEntityjf2.setZymc("维修支出结转");
		} else if ("5101".equals(hPzEntity.getKm())) {
			hPzEntityjf2.setZymc("返还支出结转");
		}
		if ("400101".equals(hPzEntity.getKm())) {
			hPzEntityjf2.setKm("300101");
		}else if ("400102".equals(hPzEntity.getKm())) {
			hPzEntityjf2.setKm("300102");
		} else if ("5001".equals(hPzEntity.getKm())) {
			hPzEntityjf2.setKm("5001");
		} else if ("5101".equals(hPzEntity.getKm())) {
			hPzEntityjf2.setKm("5101");
		}
		if ("400101".equals(hPzEntity.getKm())) {
			hPzEntityjf2.setJfje(0.0);
			hPzEntityjf2.setDfje(hPzEntity.getJe());
		}else if ("400102".equals(hPzEntity.getKm())) {
			hPzEntityjf2.setJfje(0.0);
			hPzEntityjf2.setDfje(hPzEntity.getJe());
		} else if ("5001".equals(hPzEntity.getKm())) {
			hPzEntityjf2.setJfje(0.0);
			hPzEntityjf2.setDfje(hPzEntity.getJe());
		} else if ("5101".equals(hPzEntity.getKm())) {
			hPzEntityjf2.setJfje(0.0);
			hPzEntityjf2.setDfje(hPzEntity.getJe());
		}
		hPzEntityjf2.setSfsh("0");
		hPzEntityjf2.setSfjz("0");
		hPzEntityjf2.setLrfs("1");
		hPzEntityjf2.setYwlx("66");
		hPzEntityjf2.setYwbh("6666");
		hPzEntityjf2.setZdrbm(hPzEntity.getZdrbm());
		hPzEntityjf2.setZdsj(temp_str);
		hPzEntityjf2.setZtbm("0003");
		hPzEntityjf2.setJzsj(temp_str);
		hPzEntityjf2.setPztype("记账");
		hPzEntityjf2.setZdrmc(hPzEntity.getZdrmc());
		baseMapper.inserthpzjf(hPzEntityjf2);
		// =============================
	}

	@Override
	public List<HKmyeEntity> YJQQMJZ(HKmyeEntity hKmyeEntity) {

		return baseMapper.YJQQMJZ(hKmyeEntity);
	}

}