package io.renren.modules.app.service.impl;


import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.HZyDao;
import io.renren.modules.app.entity.HZyEntity;
import io.renren.modules.app.service.HZyService;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;


@Service("hZyService")
public class HZyServiceImpl extends ServiceImpl<HZyDao, HZyEntity> implements HZyService {


    /**
     * 分页模糊查询
     * @param pageNum
     * @param pageSize
     * @param hZyEntity
     * @return
     */
    @Override
    public PageInfo<HZyEntity> queryByPage(Integer pageNum, Integer pageSize, HZyEntity hZyEntity) {
        PageHelper.startPage(pageNum, pageSize);
        List<HZyEntity> hZyEntitys = baseMapper.queryByPage(hZyEntity);
        PageInfo<HZyEntity> pageInfo = new PageInfo<HZyEntity>(hZyEntitys);
        return pageInfo;
    }

    /**
    * 单个或批量删除
    * @param ids
    */
    @Override
    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }

	@Override
	public HZyEntity selectzy(HZyEntity hZyEntity) {
		
		return baseMapper.selectzy(hZyEntity);
	}


}