package io.renren.modules.app.service.impl;


import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.JcbzDao;
import io.renren.modules.app.entity.JcbzEntity;
import io.renren.modules.app.service.JcbzService;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;


@Service("jcbzService")
public class JcbzServiceImpl extends ServiceImpl<JcbzDao, JcbzEntity> implements JcbzService {


    /**
     * 分页模糊查询
     * @param pageNum
     * @param pageSize
     * @param jcbzEntity
     * @return
     */
    @Override
    public PageInfo<JcbzEntity> queryByPage(Integer pageNum, Integer pageSize, JcbzEntity jcbzEntity) {
        PageHelper.startPage(pageNum, pageSize);
        List<JcbzEntity> jcbzEntitys = baseMapper.queryByPage(jcbzEntity);
        PageInfo<JcbzEntity> pageInfo = new PageInfo<JcbzEntity>(jcbzEntitys);
        return pageInfo;
    }

    /**
    * 单个或批量删除
    * @param ids
    */
    @Override
    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }

	@Override
	public String queryjcbzbm() {
		
		return baseMapper.queryjcbzbm();
	}


}