package io.renren.modules.app.service.impl;


import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.LlbDao;
import io.renren.modules.app.entity.LlbEntity;
import io.renren.modules.app.service.LlbService;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;


@Service("llbService")
public class LlbServiceImpl extends ServiceImpl<LlbDao, LlbEntity> implements LlbService {


    /**
     * 分页模糊查询
     * @param pageNum
     * @param pageSize
     * @param llbEntity
     * @return
     */
    @Override
    public PageInfo<LlbEntity> queryByPage(Integer pageNum, Integer pageSize, LlbEntity llbEntity) {
        PageHelper.startPage(pageNum, pageSize);
        List<LlbEntity> llbEntitys = baseMapper.queryByPage(llbEntity);
        PageInfo<LlbEntity> pageInfo = new PageInfo<LlbEntity>(llbEntitys);
        return pageInfo;
    }

    /**
    * 单个或批量删除
    * @param ids
    */
    @Override
    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }

	@Override
	public String querybm() {
		
		return baseMapper.querybm();
	}


}