package io.renren.modules.app.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import io.renren.modules.app.dao.LpqcDao;
import io.renren.modules.app.entity.DyxxEntity;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.LpqcEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.LpqcService;
import org.springframework.stereotype.Service;
import java.util.List;
import java.util.Map;

@Service("lpqcService")
public class LpqcServiceImpl extends ServiceImpl<LpqcDao, LpqcEntity> implements LpqcService {

	//楼盘清册导入
	@Override
	public void insertLpqcdr(Map<String, Object> map) {
		Map<String,Object> lpqc = map;
		List<LpqcEntity> list = (List<LpqcEntity>)map.get("datalist");
		String dwbm = map.get("dwbm").toString();
		String xqbm = map.get("xqbm").toString();
		String xmbm = map.get("xmbm").toString();
		System.out.println();
	}

	/**
	 * 查询栋号编码
	 * @param xmbm
	 * @param dhmc
	 * @return
	 */
	@Override
	public String selectDhbm(String xmbm, String dhmc) {
		return baseMapper.selectDhbm(xmbm,dhmc);
	}

	/**
	 * 插入房屋信息
	 * @param fwxxEntity
	 */
	@Override
	public void insertFwxx(FwxxEntity fwxxEntity) {
		baseMapper.insertFwxx(fwxxEntity);
	}
	/**
	 * 插入房屋信息
	 */
	@Override
	public void insertFwxxList(List<FwxxEntity> fwxxEntityList) {
		baseMapper.insertFwxxList(fwxxEntityList);
	}

	/**
	 * 获取房屋编码
	 * @return
	 */
	@Override
	public String querydhbm() {
		return baseMapper.querydhbm();
	}

	@Override
	public String selectDhbm2() {
		return baseMapper.selectDhbm2();
	}

	/**
	 * 获取房屋性质ID
	 * @param value
	 * @return
	 */
	@Override
	public String selectFwxzID(String value,String type) {
		return baseMapper.selectFwxzID(value,type);
	}

	@Override
	public String selectDybm(String dhbm, String dymc) {
		return baseMapper.selectDybm(dhbm,dymc);
	}

	@Override
	public void insertDyxx(DyxxEntity dyxxEntity) {
		baseMapper.insertDyxx(dyxxEntity);
	}

	@Override
	public void updateLcs() {
		baseMapper.updateLcs();
	}

	@Override
	public Integer selectDhmc(String xmbm, String dhmc) {
		return baseMapper.selectDhmc(xmbm,dhmc);
	}

	@Override
	public List<Integer> selectdhbmbyxmdh(ZhxxEntity zhxxEntity) {
		
		return baseMapper.selectdhbmbyxmdh(zhxxEntity);
	}

	@Override
	public void updatezhxxlcs(ZhxxEntity zhxxEntity) {
		
		baseMapper.updatezhxxlcs(zhxxEntity);
	}

	@Override
	public ZhxxEntity selectdhbmbymc(ZhxxEntity zhxxEntity) {
		
		return baseMapper.selectdhbmbymc(zhxxEntity);
	}

	@Override
	public String selectdhbmfwbm(ZhxxEntity zhxxEntity) {
		
		return baseMapper.selectdhbmfwbm(zhxxEntity);
	}

	@Override
	public FwxxEntity selectfwxx(String id) {
		
		return baseMapper.selectfwxx(id);
	}
}